/*
 * Decompiled with CFR 0.152.
 */
package mork;

import java.io.IOException;
import java.io.PrintStream;
import java.io.StringReader;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import mork.Alias;
import mork.Dict;
import mork.ScopeTypes;

public class Aliases {
    private Map<String, Alias> dict = new HashMap<String, Alias>();

    public Aliases(String aliases) {
        this(aliases, Dict.EMPTY_LIST);
    }

    public Aliases(String aliases, List<Dict> dicts) {
        StringReader reader = new StringReader(aliases);
        StringBuffer alias = new StringBuffer();
        boolean inParentheses = false;
        try {
            int c = reader.read();
            while (c != -1) {
                switch (c) {
                    case 92: {
                        int escapedCharacter = reader.read();
                        alias.append((char)escapedCharacter);
                        break;
                    }
                    case 40: {
                        inParentheses = true;
                        alias.append((char)c);
                        break;
                    }
                    case 41: {
                        if (!inParentheses) break;
                        alias.append((char)c);
                        this.parseSingleAlias(dicts, alias.toString().trim());
                        alias.setLength(0);
                        inParentheses = false;
                        break;
                    }
                    default: {
                        if (!inParentheses) break;
                        alias.append((char)c);
                    }
                }
                c = reader.read();
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Format of alias not supported: " + aliases);
        }
    }

    public Aliases() {
    }

    private void parseSingleAlias(List<Dict> dicts, String aliasStr) {
        boolean isLiteral;
        if (aliasStr.length() < 3) {
            throw new RuntimeException("Alias must be at least 3 characters: " + aliasStr);
        }
        String withoutParentheses = aliasStr.substring(1, aliasStr.length() - 1);
        boolean bl = isLiteral = withoutParentheses.indexOf(61) != -1;
        if (isLiteral) {
            String refid = aliasStr.substring(1, aliasStr.indexOf(61));
            String id = refid;
            if (id.startsWith("^")) {
                id = Dict.dereference(id, dicts, ScopeTypes.COLUMN_SCOPE);
            }
            String value = aliasStr.substring(aliasStr.indexOf(61) + 1, aliasStr.length() - 1);
            Alias alias = new Alias(refid, id, value, null);
            this.dict.put(id.trim(), alias);
        } else {
            String refid;
            String id = refid = aliasStr.substring(1, aliasStr.indexOf(94, 2));
            String valueref = aliasStr.substring(aliasStr.indexOf(94, 2), aliasStr.length() - 1);
            if (id.startsWith("^")) {
                id = Dict.dereference(id, dicts, ScopeTypes.COLUMN_SCOPE);
            }
            String value = valueref;
            if (valueref.startsWith("^")) {
                value = Dict.dereference(value, dicts, ScopeTypes.ATOM_SCOPE);
            }
            Alias alias = new Alias(refid, id, value, valueref);
            this.dict.put(id.trim(), alias);
        }
    }

    public int count() {
        return this.dict.size();
    }

    public Map<String, Alias> getAliases() {
        return Collections.unmodifiableMap(this.dict);
    }

    public void printAliases(PrintStream out) {
        out.println(this.dict);
    }

    public Set<String> getKeySet() {
        return this.dict.keySet();
    }

    public String getValue(String id) {
        Alias alias = this.dict.get(id.trim());
        if (alias != null) {
            return alias.getValue();
        }
        return null;
    }

    public Alias getAlias(String id) {
        return this.dict.get(id.trim());
    }
}

