/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.jabber;

import net.java.sip.communicator.impl.protocol.jabber.ProtocolProviderServiceJabberImpl;
import net.java.sip.communicator.service.protocol.OperationFailedException;
import net.java.sip.communicator.service.protocol.OperationSetChangePassword;
import net.java.sip.communicator.util.Logger;
import org.jivesoftware.smack.AccountManager;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smackx.packet.DiscoverInfo;

public class OperationSetChangePasswordJabberImpl
implements OperationSetChangePassword {
    private ProtocolProviderServiceJabberImpl protocolProvider;
    private static final Logger logger = Logger.getLogger(OperationSetChangePasswordJabberImpl.class);

    OperationSetChangePasswordJabberImpl(ProtocolProviderServiceJabberImpl protocolProvider) {
        this.protocolProvider = protocolProvider;
    }

    public void changePassword(String newPass) throws IllegalStateException, OperationFailedException {
        AccountManager accountManager = new AccountManager(this.protocolProvider.getConnection());
        try {
            accountManager.changePassword(newPass);
        }
        catch (XMPPException e) {
            if (logger.isInfoEnabled()) {
                logger.info((Object)"Tried to change jabber password, but the server does not support inband password changes", (Throwable)e);
            }
            throw new OperationFailedException("In-band password changes not supported", 18, (Throwable)e);
        }
    }

    public boolean supportsPasswordChange() {
        try {
            DiscoverInfo discoverInfo = this.protocolProvider.getDiscoveryManager().discoverInfo(this.protocolProvider.getAccountID().getService());
            return discoverInfo.containsFeature("jabber:iq:register");
        }
        catch (Exception e) {
            if (logger.isInfoEnabled()) {
                logger.info((Object)"Exception occurred while trying to find out if inband registrations are supported. Returning trueanyway.");
            }
            return true;
        }
    }
}

