/*
 * Decompiled with CFR 0.152.
 */
package org.ice4j.ice;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.DatagramPacket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;
import org.ice4j.TransportAddress;
import org.ice4j.ice.CandidatePair;
import org.ice4j.ice.CandidatePairState;
import org.ice4j.ice.Component;
import org.ice4j.ice.LocalCandidate;
import org.ice4j.ice.RemoteCandidate;
import org.ice4j.socket.IceSocketWrapper;
import org.ice4j.socket.MergingDatagramSocket;

public class ComponentSocket
extends MergingDatagramSocket
implements PropertyChangeListener {
    private static final Logger classLogger = Logger.getLogger(MergingDatagramSocket.class.getName());
    private final Object authorizedAddressesSyncRoot = new Object();
    private Set<SocketAddress> authorizedAddresses = new HashSet<SocketAddress>();
    private Component component;
    private boolean initializedActive = false;
    private final Object initializedActiveSyncRoot = new Object();
    private final org.ice4j.util.Logger logger;

    ComponentSocket(Component component, org.ice4j.util.Logger levelDelegate) throws SocketException {
        super(levelDelegate);
        this.component = component;
        this.logger = new org.ice4j.util.Logger(classLogger, levelDelegate);
        component.getParentStream().addPairChangeListener(this);
    }

    @Override
    protected boolean accept(DatagramPacket p) {
        return this.authorizedAddresses.contains(p.getSocketAddress());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addAuthorizedAddress(SocketAddress address) {
        Object object = this.authorizedAddressesSyncRoot;
        synchronized (object) {
            if (this.authorizedAddresses.contains(address)) {
                return;
            }
            this.logger.info("Adding allowed address: " + address);
            HashSet<SocketAddress> newSet = new HashSet<SocketAddress>();
            newSet.addAll(this.authorizedAddresses);
            newSet.add(address);
            this.authorizedAddresses = newSet;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void propertyChange(PropertyChangeEvent event) {
        if (!(event.getSource() instanceof CandidatePair)) {
            return;
        }
        CandidatePair pair = (CandidatePair)event.getSource();
        if (!pair.getParentComponent().equals(this.component)) {
            return;
        }
        String propertyName = event.getPropertyName();
        if ("PairStateChanged".equals(propertyName)) {
            CandidatePairState newState = (CandidatePairState)((Object)event.getNewValue());
            if (CandidatePairState.SUCCEEDED.equals((Object)newState)) {
                this.addAuthorizedAddress(pair.getRemoteCandidate().getTransportAddress());
            }
        } else if ("PairNominated".equals(propertyName)) {
            Object object = this.initializedActiveSyncRoot;
            synchronized (object) {
                if (this.initializedActive) {
                    return;
                }
                LocalCandidate localCandidate = pair.getLocalCandidate();
                LocalCandidate base = (LocalCandidate)localCandidate.getBase();
                if (base != null) {
                    localCandidate = base;
                }
                TransportAddress remoteAddress = null;
                RemoteCandidate remoteCandidate = pair.getRemoteCandidate();
                if (remoteCandidate != null) {
                    remoteAddress = remoteCandidate.getTransportAddress();
                }
                IceSocketWrapper socketWrapper = localCandidate.getCandidateIceSocketWrapper(remoteAddress);
                this.initializeActive(socketWrapper, remoteAddress);
                this.initializedActive = true;
            }
        }
    }

    @Override
    public void close() {
        try {
            super.close();
        }
        finally {
            Component component = this.component;
            if (component != null) {
                component.getParentStream().removePairStateChangeListener(this);
                this.component = null;
            }
        }
    }
}

