/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.transform;

import org.jitsi.impl.neomedia.RTPPacketPredicate;
import org.jitsi.impl.neomedia.RawPacket;
import org.jitsi.impl.neomedia.codec.REDBlock;
import org.jitsi.impl.neomedia.codec.REDBlockIterator;
import org.jitsi.impl.neomedia.transform.PacketTransformer;
import org.jitsi.impl.neomedia.transform.SinglePacketTransformerAdapter;
import org.jitsi.impl.neomedia.transform.TransformEngine;
import org.jitsi.util.Logger;

public class REDFilterTransformEngine
extends SinglePacketTransformerAdapter
implements TransformEngine {
    private static final Logger logger = Logger.getLogger(REDFilterTransformEngine.class);
    private boolean enabled = false;
    private final byte redPayloadType;

    public REDFilterTransformEngine(byte redPayloadType) {
        super(RTPPacketPredicate.INSTANCE);
        this.redPayloadType = redPayloadType;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public PacketTransformer getRTPTransformer() {
        return this;
    }

    @Override
    public PacketTransformer getRTCPTransformer() {
        return null;
    }

    @Override
    public RawPacket transform(RawPacket pkt) {
        if (!this.enabled || this.redPayloadType == -1 || pkt == null || pkt.getPayloadType() != this.redPayloadType) {
            return pkt;
        }
        REDBlock pb = REDBlockIterator.getPrimaryBlock(pkt.getBuffer(), pkt.getPayloadOffset(), pkt.getPayloadLength());
        if (pb == null) {
            logger.warn("Ignoring RED packet with no primary block.");
            return pkt;
        }
        byte[] buf = pkt.getBuffer();
        int hdrLen = pkt.getHeaderLength();
        int off = pkt.getOffset();
        int len = pkt.getLength();
        pkt.setPayloadType(pb.getPayloadType());
        System.arraycopy(buf, off, buf, pb.getOffset() - hdrLen, hdrLen);
        pkt.setOffset(pb.getOffset() - hdrLen);
        pkt.setLength(len - (pb.getOffset() - hdrLen - off));
        return pkt;
    }
}

