/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.rtp;

import org.jitsi.impl.neomedia.MediaStreamImpl;
import org.jitsi.impl.neomedia.RTPPacketPredicate;
import org.jitsi.impl.neomedia.RawPacket;
import org.jitsi.impl.neomedia.rtp.RTPEncodingDesc;
import org.jitsi.util.Logger;
import org.jitsi.util.RTPUtils;

public class FrameDesc {
    private static final Logger logger = Logger.getLogger(FrameDesc.class);
    private final long receivedMs;
    private final RTPEncodingDesc rtpEncoding;
    private final long ts;
    private Boolean sofInOrder;
    private Boolean independent;
    private int minSeen = -1;
    private int maxSeen = -1;
    private int start = -1;
    private int end = -1;

    FrameDesc(RTPEncodingDesc rtpEncoding, long ts, long receivedMs) {
        this.rtpEncoding = rtpEncoding;
        this.ts = ts;
        this.receivedMs = receivedMs;
    }

    public RTPEncodingDesc getRTPEncoding() {
        return this.rtpEncoding;
    }

    public long getTimestamp() {
        return this.ts;
    }

    public long getReceivedMs() {
        return this.receivedMs;
    }

    int getEnd() {
        return this.end;
    }

    void setEnd(int end) {
        this.end = end;
    }

    public int getStart() {
        return this.start;
    }

    void setStart(int start) {
        this.start = start;
    }

    public boolean isIndependent() {
        return this.independent == null ? false : this.independent;
    }

    int getMinSeen() {
        return this.minSeen;
    }

    public int getMaxSeen() {
        return this.maxSeen;
    }

    public boolean matches(RawPacket pkt) {
        if (!RTPPacketPredicate.INSTANCE.test(pkt) || this.ts != pkt.getTimestamp() || this.minSeen == -1) {
            return false;
        }
        int seqNum = pkt.getSequenceNumber();
        return RTPUtils.sequenceNumberDiff(seqNum, this.minSeen) >= 0 && RTPUtils.sequenceNumberDiff(seqNum, this.maxSeen) <= 0;
    }

    boolean update(RawPacket pkt) {
        boolean changed = false;
        int seqNum = pkt.getSequenceNumber();
        byte[] buf = pkt.getBuffer();
        int off = pkt.getOffset();
        int len = pkt.getLength();
        MediaStreamImpl stream = this.rtpEncoding.getMediaStreamTrack().getMediaStreamTrackReceiver().getStream();
        boolean isSOF = stream.isStartOfFrame(buf, off, len);
        if (this.sofInOrder == null) {
            this.sofInOrder = isSOF;
        }
        if (this.minSeen == -1 || RTPUtils.sequenceNumberDiff(this.minSeen, seqNum) > 0) {
            changed = true;
            this.minSeen = seqNum;
        }
        if (this.maxSeen == -1 || RTPUtils.sequenceNumberDiff(this.maxSeen, seqNum) < 0) {
            changed = true;
            this.maxSeen = seqNum;
        }
        if (this.end == -1 && stream.isEndOfFrame(buf, off, len)) {
            changed = true;
            this.end = seqNum;
        }
        if (this.start == -1 && isSOF) {
            changed = true;
            this.start = seqNum;
            this.independent = stream.isKeyFrame(pkt);
            if (this.independent.booleanValue() && logger.isInfoEnabled()) {
                logger.info("keyframe,stream=" + stream.hashCode() + " ssrc=" + this.rtpEncoding.getPrimarySSRC() + "," + this.toString());
            }
        }
        return changed;
    }

    public String toString() {
        return "ts=" + this.ts + ",independent=" + this.independent + ",min_seen=" + this.minSeen + ",max_seen=" + this.maxSeen + ",start=" + this.start + ",end=" + this.end;
    }

    public boolean isSofInOrder() {
        return this.sofInOrder != null && this.sofInOrder != false;
    }
}

