/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.jmfext.media.protocol.rtpdumpfile;

import org.jitsi.impl.neomedia.RTPPacketPredicate;
import org.jitsi.impl.neomedia.RawPacket;
import org.jitsi.util.TimeUtils;

public class RawPacketScheduler {
    private final long clockRate;
    private long lastRtpTimestamp = -1L;

    public RawPacketScheduler(long clockRate) {
        this.clockRate = clockRate;
    }

    public void schedule(RawPacket rtpPacket) throws InterruptedException {
        if (!RTPPacketPredicate.INSTANCE.test(rtpPacket)) {
            return;
        }
        if (this.lastRtpTimestamp == -1L) {
            this.lastRtpTimestamp = rtpPacket.getTimestamp();
            return;
        }
        long previous = this.lastRtpTimestamp;
        this.lastRtpTimestamp = rtpPacket.getTimestamp();
        long rtpDiff = TimeUtils.rtpDiff(this.lastRtpTimestamp, previous);
        long nanos = rtpDiff * 1000L * 1000L * 1000L / this.clockRate;
        if (nanos > 0L) {
            Thread.sleep(nanos / 1000000L, (int)(nanos % 1000000L));
        }
    }
}

