/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.argdelegation;

import java.util.Collection;
import java.util.Hashtable;
import java.util.Map;
import net.java.sip.communicator.impl.argdelegation.ArgDelegationActivator;
import net.java.sip.communicator.service.argdelegation.UriHandler;
import net.java.sip.communicator.util.Logger;
import net.java.sip.communicator.util.ServiceUtils;
import net.java.sip.communicator.util.launchutils.ArgDelegationPeer;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;

public class ArgDelegationPeerImpl
implements ArgDelegationPeer,
ServiceListener {
    private static final Logger logger = Logger.getLogger(ArgDelegationPeerImpl.class);
    private final Map<String, UriHandler> uriHandlers = new Hashtable<String, UriHandler>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArgDelegationPeerImpl(BundleContext bundleContext) {
        Collection uriHandlerRefs = ServiceUtils.getServiceReferences((BundleContext)bundleContext, UriHandler.class);
        if (!uriHandlerRefs.isEmpty()) {
            Map<String, UriHandler> map = this.uriHandlers;
            synchronized (map) {
                for (ServiceReference uriHandlerRef : uriHandlerRefs) {
                    UriHandler uriHandler = (UriHandler)bundleContext.getService(uriHandlerRef);
                    for (String protocol : uriHandler.getProtocol()) {
                        this.uriHandlers.put(protocol, uriHandler);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serviceChanged(ServiceEvent event) {
        BundleContext bc = event.getServiceReference().getBundle().getBundleContext();
        if (bc == null) {
            return;
        }
        Object service = bc.getService(event.getServiceReference());
        if (!(service instanceof UriHandler)) {
            return;
        }
        UriHandler uriHandler = (UriHandler)service;
        Map<String, UriHandler> map = this.uriHandlers;
        synchronized (map) {
            switch (event.getType()) {
                case 1: 
                case 2: {
                    for (String protocol : uriHandler.getProtocol()) {
                        this.uriHandlers.put(protocol, uriHandler);
                    }
                    break;
                }
                case 4: {
                    for (String protocol : uriHandler.getProtocol()) {
                        if (this.uriHandlers.get(protocol) != uriHandler) continue;
                        this.uriHandlers.remove(protocol);
                    }
                    break;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleUri(String uriArg) {
        UriHandler handler;
        int colonIndex;
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Handling URI: " + uriArg));
        }
        if ((colonIndex = uriArg.indexOf(":")) == -1) {
            ArgDelegationActivator.getUIService().getPopupDialog().showMessagePopupDialog((Object)("Could not determine how to handle: " + uriArg + ".\nNo protocol scheme found."), "Error handling URI", 0);
            return;
        }
        String scheme = uriArg.substring(0, colonIndex);
        Map<String, UriHandler> map = this.uriHandlers;
        synchronized (map) {
            handler = this.uriHandlers.get(scheme);
        }
        if (handler == null) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Couldn't open " + uriArg + "No handler found for protocol" + scheme));
            }
            ArgDelegationActivator.getUIService().getPopupDialog().showMessagePopupDialog((Object)("\"" + scheme + "\" URIs are currently not supported."), "Error handling URI", 0);
            return;
        }
        try {
            handler.handleUri(uriArg);
        }
        catch (Throwable thr) {
            if (thr instanceof ThreadDeath) {
                throw (ThreadDeath)thr;
            }
            ArgDelegationActivator.getUIService().getPopupDialog().showMessagePopupDialog((Object)("Error handling " + uriArg), "Error handling URI", 0);
            logger.error((Object)("Failed to handle \"" + uriArg + "\""), thr);
        }
    }

    public void handleConcurrentInvocationRequest() {
        ArgDelegationActivator.getUIService().setVisible(true);
    }
}

