/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.util;

import com.google.gdata.util.ErrorContent;
import com.google.gdata.util.common.base.Preconditions;

public class ErrorElement
implements ErrorContent {
    private String errorDomainName;
    private String errorCodeName;
    private String errorLocation;
    private ErrorContent.LocationType errorLocationType;
    private String errorInternalReason;
    private String errorExtendedHelp;
    private String errorSendReport;
    private String errorDebugInfo;
    private static final String GOOGLE_URI_PATTERN = "http://.*google\\.com/.*";

    ErrorElement() {
    }

    ErrorElement(ErrorContent source) {
        this.errorDomainName = source.getDomainName();
        this.errorCodeName = source.getCodeName();
        this.errorLocation = source.getLocation();
        this.errorLocationType = source.getLocationType();
        this.errorInternalReason = source.getInternalReason();
        this.errorExtendedHelp = source.getExtendedHelp();
        this.errorSendReport = source.getSendReport();
        this.errorDebugInfo = source.getDebugInfo();
    }

    @Override
    public String getDomainName() {
        return this.errorDomainName;
    }

    public ErrorElement setDomain(String domainName) {
        Preconditions.checkNotNull(domainName, "Error domain must not be null.");
        this.errorDomainName = domainName;
        return this;
    }

    @Override
    public String getCodeName() {
        return this.errorCodeName;
    }

    public ErrorElement setCode(String codeName) {
        Preconditions.checkNotNull(codeName, "Error code must not be null.");
        this.errorCodeName = codeName;
        return this;
    }

    @Override
    public String getLocation() {
        return this.errorLocation;
    }

    @Override
    public ErrorContent.LocationType getLocationType() {
        return this.errorLocationType;
    }

    public ErrorElement setXpathLocation(String location) {
        return this.setLocation(location, ErrorContent.LocationType.XPATH);
    }

    public ErrorElement setHeaderLocation(String location) {
        return this.setLocation(location, ErrorContent.LocationType.HEADER);
    }

    public ErrorElement setLocation(String location) {
        return this.setLocation(location, ErrorContent.LocationType.OTHER);
    }

    public ErrorElement setLocation(String location, ErrorContent.LocationType locationType) {
        Preconditions.checkNotNull(location, "Location must not be null.");
        Preconditions.checkNotNull(locationType, "Location type must not be null.");
        this.errorLocation = location;
        this.errorLocationType = locationType;
        return this;
    }

    @Override
    public String getInternalReason() {
        return this.errorInternalReason;
    }

    public ErrorElement setInternalReason(String internalReason) {
        Preconditions.checkNotNull(internalReason, "Internal Reason must not be null.");
        this.errorInternalReason = internalReason;
        return this;
    }

    @Override
    public String getExtendedHelp() {
        return this.errorExtendedHelp;
    }

    public ErrorElement setExtendedHelp(String extendedHelp) {
        Preconditions.checkNotNull(extendedHelp, "Extended help uri must not be null.");
        Preconditions.checkArgument(extendedHelp.matches(GOOGLE_URI_PATTERN), "Invalid extended help URI: %s", extendedHelp);
        this.errorExtendedHelp = extendedHelp;
        return this;
    }

    @Override
    public String getSendReport() {
        return this.errorSendReport;
    }

    public ErrorElement setSendReport(String sendReport) {
        Preconditions.checkNotNull(sendReport, "Send report uri must not be null.");
        Preconditions.checkArgument(sendReport.matches(GOOGLE_URI_PATTERN), "Invalid send report URI: %s", sendReport);
        this.errorSendReport = sendReport;
        return this;
    }

    @Override
    public String getDebugInfo() {
        return this.errorDebugInfo;
    }

    public ErrorElement setDebugInfo(String debugInfo) {
        Preconditions.checkNotNull(debugInfo, "Debug info must not be null.");
        this.errorDebugInfo = debugInfo;
        return this;
    }
}

