/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.model;

import com.google.gdata.util.common.base.Preconditions;
import com.google.gdata.util.common.xml.XmlNamespace;

public final class QName
implements Comparable<QName> {
    public static final XmlNamespace ANY_NAMESPACE = new XmlNamespace("*", "*");
    public static final String ANY_LOCALNAME = "*";
    private final XmlNamespace namespace;
    private final String localName;

    public QName(String localName) {
        this(null, localName);
    }

    public QName(XmlNamespace namespace, String localName) {
        Preconditions.checkNotNull(localName, "localName");
        this.namespace = namespace;
        this.localName = localName;
    }

    public XmlNamespace getNs() {
        return this.namespace;
    }

    public String getLocalName() {
        return this.localName;
    }

    public boolean matchesAnyNamespace() {
        return ANY_NAMESPACE.equals(this.namespace);
    }

    public boolean matchesAnyLocalName() {
        return ANY_LOCALNAME.equals(this.localName);
    }

    public boolean matches(QName o) {
        if (o == null) {
            return false;
        }
        if (!this.matchesAnyNamespace()) {
            String otherUri;
            XmlNamespace otherNs = o.getNs();
            String idUri = this.namespace == null ? null : this.namespace.getUri();
            String string = otherUri = otherNs == null ? null : otherNs.getUri();
            if (idUri == null ? otherUri != null : !idUri.equals(otherUri)) {
                return false;
            }
        }
        if (this.matchesAnyLocalName()) {
            return true;
        }
        return this.localName.equals(o.getLocalName());
    }

    public boolean equals(Object other) {
        if (!(other instanceof QName)) {
            return false;
        }
        QName otherQName = (QName)other;
        if (this.getNs() == null && otherQName.getNs() == null) {
            return this.getLocalName().equals(otherQName.getLocalName());
        }
        if (this.getNs() != null && otherQName.getNs() != null) {
            return this.getNs().getUri().equals(otherQName.getNs().getUri()) && this.getLocalName().equals(otherQName.getLocalName());
        }
        return false;
    }

    public int hashCode() {
        if (this.getNs() == null) {
            return this.getLocalName().hashCode();
        }
        return this.getNs().getUri().hashCode() * 13 + this.getLocalName().hashCode();
    }

    public String toString() {
        if (this.getNs() == null || "".equals(this.getNs().getAlias())) {
            return this.getLocalName();
        }
        return this.getNs().getAlias() + ":" + this.getLocalName();
    }

    @Override
    public int compareTo(QName o) {
        String localName;
        int compare;
        if (this.getNs() == null) {
            if (o.getNs() != null) {
                return -1;
            }
        } else {
            if (o.getNs() == null) {
                return 1;
            }
            int result = this.getNs().getUri().compareTo(o.getNs().getUri());
            if (result != 0) {
                if (ANY_NAMESPACE.equals(o.getNs())) {
                    return -1;
                }
                return result;
            }
        }
        if ((compare = (localName = this.getLocalName()).compareTo(o.getLocalName())) != 0 && ANY_LOCALNAME.equals(localName)) {
            return -1;
        }
        return compare;
    }
}

