/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.model;

import com.google.gdata.model.MetadataKey;
import com.google.gdata.model.QName;
import com.google.gdata.util.common.base.Preconditions;

public final class AttributeKey<D>
extends MetadataKey<D> {
    public static AttributeKey<String> of(QName id) {
        return AttributeKey.of(id, String.class);
    }

    public static <T> AttributeKey<T> of(QName id, Class<? extends T> datatype) {
        return new AttributeKey<T>(id, datatype);
    }

    private AttributeKey(QName id, Class<? extends D> datatype) {
        super(Preconditions.checkNotNull(id, "id"), datatype);
    }

    @Override
    public boolean matches(MetadataKey<?> other) {
        if (other == null) {
            return false;
        }
        if (!(other instanceof AttributeKey)) {
            return false;
        }
        return this.matchIdAndDatatype(other);
    }

    @Override
    public int compareTo(MetadataKey<?> other) {
        if (other == this) {
            return 0;
        }
        if (!(other instanceof AttributeKey)) {
            return -1;
        }
        int compare = AttributeKey.compareQName(this.id, other.id);
        if (compare != 0) {
            return compare;
        }
        return AttributeKey.compareClass(this.datatype, other.datatype);
    }

    public int hashCode() {
        int hashCode = this.datatype.hashCode();
        hashCode *= 17;
        if (this.id != null) {
            hashCode += this.id.hashCode();
        }
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != AttributeKey.class) {
            return false;
        }
        AttributeKey o = (AttributeKey)obj;
        return this.id.equals(o.id) && this.datatype == o.datatype;
    }

    @Override
    public String toString() {
        return "{AttributeKey " + this.id + ", D:" + this.datatype + "}";
    }
}

