/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.data;

import com.google.gdata.client.CoreErrorDomain;
import com.google.gdata.client.Service;
import com.google.gdata.data.Content;
import com.google.gdata.data.ExtensionProfile;
import com.google.gdata.data.IOutOfLineContent;
import com.google.gdata.util.ContentType;
import com.google.gdata.util.Namespaces;
import com.google.gdata.util.ParseException;
import com.google.gdata.util.XmlParser;
import com.google.gdata.util.common.xml.XmlWriter;
import java.io.IOException;
import java.util.ArrayList;

public class OutOfLineContent
extends Content
implements IOutOfLineContent {
    protected ContentType mimeType;
    protected String lang;
    protected String uri;
    protected long length;
    protected String etag;

    @Override
    public int getType() {
        return 7;
    }

    @Override
    public ContentType getMimeType() {
        return this.mimeType;
    }

    public void setMimeType(ContentType v) {
        this.mimeType = v;
    }

    @Override
    public String getLang() {
        return this.lang;
    }

    public void setLang(String v) {
        this.lang = v;
    }

    @Override
    public String getUri() {
        return this.uri;
    }

    public void setUri(String v) {
        this.uri = v;
    }

    public long getLength() {
        return this.length;
    }

    public void setLength(long v) {
        this.length = v;
    }

    @Override
    public String getEtag() {
        return this.etag;
    }

    public void setEtag(String v) {
        this.etag = v;
    }

    @Override
    public void generateAtom(XmlWriter w, ExtensionProfile extProfile) throws IOException {
        ArrayList<XmlWriter.Attribute> attrs = new ArrayList<XmlWriter.Attribute>(2);
        if (this.mimeType != null) {
            attrs.add(new XmlWriter.Attribute("type", this.mimeType.getMediaType()));
        }
        if (this.uri != null) {
            attrs.add(new XmlWriter.Attribute("src", this.uri));
        }
        if (this.etag != null && !Service.getVersion().isCompatible(Service.Versions.V1)) {
            attrs.add(new XmlWriter.Attribute("gd", "etag", this.etag));
        }
        if (this.lang != null) {
            attrs.add(new XmlWriter.Attribute("xml:lang", this.lang));
        }
        w.simpleElement(Namespaces.atomNs, "content", attrs, null);
    }

    @Override
    public void generateRss(XmlWriter w, ExtensionProfile extProfile) throws IOException {
        ArrayList<XmlWriter.Attribute> attrs = new ArrayList<XmlWriter.Attribute>(3);
        if (this.mimeType != null) {
            attrs.add(new XmlWriter.Attribute("type", this.mimeType.getMediaType()));
        }
        if (this.uri != null) {
            attrs.add(new XmlWriter.Attribute("url", this.uri));
        }
        if (this.length != -1L) {
            attrs.add(new XmlWriter.Attribute("length", Long.toString(this.length)));
        }
        w.simpleElement(Namespaces.rssNs, "enclosure", attrs, null);
    }

    public class AtomHandler
    extends XmlParser.ElementHandler {
        @Override
        public void processAttribute(String namespace, String localName, String value) throws ParseException {
            if (namespace.equals("")) {
                if (localName.equals("type")) {
                    try {
                        OutOfLineContent.this.mimeType = new ContentType(value);
                    }
                    catch (IllegalArgumentException e) {
                        throw new ParseException(CoreErrorDomain.ERR.invalidMimeType, (Throwable)e);
                    }
                } else if (localName.equals("src")) {
                    OutOfLineContent.this.uri = this.getAbsoluteUri(value);
                }
            } else if (namespace.equals("http://schemas.google.com/g/2005") && localName.equals("etag")) {
                OutOfLineContent.this.setEtag(value);
                return;
            }
        }

        @Override
        public void processEndElement() throws ParseException {
            if (OutOfLineContent.this.uri == null) {
                throw new ParseException(CoreErrorDomain.ERR.missingSrcAttribute);
            }
            OutOfLineContent.this.lang = this.xmlLang;
            super.processEndElement();
        }
    }
}

