/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.client.contacts;

import com.google.gdata.client.AuthTokenFactory;
import com.google.gdata.client.GoogleService;
import com.google.gdata.client.Service;
import com.google.gdata.data.batch.BatchUtils;
import com.google.gdata.data.contacts.ContactFeed;
import com.google.gdata.data.contacts.ContactGroupFeed;
import com.google.gdata.data.contacts.ProfileFeed;
import com.google.gdata.util.Version;
import com.google.gdata.util.VersionRegistry;

public class ContactsService
extends GoogleService {
    public static final String CONTACTS_SERVICE = "cp";
    public static final String CONTACTS_SERVICE_VERSION = "GContacts-Java/" + ContactsService.class.getPackage().getImplementationVersion();
    public static final Version DEFAULT_VERSION = Service.initServiceVersion(ContactsService.class, Versions.V3);

    public ContactsService(String applicationName) {
        super(CONTACTS_SERVICE, applicationName);
        this.declareExtensions();
    }

    public ContactsService(String applicationName, Service.GDataRequestFactory requestFactory, AuthTokenFactory authTokenFactory) {
        super(applicationName, requestFactory, authTokenFactory);
        this.declareExtensions();
    }

    public ContactsService(String applicationName, String protocol, String domainName) {
        super(CONTACTS_SERVICE, applicationName, protocol, domainName);
        this.declareExtensions();
    }

    @Override
    public String getServiceVersion() {
        return CONTACTS_SERVICE_VERSION + " " + super.getServiceVersion();
    }

    public static Version getVersion() {
        return VersionRegistry.get().getVersion(ContactsService.class);
    }

    private void declareExtensions() {
        new ContactFeed().declareExtensions(this.extProfile);
        new ContactGroupFeed().declareExtensions(this.extProfile);
        new ProfileFeed().declareExtensions(this.extProfile);
        BatchUtils.declareExtensions(this.extProfile);
    }

    public static final class Versions {
        public static final Version V1 = new Version(ContactsService.class, "1.0", Service.Versions.V1);
        public static final Version V2 = new Version(ContactsService.class, "2.0", Service.Versions.V2);
        public static final Version V3 = new Version(ContactsService.class, "3.0", Service.Versions.V2);
        public static final Version V3_1 = new Version(ContactsService.class, "3.1", Service.Versions.V2);

        private Versions() {
        }
    }
}

