/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.service.muc;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.java.sip.communicator.service.contactsource.ContactSourceService;
import net.java.sip.communicator.service.contactsource.SourceContact;
import net.java.sip.communicator.service.muc.ChatRoomProviderWrapper;
import net.java.sip.communicator.service.muc.ChatRoomProviderWrapperListener;
import net.java.sip.communicator.service.muc.ChatRoomWrapper;
import net.java.sip.communicator.service.protocol.ChatRoom;
import net.java.sip.communicator.service.protocol.ChatRoomInvitation;
import net.java.sip.communicator.service.protocol.ChatRoomMember;
import net.java.sip.communicator.service.protocol.OperationSet;
import net.java.sip.communicator.service.protocol.OperationSetMultiUserChat;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import net.java.sip.communicator.util.ConfigurationUtils;

public abstract class MUCService {
    public static final String DISABLED_PROPERTY = "net.java.sip.communicator.impl.muc.MUC_SERVICE_DISABLED";
    private static String AUTO_OPEN_CONFIG_KEY = "openAutomatically";
    public static String OPEN_ON_ACTIVITY = "on_activity";
    public static String OPEN_ON_MESSAGE = "on_message";
    public static String OPEN_ON_IMPORTANT_MESSAGE = "on_important_message";
    public static String DEFAULT_AUTO_OPEN_BEHAVIOUR = OPEN_ON_MESSAGE;
    public static Map<String, String> autoOpenConfigValuesTexts = new HashMap<String, String>();

    public static void setChatRoomAutoOpenOption(ProtocolProviderService pps, String chatRoomId, String value) {
        ConfigurationUtils.updateChatRoomProperty((ProtocolProviderService)pps, (String)chatRoomId, (String)AUTO_OPEN_CONFIG_KEY, (String)value);
    }

    public static String getChatRoomAutoOpenOption(ProtocolProviderService pps, String chatRoomId) {
        return ConfigurationUtils.getChatRoomProperty((ProtocolProviderService)pps, (String)chatRoomId, (String)AUTO_OPEN_CONFIG_KEY);
    }

    public abstract void fireChatRoomListChangedEvent(ChatRoomWrapper var1, int var2);

    public abstract void joinChatRoom(ChatRoomWrapper var1, String var2, byte[] var3, String var4);

    public abstract ChatRoomWrapper createChatRoom(String var1, ProtocolProviderService var2, Collection<String> var3, String var4, boolean var5);

    public abstract ChatRoomWrapper createPrivateChatRoom(ProtocolProviderService var1, Collection<String> var2, String var3, boolean var4);

    public abstract ChatRoomWrapper createChatRoom(String var1, ProtocolProviderService var2, Collection<String> var3, String var4, boolean var5, boolean var6, boolean var7);

    public abstract void joinChatRoom(String var1, ChatRoomProviderWrapper var2);

    public abstract List<String> getExistingChatRooms(ChatRoomProviderWrapper var1);

    public abstract void acceptInvitation(ChatRoomInvitation var1);

    public abstract void rejectInvitation(OperationSetMultiUserChat var1, ChatRoomInvitation var2, String var3);

    public static boolean isPrivate(ChatRoom chatRoom) {
        String nickname;
        if (!chatRoom.isSystem() && chatRoom.isJoined() && chatRoom.getMembersCount() == 1 && (nickname = chatRoom.getUserNickname()) != null) {
            for (ChatRoomMember member : chatRoom.getMembers()) {
                if (!nickname.equals(member.getName())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public abstract ChatRoomWrapper leaveChatRoom(ChatRoomWrapper var1);

    public abstract ChatRoomWrapper findChatRoomWrapperFromSourceContact(SourceContact var1);

    public abstract ChatRoomWrapper getChatRoomWrapperByChatRoom(ChatRoom var1, boolean var2);

    public static OperationSetMultiUserChat getMultiUserChatOpSet(ProtocolProviderService protocolProvider) {
        OperationSet opSet = protocolProvider.getOperationSet(OperationSetMultiUserChat.class);
        return opSet instanceof OperationSetMultiUserChat ? (OperationSetMultiUserChat)opSet : null;
    }

    public abstract ChatRoomWrapper findChatRoomWrapperFromChatRoomID(String var1, ProtocolProviderService var2);

    public abstract void synchronizeOpSetWithLocalContactList(ProtocolProviderService var1, OperationSetMultiUserChat var2);

    public abstract Iterator<ChatRoomProviderWrapper> getChatRoomProviders();

    public abstract void removeChatRoom(ChatRoomWrapper var1);

    public abstract void addChatRoomProviderWrapperListener(ChatRoomProviderWrapperListener var1);

    public abstract void removeChatRoomProviderWrapperListener(ChatRoomProviderWrapperListener var1);

    public abstract ChatRoomProviderWrapper findServerWrapperFromProvider(ProtocolProviderService var1);

    public abstract ChatRoomWrapper findChatRoomWrapperFromChatRoom(ChatRoom var1);

    public abstract void openChatRoom(ChatRoomWrapper var1);

    public abstract ContactSourceService getServerChatRoomsContactSourceForProvider(ChatRoomProviderWrapper var1);

    public abstract boolean isMUCSourceContact(SourceContact var1);

    static {
        autoOpenConfigValuesTexts.put(OPEN_ON_ACTIVITY, "service.gui.OPEN_ON_ACTIVITY");
        autoOpenConfigValuesTexts.put(OPEN_ON_MESSAGE, "service.gui.OPEN_ON_MESSAGE");
        autoOpenConfigValuesTexts.put(OPEN_ON_IMPORTANT_MESSAGE, "service.gui.OPEN_ON_IMPORTANT_MESSAGE");
    }
}

