/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.ldap.configform;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.java.sip.communicator.plugin.desktoputil.TransparentPanel;
import net.java.sip.communicator.plugin.ldap.LdapActivator;
import net.java.sip.communicator.plugin.ldap.configform.DirectorySettingsForm;
import net.java.sip.communicator.plugin.ldap.configform.LdapTableModel;
import net.java.sip.communicator.plugin.ldap.configform.Resources;
import net.java.sip.communicator.service.gui.ConfigurationForm;
import net.java.sip.communicator.service.ldap.LdapDirectory;
import net.java.sip.communicator.service.ldap.LdapDirectorySet;
import net.java.sip.communicator.service.ldap.LdapDirectorySettings;
import net.java.sip.communicator.service.ldap.LdapFactory;
import net.java.sip.communicator.service.ldap.LdapService;
import net.java.sip.communicator.util.Logger;

public class LdapConfigForm
extends TransparentPanel
implements ConfigurationForm,
ActionListener,
ListSelectionListener {
    private static final long serialVersionUID = 0L;
    private static Logger logger = Logger.getLogger(LdapConfigForm.class);
    private JButton newButton = new JButton("+");
    private JButton modifyButton = new JButton(Resources.getString("impl.ldap.EDIT"));
    private JButton removeButton = new JButton("-");
    private JTable directoryTable = new JTable();
    private TransparentPanel buttonsPanel = new TransparentPanel((LayoutManager)new FlowLayout(0));
    private JScrollPane scrollPane = new JScrollPane();
    private JPanel rightPanel = new TransparentPanel((LayoutManager)new BorderLayout());
    private JPanel mainPanel = this;
    private LdapTableModel tableModel = new LdapTableModel();
    private final DirectorySettingsForm settingsForm = new DirectorySettingsForm();

    public LdapConfigForm() {
        super((LayoutManager)new BorderLayout());
        logger.trace((Object)"New LDAP configuration form.");
        this.initComponents();
    }

    private void initComponents() {
        this.modifyButton.setEnabled(false);
        this.removeButton.setEnabled(false);
        this.newButton.setSize(this.newButton.getMinimumSize());
        this.modifyButton.setSize(this.modifyButton.getMinimumSize());
        this.removeButton.setSize(this.removeButton.getMinimumSize());
        this.directoryTable.setRowHeight(22);
        this.directoryTable.setSelectionMode(0);
        this.directoryTable.setShowHorizontalLines(false);
        this.directoryTable.setShowVerticalLines(false);
        this.directoryTable.setModel(this.tableModel);
        this.directoryTable.setAutoResizeMode(3);
        this.directoryTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int row;
                if (e.getClickCount() > 1 && (row = LdapConfigForm.this.directoryTable.getSelectedRow()) >= 0) {
                    LdapFactory factory = LdapActivator.getLdapService().getFactory();
                    LdapDirectorySet serverSet = LdapActivator.getLdapService().getServerSet();
                    LdapDirectory oldServer = LdapConfigForm.this.tableModel.getServerAt(row);
                    LdapDirectorySettings settings = oldServer.getSettings();
                    LdapConfigForm.this.settingsForm.loadData(settings);
                    LdapConfigForm.this.settingsForm.setNameFieldEnabled(false);
                    int ret = LdapConfigForm.this.settingsForm.showDialog();
                    if (ret == 1) {
                        LdapDirectory newServer = factory.createServer(LdapConfigForm.this.settingsForm.getSettings());
                        serverSet.removeServerWithName(oldServer.getSettings().getName());
                        new RefreshContactSourceThread(oldServer, newServer).start();
                        serverSet.addServer(newServer);
                        LdapConfigForm.this.refresh();
                    }
                }
            }
        });
        this.settingsForm.setModal(true);
        this.rightPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.rightPanel.add((Component)this.buttonsPanel, "North");
        this.scrollPane.getViewport().add(this.directoryTable);
        this.mainPanel.add((Component)this.scrollPane, "Center");
        this.mainPanel.add((Component)this.rightPanel, "South");
        this.mainPanel.setPreferredSize(new Dimension(500, 400));
        this.buttonsPanel.add((Component)this.newButton);
        this.buttonsPanel.add((Component)this.removeButton);
        this.buttonsPanel.add((Component)this.modifyButton);
        this.directoryTable.getSelectionModel().addListSelectionListener(this);
        this.newButton.setActionCommand("new");
        this.newButton.addActionListener(this);
        this.modifyButton.addActionListener(this);
        this.modifyButton.setActionCommand("modify");
        this.removeButton.addActionListener(this);
        this.removeButton.setActionCommand("remove");
    }

    public String getTitle() {
        return Resources.getString("impl.ldap.CONFIG_FORM_TITLE");
    }

    public byte[] getIcon() {
        return Resources.getImageInBytes("LDAP_CONFIG_FORM_ICON");
    }

    public Object getForm() {
        return this;
    }

    public int getIndex() {
        return -1;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int row = this.directoryTable.getSelectedRow();
        LdapFactory factory = LdapActivator.getLdapService().getFactory();
        LdapDirectorySet serverSet = LdapActivator.getLdapService().getServerSet();
        if (e.getActionCommand().equals("new")) {
            LdapDirectorySettings settings = factory.createServerSettings();
            this.settingsForm.loadData(settings);
            this.settingsForm.setNameFieldEnabled(true);
            int ret = this.settingsForm.showDialog();
            if (ret == 1) {
                LdapDirectory server = factory.createServer(this.settingsForm.getSettings());
                new RefreshContactSourceThread(null, server).start();
                serverSet.addServer(server);
                this.refresh();
            }
        }
        if (e.getActionCommand().equals("modify") && row != -1) {
            LdapDirectory oldServer = this.tableModel.getServerAt(row);
            LdapDirectorySettings settings = oldServer.getSettings();
            this.settingsForm.loadData(settings);
            this.settingsForm.setNameFieldEnabled(false);
            int ret = this.settingsForm.showDialog();
            if (ret == 1) {
                LdapDirectory newServer = factory.createServer(this.settingsForm.getSettings());
                new RefreshContactSourceThread(oldServer, newServer).start();
                serverSet.removeServerWithName(oldServer.getSettings().getName());
                serverSet.addServer(newServer);
                this.refresh();
            }
        }
        if (e.getActionCommand().equals("remove") && row != -1) {
            new RefreshContactSourceThread(this.tableModel.getServerAt(row), null).start();
            serverSet.removeServerWithName(this.tableModel.getServerAt(row).getSettings().getName());
            this.refresh();
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (this.directoryTable.getSelectedRow() == -1) {
            this.modifyButton.setEnabled(false);
            this.removeButton.setEnabled(false);
        } else if (!e.getValueIsAdjusting()) {
            this.modifyButton.setEnabled(true);
            this.removeButton.setEnabled(true);
        }
    }

    private void refresh() {
        this.tableModel.fireTableStructureChanged();
    }

    public boolean isAdvanced() {
        return true;
    }

    public static class RefreshContactSourceThread
    extends Thread {
        private LdapDirectory oldLdap = null;
        private LdapDirectory newLdap = null;

        RefreshContactSourceThread(LdapDirectory oldLdap, LdapDirectory newLdap) {
            this.oldLdap = oldLdap;
            this.newLdap = newLdap;
        }

        @Override
        public void run() {
            LdapService service = LdapActivator.getLdapService();
            if (this.oldLdap != null) {
                service.removeContactSource(this.oldLdap);
            }
            if (this.newLdap != null) {
                service.createContactSource(this.newLdap);
            }
        }
    }
}

