/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.chatconfig.replacement;

import java.util.ArrayList;
import javax.swing.table.AbstractTableModel;
import net.java.sip.communicator.plugin.chatconfig.ChatConfigActivator;
import net.java.sip.communicator.service.replacement.ReplacementProperty;
import net.java.sip.communicator.service.replacement.ReplacementService;
import org.jitsi.service.configuration.ConfigurationService;

public class ReplacementConfigurationTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 0L;
    private ArrayList<String> sourceList;
    private static ConfigurationService configService = ChatConfigActivator.getConfigurationService();

    public ReplacementConfigurationTableModel(ArrayList<String> source) {
        this.sourceList = source;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return columnIndex == 0 ? Boolean.class : super.getColumnClass(columnIndex);
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public int getRowCount() {
        return this.sourceList.size();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        String sourceName = this.sourceList.get(rowIndex);
        ReplacementService source = ChatConfigActivator.getReplacementSources().get(sourceName);
        switch (columnIndex) {
            case 0: {
                boolean e = configService.getBoolean(ReplacementProperty.getPropertyName((String)source.getSourceName()), true);
                return e;
            }
            case 1: {
                return sourceName;
            }
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex == 0;
    }

    @Override
    public void setValueAt(Object value, int rowIndex, int columnIndex) {
        if (columnIndex == 0 && value instanceof Boolean) {
            String sourceName = this.sourceList.get(rowIndex);
            ReplacementService source = ChatConfigActivator.getReplacementSources().get(sourceName);
            boolean e = (Boolean)value;
            configService.setProperty(ReplacementProperty.getPropertyName((String)source.getSourceName()), (Object)e);
            this.fireTableCellUpdated(rowIndex, columnIndex);
        }
    }
}

