/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.slick.history;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Random;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import net.java.sip.communicator.service.history.History;
import net.java.sip.communicator.service.history.HistoryID;
import net.java.sip.communicator.service.history.HistoryReader;
import net.java.sip.communicator.service.history.HistoryService;
import net.java.sip.communicator.service.history.HistoryWriter;
import net.java.sip.communicator.service.history.QueryResultSet;
import net.java.sip.communicator.service.history.records.HistoryRecord;
import net.java.sip.communicator.service.history.records.HistoryRecordStructure;
import net.java.sip.communicator.slick.history.HistoryServiceLick;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class TestHistoryService
extends TestCase {
    private static HistoryRecordStructure recordStructure = new HistoryRecordStructure(new String[]{"age", "name_CDATA", "sex"});
    private HistoryService historyService = null;
    private ServiceReference historyServiceRef = null;
    private History history = null;
    private Random random = new Random();

    public TestHistoryService(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.addTest((Test)new TestHistoryService("testCreateDB"));
        suite.addTest((Test)new TestHistoryService("testWriteRecords"));
        suite.addTest((Test)new TestHistoryService("testReadRecords"));
        suite.addTest((Test)new TestHistoryService("testPurgeLocallyStoredHistory"));
        suite.addTest((Test)new TestHistoryService("testCreatingHistoryIDFromFS"));
        suite.addTest((Test)new TestHistoryService("testWriteRecordsWithMaxNumber"));
        return suite;
    }

    protected void setUp() throws Exception {
        BundleContext context = HistoryServiceLick.bc;
        this.historyServiceRef = context.getServiceReference(HistoryService.class.getName());
        this.historyService = (HistoryService)context.getService(this.historyServiceRef);
        HistoryID testID = HistoryID.createFromRawID((String[])new String[]{"test", "alltests"});
        this.history = this.historyService.createHistory(testID, recordStructure);
    }

    protected void tearDown() throws Exception {
        BundleContext context = HistoryServiceLick.bc;
        context.ungetService(this.historyServiceRef);
        this.history = null;
        this.historyService = null;
        this.historyServiceRef = null;
    }

    public void testCreateDB() {
        ArrayList<String> al = new ArrayList<String>();
        Iterator i = this.historyService.getExistingIDs();
        while (i.hasNext()) {
            HistoryID id = (HistoryID)i.next();
            String[] components = id.getID();
            if (components.length != 2 || !"test".equals(components[0])) continue;
            al.add(components[1]);
        }
        int count = al.size();
        boolean unique = false;
        String lastComp = null;
        while (!unique) {
            lastComp = Integer.toHexString(this.random.nextInt());
            for (int j = 0; j < count; ++j) {
                if (!lastComp.equals(al.get(j))) continue;
            }
            unique = true;
        }
        HistoryID id = HistoryID.createFromRawID((String[])new String[]{"test", lastComp});
        try {
            this.historyService.createHistory(id, recordStructure);
        }
        catch (Exception e) {
            TestHistoryService.fail((String)("Could not create database with id " + id + " with error " + e));
        }
        try {
            this.historyService.purgeLocallyStoredHistory(id);
        }
        catch (Exception ex) {
            TestHistoryService.fail((String)("Cannot delete local history with id " + this.history.getID() + " : " + ex.getMessage()));
        }
    }

    public void testWriteRecords() {
        HistoryWriter writer = this.history.getWriter();
        try {
            for (int i = 0; i < 202; ++i) {
                writer.addRecord(new String[]{"" + this.random.nextInt(), "name" + i, i % 2 == 0 ? "m" : "f"});
            }
        }
        catch (Exception e) {
            TestHistoryService.fail((String)("Could not write records. Reason: " + e));
        }
    }

    public void testReadRecords() {
        HistoryReader reader = this.history.getReader();
        QueryResultSet result = reader.findByKeyword("name2", "name");
        TestHistoryService.assertTrue((String)"Nothing found", (boolean)result.hasNext());
        while (result.hasNext()) {
            HistoryRecord record = (HistoryRecord)result.nextRecord();
            String[] vals = record.getPropertyValues();
            try {
                int n = Integer.parseInt(vals[1].substring(4));
                TestHistoryService.assertEquals((int)3, (int)vals.length);
                TestHistoryService.assertEquals((String)(n % 2 == 0 ? "m" : "f"), (String)vals[2]);
            }
            catch (Exception e) {
                TestHistoryService.fail((String)("Bad data! Expected nameXXXX, where XXXX is an integer, but found: " + vals[0]));
            }
        }
    }

    public void testPurgeLocallyStoredHistory() {
        try {
            this.historyService.purgeLocallyStoredHistory(this.history.getID());
        }
        catch (Exception ex) {
            TestHistoryService.fail((String)("Cannot delete local history with id " + this.history.getID() + " : " + ex.getMessage()));
        }
    }

    public void testCreatingHistoryIDFromFS() {
        this.testHistoryIDCreate(new String[]{"test1", "alltests1"});
        this.testHistoryIDCreate(new String[]{"test2", "alltests2", "Jabber:mincho.penchev@jit.si@jit.si"});
    }

    private void testHistoryIDCreate(String[] strArr) {
        HistoryID testNoSpecialCharsID = HistoryID.createFromRawID((String[])strArr);
        HistoryID testNoSpecialCharsIDFSRead = HistoryID.createFromRawStrings((String[])testNoSpecialCharsID.getID());
        TestHistoryService.assertEquals((String)"Wrong length", (int)testNoSpecialCharsID.getID().length, (int)testNoSpecialCharsIDFSRead.getID().length);
        for (int i = 0; i < testNoSpecialCharsID.getID().length; ++i) {
            TestHistoryService.assertEquals((String)"Wrong id", (String)testNoSpecialCharsID.getID()[i], (String)testNoSpecialCharsIDFSRead.getID()[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testWriteRecordsWithMaxNumber() {
        HistoryWriter writer = this.history.getWriter();
        HistoryReader reader = this.history.getReader();
        try {
            for (int i = 0; i < 20; ++i) {
                writer.addRecord(new String[]{"" + i, "name" + i, i % 2 == 0 ? "m" : "f"}, 20);
                TestHistoryService testHistoryService = this;
                synchronized (testHistoryService) {
                    try {
                        ((Object)((Object)this)).wait(100L);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    continue;
                }
            }
            QueryResultSet recs = reader.findLast(20);
            int count = 0;
            while (recs.hasNext()) {
                ++count;
                recs.next();
            }
            TestHistoryService.assertEquals((String)"Wrong count of messages", (int)20, (int)count);
            writer.addRecord(new String[]{"21", "name21", "f"}, 20);
            recs = reader.findLast(20);
            count = 0;
            boolean foundFirstMessage = false;
            while (recs.hasNext()) {
                ++count;
                HistoryRecord hr = (HistoryRecord)recs.next();
                if (!hr.getPropertyValues()[0].equals("0")) continue;
                foundFirstMessage = true;
            }
            TestHistoryService.assertEquals((String)"Wrong count of messages", (int)20, (int)count);
            TestHistoryService.assertFalse((String)"Wrong message removed, must be the first one", (boolean)foundFirstMessage);
        }
        catch (Exception e) {
            e.printStackTrace();
            TestHistoryService.fail((String)("Could not write records. Reason: " + e));
        }
    }
}

