/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.dns;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import net.java.sip.communicator.util.Logger;
import net.java.sip.communicator.util.ServiceUtils;
import net.java.sip.communicator.util.UtilActivator;
import org.jitsi.service.packetlogging.PacketLoggingService;
import org.osgi.framework.BundleContext;
import org.xbill.DNS.PacketLogger;

public class DnsJavaLogger
implements PacketLogger {
    private static final Logger logger = Logger.getLogger(DnsJavaLogger.class);
    private PacketLoggingService packetLoggingService = null;

    private PacketLoggingService getPacketLoggingService() {
        if (this.packetLoggingService == null && UtilActivator.bundleContext != null) {
            this.packetLoggingService = (PacketLoggingService)ServiceUtils.getService((BundleContext)UtilActivator.bundleContext, PacketLoggingService.class);
        }
        return this.packetLoggingService;
    }

    public void log(String prefix, SocketAddress local, SocketAddress remote, byte[] data) {
        try {
            this.logInternal(local, remote, prefix, data);
        }
        catch (Throwable t) {
            logger.error((Object)"Error saving packet", t);
        }
    }

    private void logInternal(SocketAddress local, SocketAddress remote, String prefix, byte[] data) {
        int dstPort;
        byte[] dstAddr;
        int srcPort;
        byte[] srcAddr;
        if (this.getPacketLoggingService() == null || !(local instanceof InetSocketAddress) || !(remote instanceof InetSocketAddress)) {
            return;
        }
        InetSocketAddress localAddress = (InetSocketAddress)local;
        InetSocketAddress remoteAddress = (InetSocketAddress)remote;
        PacketLoggingService.TransportName transportName = PacketLoggingService.TransportName.UDP;
        if (prefix.contains("TCP")) {
            transportName = PacketLoggingService.TransportName.TCP;
        }
        boolean isSender = true;
        if (prefix.contains("read")) {
            isSender = false;
        }
        if (isSender) {
            srcAddr = localAddress.getAddress().getAddress();
            srcPort = localAddress.getPort();
            dstAddr = remoteAddress.getAddress().getAddress();
            dstPort = remoteAddress.getPort();
        } else {
            dstAddr = localAddress.getAddress().getAddress();
            dstPort = localAddress.getPort();
            srcAddr = remoteAddress.getAddress().getAddress();
            srcPort = remoteAddress.getPort();
        }
        this.getPacketLoggingService().logPacket(PacketLoggingService.ProtocolName.DNS, srcAddr, srcPort, dstAddr, dstPort, transportName, isSender, data, 0, data.length);
    }
}

