/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.connectioninfo;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenuItem;
import net.java.sip.communicator.plugin.connectioninfo.ConnectionInfoPanel;
import net.java.sip.communicator.plugin.connectioninfo.Resources;
import net.java.sip.communicator.plugin.desktoputil.SIPCommDialog;
import net.java.sip.communicator.service.gui.AbstractPluginComponent;
import net.java.sip.communicator.service.gui.Container;
import net.java.sip.communicator.service.gui.PluginComponentFactory;
import net.java.sip.communicator.service.protocol.AccountID;

public class ConnectionInfoMenuItemComponent
extends AbstractPluginComponent {
    private JMenuItem connectionInfoMenuItem;
    private AccountID accountID = null;

    public ConnectionInfoMenuItemComponent(Container container, PluginComponentFactory parentFactory) {
        super(container, parentFactory);
    }

    public void setCurrentAccountID(AccountID accountID) {
        this.accountID = accountID;
        this.connectionInfoMenuItem.setEnabled(accountID != null && accountID.isEnabled());
    }

    public Object getComponent() {
        if (this.connectionInfoMenuItem == null) {
            this.connectionInfoMenuItem = new JMenuItem(Resources.getString("plugin.connectioninfo.TITLE"));
            this.connectionInfoMenuItem.setIcon(Resources.getImage("plugin.contactinfo.CONTACT_INFO_ICON"));
            this.connectionInfoMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ConnectionInfoDialog dialog = new ConnectionInfoDialog(ConnectionInfoMenuItemComponent.this.accountID);
                    dialog.setVisible(true);
                }
            });
        }
        return this.connectionInfoMenuItem;
    }

    public String getName() {
        return Resources.getString("plugin.connectioninfo.TITLE");
    }

    public int getPositionIndex() {
        return 0;
    }

    static class ConnectionInfoDialog
    extends SIPCommDialog {
        private final ConnectionInfoPanel connectionInfoPanel = new ConnectionInfoPanel(this);

        private ConnectionInfoDialog(AccountID accountID) {
            this.setPreferredSize(new Dimension(600, 400));
            this.setTitle(Resources.getString("plugin.connectioninfo.TITLE"));
            if (accountID != null) {
                this.connectionInfoPanel.getAccountsComboBox().setSelectedItem(this.connectionInfoPanel.getAccountsTable().get(accountID));
            }
            this.add((Component)((Object)this.connectionInfoPanel));
        }

        protected void close(boolean isEscaped) {
            this.setVisible(false);
            this.connectionInfoPanel.dispose();
        }

        public void setVisible(boolean isVisible) {
            if (isVisible) {
                this.connectionInfoPanel.setVisible(true);
            }
            super.setVisible(isVisible);
        }
    }
}

