/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd.icbm;

import java.io.IOException;
import java.io.OutputStream;
import net.kano.joscar.BinaryTools;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.OscarTools;
import net.kano.joscar.flapcmd.SnacPacket;
import net.kano.joscar.snaccmd.icbm.IcbmCommand;

public class WarnCmd
extends IcbmCommand {
    public static final int CODE_ANONYMOUS = 1;
    public static final int CODE_NOT_ANONYMOUS = 0;
    private final int anonymityCode;
    private final String warnee;

    protected WarnCmd(SnacPacket packet) {
        super(8);
        DefensiveTools.checkNull(packet, "packet");
        ByteBlock snacData = packet.getData();
        this.anonymityCode = BinaryTools.getUShort(snacData, 0);
        ByteBlock snBlock = snacData.subBlock(2);
        this.warnee = OscarTools.readScreenname(snBlock).getString();
    }

    public WarnCmd(String warnee) {
        this(warnee, 0);
    }

    public WarnCmd(String warnee, boolean anonymous) {
        this(warnee, anonymous ? 1 : 0);
    }

    public WarnCmd(String warnee, int anonymityCode) {
        super(8);
        DefensiveTools.checkNull(warnee, "warnee");
        this.anonymityCode = anonymityCode;
        this.warnee = warnee;
    }

    public final boolean isAnonymous() {
        return this.anonymityCode == 1;
    }

    public final int getAnonymityCode() {
        return this.anonymityCode;
    }

    public final String getWarnee() {
        return this.warnee;
    }

    public void writeData(OutputStream out) throws IOException {
        BinaryTools.writeUShort(out, this.anonymityCode);
        OscarTools.writeScreenname(out, this.warnee);
    }

    public String toString() {
        return "WarnCmd: warning " + this.warnee + ", anonymous=" + (this.anonymityCode == 1 ? "yes" : (this.anonymityCode == 0 ? "no" : "0x" + this.anonymityCode));
    }
}

