/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.icq;

import net.java.sip.communicator.impl.protocol.icq.ContactIcqImpl;
import net.java.sip.communicator.impl.protocol.icq.ProtocolProviderServiceIcqImpl;
import net.java.sip.communicator.service.protocol.AuthorizationRequest;
import net.java.sip.communicator.service.protocol.Contact;
import net.java.sip.communicator.service.protocol.OperationFailedException;
import net.java.sip.communicator.service.protocol.OperationSetExtendedAuthorizations;
import net.kano.joustsim.Screenname;

public class OperationSetExtendedAuthorizationsIcqImpl
implements OperationSetExtendedAuthorizations {
    private ProtocolProviderServiceIcqImpl icqProvider = null;

    public OperationSetExtendedAuthorizationsIcqImpl(ProtocolProviderServiceIcqImpl icqProvider) {
        this.icqProvider = icqProvider;
    }

    public void reRequestAuthorization(AuthorizationRequest request, Contact contact) throws OperationFailedException {
        this.assertConnected();
        if (!(contact instanceof ContactIcqImpl)) {
            throw new IllegalArgumentException("Argument is not an icq contact (contact=" + contact + ")");
        }
        this.icqProvider.getAimConnection().getSsiService().requestBuddyAuthorization(new Screenname(contact.getAddress()), request.getReason());
    }

    public void explicitAuthorize(Contact contact) throws OperationFailedException {
        this.assertConnected();
        if (!(contact instanceof ContactIcqImpl)) {
            throw new IllegalArgumentException("Argument is not an icq contact (contact=" + contact + ")");
        }
        this.icqProvider.getAimConnection().getSsiService().sendFutureBuddyAuthorization(new Screenname(contact.getAddress()), "");
    }

    private void assertConnected() throws IllegalStateException {
        if (this.icqProvider == null) {
            throw new IllegalStateException("The icq provider must be non-null and signed on the ICQ service before being able to communicate.");
        }
        if (!this.icqProvider.isRegistered()) {
            throw new IllegalStateException("The icq provider must be signed on the ICQ service before being able to communicate.");
        }
    }

    public OperationSetExtendedAuthorizations.SubscriptionStatus getSubscriptionStatus(Contact contact) {
        if (contact == null || !(contact instanceof ContactIcqImpl)) {
            throw new IllegalArgumentException("Argument is not an icq contact (contact=" + contact + ")");
        }
        if (((ContactIcqImpl)contact).getJoustSimBuddy().isAwaitingAuthorization()) {
            return OperationSetExtendedAuthorizations.SubscriptionStatus.SubscriptionPending;
        }
        return OperationSetExtendedAuthorizations.SubscriptionStatus.Subscribed;
    }
}

