/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.desktoputil;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.security.cert.Certificate;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import net.java.sip.communicator.plugin.desktoputil.DesktopUtilActivator;
import net.java.sip.communicator.plugin.desktoputil.SIPCommFrame;
import net.java.sip.communicator.plugin.desktoputil.StyledHTMLEditorPane;
import net.java.sip.communicator.plugin.desktoputil.TransparentPanel;
import net.java.sip.communicator.plugin.desktoputil.X509CertificatePanel;
import org.jitsi.service.resources.ResourceManagementService;

public class ViewCertificateFrame
extends SIPCommFrame {
    private static final long serialVersionUID = 0L;
    private final ResourceManagementService R = DesktopUtilActivator.getResources();
    private static final int MAX_MSG_PANE_WIDTH = 600;
    private static final int MAX_MSG_PANE_HEIGHT = 800;
    Certificate[] certs;
    String message;
    TransparentPanel certPanel;
    TransparentPanel contentPane;

    public ViewCertificateFrame(Certificate[] certs, String title, String message) {
        super(false);
        this.setTitle(title != null ? title : this.R.getI18NString("service.gui.CERT_DIALOG_TITLE"));
        this.certs = certs;
        this.message = message;
        this.setDefaultCloseOperation(2);
        this.init();
        this.setLocationRelativeTo(this.getParent());
    }

    private void init() {
        this.getContentPane().setLayout(new BorderLayout());
        this.contentPane = new TransparentPanel(new BorderLayout(5, 5));
        TransparentPanel northPanel = new TransparentPanel(new BorderLayout(5, 5));
        northPanel.setBorder(BorderFactory.createEmptyBorder(10, 5, 5, 5));
        JLabel imgLabel = new JLabel(this.R.getImage("service.gui.icons.CERTIFICATE_WARNING"));
        imgLabel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        northPanel.add(imgLabel, "West");
        StyledHTMLEditorPane descriptionPane = new StyledHTMLEditorPane();
        descriptionPane.setOpaque(false);
        descriptionPane.setEditable(false);
        descriptionPane.setContentType("text/html");
        descriptionPane.setText(this.message);
        descriptionPane.setSize(new Dimension(600, 800));
        int height = descriptionPane.getPreferredSize().height;
        descriptionPane.setPreferredSize(new Dimension(600, height));
        northPanel.add(descriptionPane, "Center");
        this.contentPane.add((Component)((Object)northPanel), "North");
        this.certPanel = new TransparentPanel(new BorderLayout());
        this.contentPane.add((Component)((Object)this.certPanel), "Center");
        this.getContentPane().add((Component)((Object)this.contentPane), "Center");
        this.certPanel.add((Component)((Object)new X509CertificatePanel(this.certs)), "Center");
        this.setPreferredSize(null);
        this.pack();
    }
}

