/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.desktoputil;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.ImageIcon;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import net.java.sip.communicator.plugin.desktoputil.AntialiasingManager;
import net.java.sip.communicator.plugin.desktoputil.FramedImage;
import org.jvnet.lafwidget.animation.FadeKind;
import org.jvnet.lafwidget.animation.FadeTracker;
import org.jvnet.lafwidget.animation.FadeTrackerCallback;

public class FramedImageWithMenu
extends FramedImage
implements MouseListener,
PopupMenuListener {
    private static final long serialVersionUID = 0L;
    private JPopupMenu popupMenu;
    private boolean drawOverlay = false;
    private boolean isDefaultImage = true;
    private Image currentImage;

    public FramedImageWithMenu(ImageIcon imageIcon, int width, int height) {
        super(imageIcon, width, height);
        this.addMouseListener(this);
    }

    public void setPopupMenu(JPopupMenu popupMenu) {
        this.popupMenu = popupMenu;
        if (popupMenu != null) {
            this.popupMenu.addPopupMenuListener(this);
        }
    }

    public void setImageIcon(ImageIcon imageIcon) {
        super.setImageIcon(imageIcon.getImage());
        this.isDefaultImage = false;
        this.currentImage = imageIcon.getImage();
    }

    @Override
    public void setImageIcon(byte[] image) {
        super.setImageIcon(image);
        this.isDefaultImage = false;
        this.currentImage = super.getImage();
    }

    public Image getAvatar() {
        return !this.isDefaultImage ? this.currentImage : this.getImage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.drawOverlay) {
            g = g.create();
            AntialiasingManager.activateAntialiasing(g);
            try {
                FadeTracker fadeTracker = FadeTracker.getInstance();
                float visibility = 0.0f;
                if (fadeTracker.isTracked(this, FadeKind.ROLLOVER)) {
                    visibility = fadeTracker.getFade(this, FadeKind.ROLLOVER);
                    visibility /= 4.0f;
                } else {
                    visibility = 0.5f;
                }
                g.setColor(new Color(0.0f, 0.0f, 0.0f, visibility));
                g.fillRoundRect(1, 1, this.width - 2, this.height - 2, 10, 10);
                g.setColor(Color.WHITE);
                int[] arrowX = new int[]{this.width - 17, this.width - 7, this.width - 12};
                int[] arrowY = new int[]{this.height - 12, this.height - 12, this.height - 7};
                g.fillPolygon(arrowX, arrowY, arrowX.length);
            }
            finally {
                g.dispose();
            }
        }
    }

    private void showDialog(MouseEvent e, boolean show) {
        if (this.popupMenu == null) {
            return;
        }
        if (show) {
            Point imageLoc = this.getLocationOnScreen();
            Point rootPaneLoc = this.getRootPane().getLocationOnScreen();
            this.popupMenu.setSize(this.getRootPane().getWidth(), this.popupMenu.getHeight());
            this.popupMenu.show(this, rootPaneLoc.x - imageLoc.x, this.getHeight());
        } else {
            this.drawOverlay = false;
            this.repaint();
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        if (this.popupMenu == null) {
            return;
        }
        if (this.drawOverlay || !this.isEnabled()) {
            return;
        }
        this.drawOverlay = true;
        FadeTracker fadeTracker = FadeTracker.getInstance();
        fadeTracker.trackFadeIn(FadeKind.ROLLOVER, this, true, new AvatarRepaintCallback());
    }

    @Override
    public void mouseExited(MouseEvent e) {
        if (this.popupMenu == null) {
            return;
        }
        if (!this.popupMenu.isVisible() && this.isEnabled()) {
            this.drawOverlay = false;
            this.repaint();
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.popupMenu == null) {
            return;
        }
        if (this.isEnabled()) {
            this.showDialog(e, !this.popupMenu.isVisible());
        }
    }

    @Override
    public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
    }

    @Override
    public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
        this.drawOverlay = false;
        this.repaint();
    }

    @Override
    public void popupMenuCanceled(PopupMenuEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    private class AvatarRepaintCallback
    implements FadeTrackerCallback {
        private AvatarRepaintCallback() {
        }

        @Override
        public void fadeEnded(FadeKind arg0) {
            this.repaintLater();
        }

        @Override
        public void fadePerformed(FadeKind arg0, float arg1) {
            this.repaintLater();
        }

        private void repaintLater() {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    FramedImageWithMenu.this.repaint();
                }
            });
        }

        @Override
        public void fadeReversed(FadeKind arg0, boolean arg1, float arg2) {
        }
    }
}

