/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.desktoputil;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.Rectangle2D;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class ComponentUtils {
    public static int getStringWidth(Component c, String text) {
        return SwingUtilities.computeStringWidth(c.getFontMetrics(c.getFont()), text);
    }

    public static Dimension getStringSize(Component c, String text) {
        FontMetrics metrics = c.getFontMetrics(c.getFont());
        int hgt = metrics.getHeight();
        int adv = metrics.stringWidth(text);
        return new Dimension(adv + 2, hgt + 2);
    }

    public static int getStringHeight(Component c) {
        FontMetrics metrics = c.getFontMetrics(c.getFont());
        int hgt = metrics.getHeight();
        return hgt + 2;
    }

    public static Rectangle2D getDefaultStringSize(String text) {
        Font font = UIManager.getFont("Label.font");
        FontRenderContext frc = new FontRenderContext(null, true, false);
        TextLayout layout = new TextLayout(text, font, frc);
        return layout.getBounds();
    }

    public static void updateComponentTreeUI(Component c) {
        ComponentUtils.updateComponentTreeUI0(c);
        c.invalidate();
        c.validate();
        c.repaint();
    }

    public static int getComponentIndex(Component c, Container container) {
        int count = container.getComponentCount();
        for (int i = 0; i < count; ++i) {
            if (!container.getComponent(i).equals(c)) continue;
            return i;
        }
        return -1;
    }

    private static void updateComponentTreeUI0(Component c) {
        if (c instanceof JComponent) {
            JComponent jc = (JComponent)c;
            jc.invalidate();
            jc.validate();
            jc.repaint();
            JPopupMenu jpm = jc.getComponentPopupMenu();
            if (jpm != null && jpm.isVisible() && jpm.getInvoker() == jc) {
                ComponentUtils.updateComponentTreeUI(jpm);
            }
        }
        Component[] children = null;
        if (c instanceof JMenu) {
            children = ((JMenu)c).getMenuComponents();
        } else if (c instanceof Container) {
            children = ((Container)c).getComponents();
        }
        if (children != null) {
            for (int i = 0; i < children.length; ++i) {
                ComponentUtils.updateComponentTreeUI0(children[i]);
            }
        }
    }
}

