/*
 * Decompiled with CFR 0.152.
 */
package com.ircclouds.irc.api.comms;

import com.ircclouds.irc.api.comms.IConnection;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import nl.dannyvanheumen.nio.ProxiedSocketChannel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SSLSocketChannelConnection
implements IConnection {
    private static final Logger LOG = LoggerFactory.getLogger(SSLSocketChannelConnection.class);
    private SocketChannel sChannel;
    private SSLEngine sslEngine;
    private ByteBuffer appSendBuffer;
    private ByteBuffer appRecvBuffer;
    private ByteBuffer cipherSendBuffer;
    private ByteBuffer cipherRecvBuffer;
    private SSLEngineResult.HandshakeStatus hStatus;
    private int remaingUnwraps;

    @Override
    public boolean open(String aHostname, int aPort, SSLContext aContext, Proxy aProxy, boolean resolveThroughProxy) throws IOException {
        InetSocketAddress address;
        this.sslEngine = aContext != null ? aContext.createSSLEngine(aHostname, aPort) : this.getDefaultSSLContext().createSSLEngine(aHostname, aPort);
        this.sslEngine.setNeedClientAuth(false);
        this.sslEngine.setUseClientMode(true);
        this.sslEngine.beginHandshake();
        this.hStatus = this.sslEngine.getHandshakeStatus();
        this.appSendBuffer = ByteBuffer.allocate(this.sslEngine.getSession().getApplicationBufferSize());
        this.cipherSendBuffer = ByteBuffer.allocate(this.sslEngine.getSession().getPacketBufferSize());
        this.cipherRecvBuffer = ByteBuffer.allocate(this.sslEngine.getSession().getPacketBufferSize());
        this.appRecvBuffer = ByteBuffer.allocate(this.sslEngine.getSession().getApplicationBufferSize());
        if (aProxy != null && aProxy.type() == Proxy.Type.SOCKS) {
            this.sChannel = new ProxiedSocketChannel(aProxy);
            address = resolveThroughProxy ? InetSocketAddress.createUnresolved(aHostname, aPort) : new InetSocketAddress(aHostname, aPort);
        } else {
            this.sChannel = SocketChannel.open();
            address = new InetSocketAddress(aHostname, aPort);
        }
        return this.sChannel.connect(address);
    }

    @Override
    public String read() throws IOException {
        this.doAnyPendingHandshake();
        if (this.sslEngine.isInboundDone()) {
            throw new IConnection.EndOfStreamException();
        }
        this.tryReadAndUnwrap();
        byte[] _bytes = new byte[this.appRecvBuffer.flip().limit()];
        this.appRecvBuffer.get(_bytes);
        this.appRecvBuffer.clear();
        return new String(_bytes);
    }

    @Override
    public int write(String aMessage) throws IOException {
        this.doAnyPendingHandshake();
        this.appSendBuffer.clear();
        this.appSendBuffer.put(aMessage.getBytes()).flip();
        return this.wrapAndWrite();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        try {
            if (this.sChannel.isConnected()) {
                if (!this.sslEngine.isOutboundDone()) {
                    this.sslEngine.closeOutbound();
                    this.doAnyPendingHandshake();
                } else if (!this.sslEngine.isInboundDone()) {
                    this.sslEngine.closeInbound();
                    this.processHandshake();
                }
            }
        }
        catch (IOException iOException) {
        }
        finally {
            if (this.sChannel.isOpen()) {
                this.sChannel.close();
            }
        }
    }

    private synchronized void doAnyPendingHandshake() throws IOException {
        while (this.processHandshake()) {
        }
    }

    private synchronized boolean processHandshake() throws IOException {
        LOG.debug(Thread.currentThread().getName() + " " + (Object)((Object)this.hStatus));
        switch (this.hStatus) {
            case NEED_WRAP: {
                this.wrapAndWrite();
                break;
            }
            case NEED_UNWRAP: {
                if (!this.sslEngine.isInboundDone()) {
                    this.tryReadAndUnwrap();
                    break;
                }
                return false;
            }
            case NEED_TASK: {
                this.executeTasks();
                break;
            }
            case NOT_HANDSHAKING: 
            case FINISHED: {
                return false;
            }
        }
        return true;
    }

    private void tryReadAndUnwrap() throws IOException, SSLException {
        if (this.remaingUnwraps == 0) {
            this.cipherRecvBuffer.clear();
            int _readCount = this.sChannel.read(this.cipherRecvBuffer);
            if (_readCount == -1) {
                throw new IConnection.EndOfStreamException();
            }
            this.remaingUnwraps += _readCount;
            LOG.debug("Reading: " + _readCount);
            this.cipherRecvBuffer.flip();
        }
        SSLEngineResult _hRes = this.sslEngine.unwrap(this.cipherRecvBuffer, this.appRecvBuffer);
        this.hStatus = _hRes.getHandshakeStatus();
        this.remaingUnwraps -= _hRes.bytesConsumed();
        switch (_hRes.getStatus()) {
            case BUFFER_UNDERFLOW: {
                int bytesRead = this.sChannel.read(this.cipherRecvBuffer.compact());
                if (bytesRead == -1) {
                    throw new IConnection.EndOfStreamException();
                }
                this.remaingUnwraps += bytesRead;
                this.cipherRecvBuffer.flip();
                break;
            }
        }
    }

    private int wrapAndWrite() throws SSLException, IOException {
        if (this.cipherSendBuffer.position() != 0) {
            this.cipherSendBuffer.compact();
        }
        SSLEngineResult _hRes = this.sslEngine.wrap(this.appSendBuffer, this.cipherSendBuffer);
        this.hStatus = _hRes.getHandshakeStatus();
        this.cipherSendBuffer.flip();
        return this.sChannel.write(this.cipherSendBuffer);
    }

    private void executeTasks() {
        Runnable _r = null;
        while ((_r = this.sslEngine.getDelegatedTask()) != null) {
            new Thread(_r).start();
        }
        this.hStatus = this.sslEngine.getHandshakeStatus();
    }

    private SSLContext getDefaultSSLContext() {
        try {
            SSLContext _sslCtx = SSLContext.getInstance("SSL");
            _sslCtx.init(null, new TrustManager[]{new X509TrustManager(){

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }

                @Override
                public void checkClientTrusted(X509Certificate[] certs, String authType) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] certs, String authType) {
                }
            }}, new SecureRandom());
            return _sslCtx;
        }
        catch (Exception aExc) {
            throw new RuntimeException(aExc);
        }
    }
}

