/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.gui.utils;

import java.util.Date;
import java.util.List;
import javax.swing.JComponent;
import net.java.sip.communicator.impl.gui.GuiActivator;
import net.java.sip.communicator.impl.gui.main.call.ChooseCallAccountPopupMenu;
import net.java.sip.communicator.impl.gui.main.chat.ChatPanel;
import net.java.sip.communicator.impl.gui.main.chat.ChatTransport;
import net.java.sip.communicator.impl.gui.main.contactlist.UIContactImpl;
import net.java.sip.communicator.service.contactlist.MetaContact;
import net.java.sip.communicator.service.gui.UIContactDetail;
import net.java.sip.communicator.service.protocol.Contact;
import net.java.sip.communicator.service.protocol.Message;
import net.java.sip.communicator.service.protocol.OperationSet;
import net.java.sip.communicator.service.protocol.OperationSetBasicTelephony;
import net.java.sip.communicator.service.protocol.OperationSetSmsMessaging;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import net.java.sip.communicator.util.Logger;
import net.java.sip.communicator.util.account.AccountUtils;

public class SMSManager {
    private static final Logger logger = Logger.getLogger(SMSManager.class);

    public static void sendSMS(JComponent invoker, String to) {
        SMSManager.sendSMSInternal(invoker, to, null, null);
    }

    private static void sendSMSInternal(JComponent invoker, String to, String messageText, ChatPanel chatPanel) {
        List providers = AccountUtils.getRegisteredProviders(OperationSetSmsMessaging.class);
        if (providers.size() == 1) {
            if (messageText != null) {
                SMSManager.sendSMSInternal(to, messageText, (ProtocolProviderService)providers.get(0), null, chatPanel);
            } else {
                SMSManager.sendSMSInternal((ProtocolProviderService)providers.get(0), to);
            }
        } else if (providers.size() > 1) {
            ChooseSMSAccountPopupMenu chooseAccountDialog = new ChooseSMSAccountPopupMenu(invoker, to, providers, messageText, chatPanel);
            chooseAccountDialog.setLocation(invoker.getLocation());
            chooseAccountDialog.showPopupMenu();
        }
    }

    public static void sendSMS(ProtocolProviderService protocolProviderService, String to, String messageText) throws Exception {
        OperationSetSmsMessaging smsOpSet = (OperationSetSmsMessaging)protocolProviderService.getOperationSet(OperationSetSmsMessaging.class);
        Message smsMessage = smsOpSet.createMessage(messageText);
        smsOpSet.sendSmsMessage(to, smsMessage);
    }

    public static void sendSMS(Contact contact, String messageText) throws Exception {
        OperationSetSmsMessaging smsOpSet = (OperationSetSmsMessaging)contact.getProtocolProvider().getOperationSet(OperationSetSmsMessaging.class);
        Message smsMessage = smsOpSet.createMessage(messageText);
        smsOpSet.sendSmsMessage(contact, smsMessage);
    }

    private static void sendSMSInternal(ProtocolProviderService protocolProviderService, String to) {
        OperationSetSmsMessaging smsMessaging = (OperationSetSmsMessaging)protocolProviderService.getOperationSet(OperationSetSmsMessaging.class);
        Contact contact = smsMessaging.getContact(to);
        MetaContact metaContact = GuiActivator.getContactListService().findMetaContactByContact(contact);
        if (metaContact == null) {
            logger.error((Object)("MetaContact not found for: " + contact));
            return;
        }
        GuiActivator.getUIService().getChatWindowManager().startChat(metaContact, contact, true);
    }

    public static void sendSMS(JComponent invoker, List<UIContactDetail> additionalNumbers, String messageText, ChatPanel chatPanel) {
        if (additionalNumbers.size() == 1) {
            SMSManager.sendSMSInternal(invoker, additionalNumbers.get(0).getAddress(), messageText, chatPanel);
        } else {
            ChooseSMSAccountPopupMenu chooseAccountDialog = new ChooseSMSAccountPopupMenu(invoker, additionalNumbers, OperationSetSmsMessaging.class, messageText, chatPanel);
            chooseAccountDialog.setLocation(invoker.getLocation());
            chooseAccountDialog.showPopupMenu();
        }
    }

    public static void sendSMS(String phoneNumber, String message, ChatTransport chatTransport, ChatPanel chatPanel) {
        SMSManager.sendSMSInternal(phoneNumber, message, null, chatTransport, chatPanel);
    }

    private static void sendSMSInternal(String phoneNumber, String message, ProtocolProviderService protocolProviderService, ChatTransport chatTransport, ChatPanel chatPanel) {
        try {
            if (protocolProviderService != null) {
                SMSManager.sendSMS(protocolProviderService, phoneNumber, message);
            } else if (phoneNumber != null) {
                chatTransport.sendSmsMessage(phoneNumber, message);
            } else {
                chatTransport.sendSmsMessage(message);
            }
        }
        catch (IllegalStateException ex) {
            logger.error((Object)"Failed to send SMS.", (Throwable)ex);
            chatPanel.addMessage(phoneNumber, new Date(), "OutgoingMessage", message, "text/plain");
            chatPanel.addErrorMessage(phoneNumber, GuiActivator.getResources().getI18NString("service.gui.SMS_SEND_CONNECTION_PROBLEM"));
        }
        catch (Exception ex) {
            logger.error((Object)"Failed to send SMS.", (Throwable)ex);
            chatPanel.addMessage(phoneNumber == null ? chatTransport.getName() : phoneNumber, new Date(), "OutgoingMessage", message, "text/plain");
            chatPanel.addErrorMessage(phoneNumber == null ? chatTransport.getName() : phoneNumber, ex.getMessage());
        }
        chatPanel.refreshWriteArea();
    }

    private static class ChooseSMSAccountPopupMenu
    extends ChooseCallAccountPopupMenu {
        private String messageText = null;
        private ChatPanel chatPanel = null;

        public ChooseSMSAccountPopupMenu(JComponent invoker, String contactToCall, List<ProtocolProviderService> telephonyProviders, String messageText, ChatPanel chatPanel) {
            super(invoker, contactToCall, telephonyProviders, OperationSetBasicTelephony.class);
            this.messageText = messageText;
            this.chatPanel = chatPanel;
        }

        public ChooseSMSAccountPopupMenu(JComponent invoker, List<?> telephonyObjects, Class<? extends OperationSet> opSetClass, String messageText, ChatPanel chatPanel) {
            super(invoker, telephonyObjects, opSetClass);
            this.messageText = messageText;
            this.chatPanel = chatPanel;
        }

        @Override
        protected void itemSelected(Class<? extends OperationSet> opSetClass, List<ProtocolProviderService> providers, String contact) {
            SMSManager.sendSMSInternal(this.invoker, contact, this.messageText, this.chatPanel);
        }

        @Override
        protected void itemSelected(Class<? extends OperationSet> opSetClass, ProtocolProviderService protocolProviderService, String contact, UIContactImpl uiContact) {
            if (this.messageText != null) {
                SMSManager.sendSMSInternal(contact, this.messageText, protocolProviderService, null, this.chatPanel);
            } else {
                SMSManager.sendSMSInternal(protocolProviderService, contact);
            }
        }

        @Override
        protected void itemSelected(Class<? extends OperationSet> opSetClass, ProtocolProviderService protocolProviderService, String contact) {
            if (this.messageText != null) {
                SMSManager.sendSMSInternal(contact, this.messageText, protocolProviderService, null, this.chatPanel);
            } else {
                SMSManager.sendSMSInternal(protocolProviderService, contact);
            }
        }

        @Override
        protected String getI18NKeyChooseContact() {
            return "service.gui.CHOOSE_NUMBER";
        }

        @Override
        protected String getI18NKeyCallVia() {
            return "service.gui.SEND_VIA";
        }
    }
}

