/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.gui.utils;

import java.awt.Color;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.regex.Pattern;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.text.html.StyleSheet;
import net.java.sip.communicator.impl.gui.GuiActivator;
import net.java.sip.communicator.impl.gui.utils.ImageLoader;
import net.java.sip.communicator.service.protocol.PresenceStatus;
import net.java.sip.communicator.util.Logger;

public class Constants {
    private static final Logger logger = Logger.getLogger(Constants.class);
    public static boolean REMOVE_CONTACT_ASK = true;
    public static boolean REMOVE_GROUP_ASK = true;
    public static Color CALL_HISTORY_EVEN_ROW_COLOR = new Color(GuiActivator.getResources().getColor("service.gui.CALL_HISTORY_EVEN_ROW_COLOR"));
    public static Color CHAT_ROOM_ROW_COLOR = new Color(GuiActivator.getResources().getColor("service.gui.CHAT_ROOM_ROW_COLOR"));
    public static Color SELECTED_COLOR = new Color(GuiActivator.getResources().getColor("service.gui.LIST_SELECTION_COLOR"));
    public static Color SELECTED_GRADIENT_COLOR = new Color(GuiActivator.getResources().getColor("service.gui.LIST_SELECTION_COLOR_GRADIENT"));
    public static Color GRADIENT_DARK_COLOR = new Color(GuiActivator.getResources().getColor("service.gui.GRADIENT_DARK_COLOR"));
    public static Color GRADIENT_LIGHT_COLOR = new Color(GuiActivator.getResources().getColor("service.gui.GRADIENT_LIGHT_COLOR"));
    public static Color BORDER_COLOR = new Color(GuiActivator.getResources().getColor("service.gui.BORDER_COLOR"));
    public static Color LIST_SELECTION_BORDER_COLOR = new Color(GuiActivator.getResources().getColor("service.gui.LIST_SELECTION_BORDER_COLOR"));
    public static Color CONTACT_LIST_GROUP_BG_COLOR = new Color(GuiActivator.getResources().getColor("service.gui.CONTACT_LIST_GROUP_ROW"));
    public static Color CONTACT_LIST_GROUP_BG_GRADIENT_COLOR = new Color(GuiActivator.getResources().getColor("service.gui.CONTACT_LIST_GROUP_GRADIENT"));
    public static final Font FONT;
    public static final String DEFAULT_STYLE_PATH = "resources/styles";
    private static final int[] specialChars;

    public static boolean isSpecialChar(int charCode) {
        for (int specialChar : specialChars) {
            if (specialChar != charCode) continue;
            return true;
        }
        return false;
    }

    public static BufferedImage getStatusIcon(PresenceStatus status) {
        if (status != null) {
            int connectivity = status.getStatus();
            if (connectivity < 20) {
                return ImageLoader.getImage(ImageLoader.USER_OFFLINE_ICON);
            }
            if (connectivity < 31) {
                return ImageLoader.getImage(ImageLoader.USER_DND_ICON);
            }
            if (connectivity < 36) {
                String statusName = "";
                if (status.getStatusName() != null) {
                    statusName = Pattern.compile("\\p{Space}").matcher(status.getStatusName()).replaceAll("");
                }
                if (statusName.equalsIgnoreCase("OnThePhone")) {
                    return ImageLoader.getImage(ImageLoader.USER_USER_ON_THE_PHONE_ICON);
                }
                if (statusName.equalsIgnoreCase("InAMeeting")) {
                    return ImageLoader.getImage(ImageLoader.USER_USER_IN_A_MEETING_ICON);
                }
                return ImageLoader.getImage(ImageLoader.USER_EXTENDED_AWAY_ICON);
            }
            if (connectivity < 50) {
                return ImageLoader.getImage(ImageLoader.USER_AWAY_ICON);
            }
            if (connectivity < 80) {
                return ImageLoader.getImage(ImageLoader.USER_ONLINE_ICON);
            }
            if (connectivity < 86) {
                return ImageLoader.getImage(ImageLoader.USER_FFC_ICON);
            }
            if (connectivity < 87) {
                return ImageLoader.getImage(ImageLoader.CHAT_ROOM_ONLINE_ICON);
            }
            if (connectivity == 89) {
                return ImageLoader.getImage(ImageLoader.MSG_SRC_CONTACT_ONLINE_ICON);
            }
            if (connectivity < 100) {
                return ImageLoader.getImage(ImageLoader.CHAT_ROOM_OFFLINE_ICON);
            }
            return ImageLoader.getImage(ImageLoader.USER_OFFLINE_ICON);
        }
        return ImageLoader.getImage(ImageLoader.USER_OFFLINE_ICON);
    }

    public static BufferedImage getMessageStatusIcon(PresenceStatus status) {
        if (status != null) {
            int connectivity = status.getStatus();
            if (connectivity < 20) {
                return ImageLoader.getImage(ImageLoader.CHAT_BUTTON_OFFLINE_ICON);
            }
            if (connectivity < 31) {
                return ImageLoader.getImage(ImageLoader.CHAT_BUTTON_DND_ICON);
            }
            if (connectivity == 31) {
                return ImageLoader.getImage(ImageLoader.CHAT_BUTTON_ON_THE_PHONE_ICON);
            }
            if (connectivity < 36) {
                return ImageLoader.getImage(ImageLoader.CHAT_BUTTON_EXTENDED_AWAY_ICON);
            }
            if (connectivity < 50) {
                return ImageLoader.getImage(ImageLoader.CHAT_BUTTON_AWAY_ICON);
            }
            if (connectivity < 80) {
                return ImageLoader.getImage(ImageLoader.CHAT_BUTTON_ONLINE_ICON);
            }
            if (connectivity < 100) {
                return ImageLoader.getImage(ImageLoader.CHAT_BUTTON_FFC_ICON);
            }
            return ImageLoader.getImage(ImageLoader.CHAT_BUTTON_OFFLINE_ICON);
        }
        return ImageLoader.getImage(ImageLoader.CHAT_BUTTON_SMALL_WHITE);
    }

    public static void loadAdiumStyle() {
        new File(Constants.class.getClassLoader().getResource("resources/styles/TotallyClear").toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadSimpleStyle(StyleSheet styleSheet, Font defaultFont) {
        BufferedReader r = new BufferedReader(new InputStreamReader(GuiActivator.getResources().getSettingsInputStream("service.gui.HTML_TEXT_STYLE")));
        if (defaultFont != null) {
            styleSheet.addRule("body, div, h1, h2, h3, h4, h5, h6, h7, p, td, th { font-family: " + defaultFont.getName() + "; font-size: " + defaultFont.getSize() + "pt; }");
        }
        try {
            styleSheet.loadRules(r, null);
        }
        catch (IOException ex) {
            logger.error((Object)"Failed to load CSS stream.", (Throwable)ex);
        }
        finally {
            try {
                ((Reader)r).close();
            }
            catch (IOException ex) {
                logger.error((Object)"Failed to close CSS stream.", (Throwable)ex);
            }
        }
    }

    public static void reload() {
        CALL_HISTORY_EVEN_ROW_COLOR = new Color(GuiActivator.getResources().getColor("service.gui.CALL_HISTORY_EVEN_ROW_COLOR"));
        SELECTED_COLOR = new Color(GuiActivator.getResources().getColor("service.gui.LIST_SELECTION_COLOR"));
        GRADIENT_DARK_COLOR = new Color(GuiActivator.getResources().getColor("service.gui.GRADIENT_DARK_COLOR"));
        GRADIENT_LIGHT_COLOR = new Color(GuiActivator.getResources().getColor("service.gui.GRADIENT_LIGHT_COLOR"));
        BORDER_COLOR = new Color(GuiActivator.getResources().getColor("service.gui.BORDER_COLOR"));
        LIST_SELECTION_BORDER_COLOR = new Color(GuiActivator.getResources().getColor("service.gui.LIST_SELECTION_BORDER_COLOR"));
        CONTACT_LIST_GROUP_BG_COLOR = new Color(GuiActivator.getResources().getColor("service.gui.CONTACT_LIST_GROUP_ROW"));
        CONTACT_LIST_GROUP_BG_GRADIENT_COLOR = new Color(GuiActivator.getResources().getColor("service.gui.CONTACT_LIST_GROUP_GRADIENT"));
    }

    static {
        LookAndFeel laf = UIManager.getLookAndFeel();
        Font font = null;
        Object fontName = null;
        int fontSize = 0;
        if (laf != null) {
            String lafClassName = laf.getClass().getName();
            if ("com.sun.java.swing.plaf.windows.WindowsLookAndFeel".equals(lafClassName)) {
                Object desktopPropertyValue = Toolkit.getDefaultToolkit().getDesktopProperty("win.messagebox.font");
                if (desktopPropertyValue instanceof Font) {
                    font = (Font)desktopPropertyValue;
                }
            } else if ("com.sun.java.swing.plaf.gtk.GTKLookAndFeel".equals(lafClassName)) {
                font = UIManager.getDefaults().getFont("Panel.font");
            }
        }
        FONT = font == null ? new Font(fontName == null ? "Verdana" : fontName, 0, fontSize == 0 ? 12 : fontSize) : font;
        specialChars = new int[]{521, 45, 32, 10, 37, 39};
    }
}

