/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.gui.main.chat.conference;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JViewport;
import javax.swing.ListCellRenderer;
import net.java.sip.communicator.impl.gui.GuiActivator;
import net.java.sip.communicator.impl.gui.main.chat.ChatPanel;
import net.java.sip.communicator.impl.gui.main.chat.conference.ChatConferenceCallsListModels;
import net.java.sip.communicator.impl.gui.main.contactlist.CListKeySearchListener;
import net.java.sip.communicator.impl.gui.utils.Constants;
import net.java.sip.communicator.impl.gui.utils.ImageLoader;
import net.java.sip.communicator.plugin.desktoputil.AntialiasingManager;
import net.java.sip.communicator.plugin.desktoputil.SIPCommScrollPane;
import net.java.sip.communicator.service.protocol.ConferenceDescription;
import net.java.sip.communicator.util.skin.Skinnable;

public class ChatRoomConferenceCallsListPanel
extends JPanel
implements Skinnable {
    private static final long serialVersionUID = -8250816784228586068L;
    private final JList conferenceCallList;
    private final ChatConferenceCallsListModels conferenceCallsListModel;
    private final ChatPanel chatPanel;

    public ChatRoomConferenceCallsListPanel(ChatPanel chatPanel) {
        super(new BorderLayout());
        this.chatPanel = chatPanel;
        this.conferenceCallsListModel = new ChatConferenceCallsListModels(chatPanel.getChatSession());
        this.conferenceCallList = new JList(this.conferenceCallsListModel);
        this.conferenceCallList.addKeyListener(new CListKeySearchListener(this.conferenceCallList));
        this.conferenceCallList.setCellRenderer(new ChatConferenceCallsListRenderer());
        SIPCommScrollPane conferenceCallsScrollPane = new SIPCommScrollPane();
        conferenceCallsScrollPane.setHorizontalScrollBarPolicy(31);
        conferenceCallsScrollPane.setOpaque(false);
        conferenceCallsScrollPane.setBorder(null);
        JViewport viewport = conferenceCallsScrollPane.getViewport();
        viewport.setOpaque(false);
        viewport.add(this.conferenceCallList);
        this.add((Component)conferenceCallsScrollPane);
    }

    public void addConference(ConferenceDescription chatConference) {
        this.conferenceCallsListModel.addElement(chatConference);
    }

    public int getListSize() {
        return this.conferenceCallsListModel.getSize();
    }

    public ConferenceDescription getSelectedValue() {
        return (ConferenceDescription)this.conferenceCallList.getSelectedValue();
    }

    public void initConferences() {
        this.conferenceCallsListModel.initConferences();
        this.setSelectedIndex(0);
    }

    public void setSelectedIndex(int index) {
        this.conferenceCallList.setSelectedIndex(index);
    }

    public void loadSkin() {
        ((ChatConferenceCallsListRenderer)this.conferenceCallList.getCellRenderer()).loadSkin();
    }

    public void removeConference(ConferenceDescription chatConference) {
        this.conferenceCallsListModel.removeElement(chatConference);
    }

    private class ChatConferenceCallsListRenderer
    extends JPanel
    implements ListCellRenderer,
    Skinnable {
        private JLabel conferenceLabel;
        private Color contactForegroundColor;
        private boolean isSelected;
        private final ImageIcon conferenceIcon;

        public ChatConferenceCallsListRenderer() {
            super(new BorderLayout());
            this.conferenceLabel = new JLabel();
            this.conferenceIcon = new ImageIcon(ImageLoader.getImage(ImageLoader.CONFERENCE_ICON));
            this.setOpaque(false);
            this.conferenceLabel.setOpaque(false);
            this.conferenceLabel.setPreferredSize(new Dimension(10, 20));
            this.setFont(this.getFont().deriveFont(0));
            this.setBorder(BorderFactory.createEmptyBorder(2, 5, 1, 1));
            this.conferenceLabel.setOpaque(false);
            this.conferenceLabel.setIcon(this.conferenceIcon);
            this.add((Component)this.conferenceLabel, "Center");
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.isSelected = isSelected;
            if (this.contactForegroundColor != null) {
                this.setForeground(this.contactForegroundColor);
            }
            this.setFont(this.getFont().deriveFont(0));
            this.conferenceLabel.setText(((ConferenceDescription)value).getDisplayName());
            return this;
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            g = g.create();
            try {
                this.internalPaintComponent(g);
            }
            finally {
                g.dispose();
            }
        }

        private void internalPaintComponent(Graphics g) {
            if (this.isSelected) {
                AntialiasingManager.activateAntialiasing((Graphics)g);
                Graphics2D g2 = (Graphics2D)g;
                g2.setColor(Constants.SELECTED_COLOR);
                g2.fillRoundRect(1, 1, this.getWidth() - 2, this.getHeight() - 1, 10, 10);
            }
        }

        public void loadSkin() {
            int contactForegroundProperty = GuiActivator.getResources().getColor("service.gui.CHATROOM_CONFERENCE_LIST_FOREGROUND");
            if (contactForegroundProperty > -1) {
                this.contactForegroundColor = new Color(contactForegroundProperty);
            }
        }
    }
}

