/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.gui.main.chat;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.basic.BasicSplitPaneUI;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Highlighter;
import net.java.sip.communicator.impl.gui.GuiActivator;
import net.java.sip.communicator.impl.gui.main.chat.ChatContact;
import net.java.sip.communicator.impl.gui.main.chat.ChatContainer;
import net.java.sip.communicator.impl.gui.main.chat.ChatConversationComponent;
import net.java.sip.communicator.impl.gui.main.chat.ChatConversationContainer;
import net.java.sip.communicator.impl.gui.main.chat.ChatConversationPanel;
import net.java.sip.communicator.impl.gui.main.chat.ChatHistoryListener;
import net.java.sip.communicator.impl.gui.main.chat.ChatMessage;
import net.java.sip.communicator.impl.gui.main.chat.ChatSession;
import net.java.sip.communicator.impl.gui.main.chat.ChatSessionChangeListener;
import net.java.sip.communicator.impl.gui.main.chat.ChatSessionRenderer;
import net.java.sip.communicator.impl.gui.main.chat.ChatTransferHandler;
import net.java.sip.communicator.impl.gui.main.chat.ChatTransport;
import net.java.sip.communicator.impl.gui.main.chat.ChatWindowManager;
import net.java.sip.communicator.impl.gui.main.chat.ChatWritePanel;
import net.java.sip.communicator.impl.gui.main.chat.FontChooser;
import net.java.sip.communicator.impl.gui.main.chat.MetaContactChatSession;
import net.java.sip.communicator.impl.gui.main.chat.SendSmsDialog;
import net.java.sip.communicator.impl.gui.main.chat.conference.AdHocChatRoomWrapper;
import net.java.sip.communicator.impl.gui.main.chat.conference.AdHocConferenceChatSession;
import net.java.sip.communicator.impl.gui.main.chat.conference.ChatConferenceCallDialog;
import net.java.sip.communicator.impl.gui.main.chat.conference.ChatRoomMemberListPanel;
import net.java.sip.communicator.impl.gui.main.chat.conference.ChatRoomSubjectPanel;
import net.java.sip.communicator.impl.gui.main.chat.conference.ConferenceChatManager;
import net.java.sip.communicator.impl.gui.main.chat.conference.ConferenceChatSession;
import net.java.sip.communicator.impl.gui.main.chat.filetransfer.FileHistoryConversationComponent;
import net.java.sip.communicator.impl.gui.main.chat.filetransfer.ReceiveFileConversationComponent;
import net.java.sip.communicator.impl.gui.main.chat.filetransfer.SendFileConversationComponent;
import net.java.sip.communicator.impl.gui.utils.Constants;
import net.java.sip.communicator.impl.gui.utils.SMSManager;
import net.java.sip.communicator.plugin.desktoputil.SwingWorker;
import net.java.sip.communicator.plugin.desktoputil.TransparentPanel;
import net.java.sip.communicator.plugin.desktoputil.UIPhoneUtil;
import net.java.sip.communicator.service.contactlist.MetaContact;
import net.java.sip.communicator.service.filehistory.FileRecord;
import net.java.sip.communicator.service.gui.Chat;
import net.java.sip.communicator.service.gui.ChatLinkClickedListener;
import net.java.sip.communicator.service.gui.event.ChatFocusEvent;
import net.java.sip.communicator.service.gui.event.ChatFocusListener;
import net.java.sip.communicator.service.gui.event.ChatMenuListener;
import net.java.sip.communicator.service.metahistory.MetaHistoryService;
import net.java.sip.communicator.service.muc.ChatRoomWrapper;
import net.java.sip.communicator.service.protocol.ChatRoom;
import net.java.sip.communicator.service.protocol.ChatRoomMemberRole;
import net.java.sip.communicator.service.protocol.ConferenceDescription;
import net.java.sip.communicator.service.protocol.FileTransfer;
import net.java.sip.communicator.service.protocol.IncomingFileTransferRequest;
import net.java.sip.communicator.service.protocol.OperationSet;
import net.java.sip.communicator.service.protocol.OperationSetAdHocMultiUserChat;
import net.java.sip.communicator.service.protocol.OperationSetFileTransfer;
import net.java.sip.communicator.service.protocol.OperationSetMultiUserChat;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import net.java.sip.communicator.service.protocol.event.ChatRoomLocalUserRoleChangeEvent;
import net.java.sip.communicator.service.protocol.event.ChatRoomLocalUserRoleListener;
import net.java.sip.communicator.service.protocol.event.ChatRoomMemberPropertyChangeEvent;
import net.java.sip.communicator.service.protocol.event.ChatRoomMemberPropertyChangeListener;
import net.java.sip.communicator.service.protocol.event.ChatRoomMemberRoleChangeEvent;
import net.java.sip.communicator.service.protocol.event.ChatRoomMemberRoleListener;
import net.java.sip.communicator.service.protocol.event.ChatRoomMessageDeliveredEvent;
import net.java.sip.communicator.service.protocol.event.ChatRoomMessageReceivedEvent;
import net.java.sip.communicator.service.protocol.event.FileTransferStatusChangeEvent;
import net.java.sip.communicator.service.protocol.event.FileTransferStatusListener;
import net.java.sip.communicator.service.protocol.event.MessageDeliveredEvent;
import net.java.sip.communicator.service.protocol.event.MessageReceivedEvent;
import net.java.sip.communicator.util.ConfigurationUtils;
import net.java.sip.communicator.util.Logger;
import net.java.sip.communicator.util.skin.Skinnable;
import org.apache.commons.lang3.StringEscapeUtils;
import org.jitsi.util.OSUtils;

public class ChatPanel
extends TransparentPanel
implements ChatSessionRenderer,
ChatSessionChangeListener,
Chat,
ChatConversationContainer,
ChatRoomMemberRoleListener,
ChatRoomLocalUserRoleListener,
ChatRoomMemberPropertyChangeListener,
FileTransferStatusListener,
Skinnable {
    private static final Logger logger = Logger.getLogger(ChatPanel.class);
    private final JSplitPane messagePane = new JSplitPane(0);
    private JSplitPane topSplitPane;
    private final JPanel topPanel = new JPanel(new BorderLayout());
    private final ChatConversationPanel conversationPanel;
    private final JPanel conversationPanelContainer = new JPanel(new BorderLayout());
    private final ChatWritePanel writeMessagePanel;
    private ChatRoomMemberListPanel chatContactListPanel;
    private TransparentPanel conferencePanel = new TransparentPanel((LayoutManager)new BorderLayout());
    private final ChatContainer chatContainer;
    private ChatRoomSubjectPanel subjectPanel;
    public int unreadMessageNumber = 0;
    private JLabel typingNotificationLabel;
    private final Icon typingIcon = GuiActivator.getResources().getImage("service.gui.icons.TYPING");
    public static final int TYPING_NOTIFICATION_SUCCESSFULLY_SENT = 1;
    public static final int TYPING_NOTIFICATION_SEND_FAILED = 0;
    protected static final int MESSAGES_PER_PAGE = 20;
    private boolean isShown = false;
    private ChatSession chatSession;
    private Date firstHistoryMsgTimestamp = new Date(0L);
    private Date lastHistoryMsgTimestamp = new Date(0L);
    private final List<ChatFocusListener> focusListeners = new Vector<ChatFocusListener>();
    private final List<ChatHistoryListener> historyListeners = new Vector<ChatHistoryListener>();
    private final Vector<Object> incomingEventBuffer = new Vector();
    private boolean isHistoryLoaded;
    private final Hashtable<String, Object> activeFileTransfers = new Hashtable();
    private String correctedMessageUID = null;
    private String lastSentMessageUID = null;
    private boolean isPrivateMessagingChat = false;
    protected ChatConferenceCallDialog chatConferencesDialog = null;
    private static final String USE_ADDITIONAL_NUMBERS_PROP = "service.gui.IS_SEND_SMS_USING_ADDITIONAL_NUMBERS";

    public ChatPanel(ChatContainer chatContainer) {
        super((LayoutManager)new BorderLayout());
        this.chatContainer = chatContainer;
        this.conversationPanel = new ChatConversationPanel(this);
        this.conversationPanel.setPreferredSize(new Dimension(400, 200));
        this.conversationPanel.getChatTextPane().setTransferHandler((TransferHandler)((Object)new ChatTransferHandler(this)));
        this.conversationPanelContainer.add((Component)((Object)this.conversationPanel), "Center");
        this.conversationPanelContainer.setBackground(Color.WHITE);
        this.initTypingNotificationLabel(this.conversationPanelContainer);
        this.topPanel.setBackground(Color.WHITE);
        this.topPanel.setBorder(BorderFactory.createMatteBorder(1, 0, 1, 0, Color.GRAY));
        this.writeMessagePanel = new ChatWritePanel(this);
        this.messagePane.setBorder(null);
        this.messagePane.setOpaque(false);
        this.messagePane.addPropertyChangeListener(new DividerLocationListener());
        this.messagePane.setDividerSize(3);
        this.messagePane.setResizeWeight(1.0);
        this.messagePane.setBottomComponent((Component)((Object)this.writeMessagePanel));
        this.messagePane.setTopComponent(this.topPanel);
        this.add(this.messagePane, "Center");
        if (OSUtils.IS_MAC) {
            this.setOpaque(true);
            this.setBackground(new Color(GuiActivator.getResources().getColor("service.gui.MAC_PANEL_BACKGROUND")));
        }
        this.addComponentListener(new TabSelectionComponentListener());
    }

    public void setChatSession(ChatSession chatSession) {
        if (this.chatSession != null) {
            this.chatSession.removeChatTransportChangeListener(this);
        }
        this.chatSession = chatSession;
        this.chatSession.addChatTransportChangeListener(this);
        if (this.chatSession != null && this.chatSession.isContactListSupported()) {
            this.topPanel.remove(this.conversationPanelContainer);
            TransparentPanel rightPanel = new TransparentPanel((LayoutManager)new BorderLayout());
            Dimension chatConferencesListsPanelSize = new Dimension(150, 25);
            Dimension chatContactsListsPanelSize = new Dimension(150, 175);
            Dimension rightPanelSize = new Dimension(150, 200);
            rightPanel.setMinimumSize(rightPanelSize);
            rightPanel.setPreferredSize(rightPanelSize);
            TransparentPanel contactsPanel = new TransparentPanel((LayoutManager)new BorderLayout());
            contactsPanel.setMinimumSize(chatContactsListsPanelSize);
            contactsPanel.setPreferredSize(chatContactsListsPanelSize);
            this.conferencePanel.setMinimumSize(chatConferencesListsPanelSize);
            this.conferencePanel.setPreferredSize(chatConferencesListsPanelSize);
            this.chatContactListPanel = new ChatRoomMemberListPanel(this);
            this.chatContactListPanel.setOpaque(false);
            this.topSplitPane = new JSplitPane(1);
            this.topSplitPane.setBorder(null);
            this.topSplitPane.setOneTouchExpandable(true);
            this.topSplitPane.setOpaque(false);
            this.topSplitPane.setResizeWeight(1.0);
            Color msgNameBackground = Color.decode("#efefef");
            if (this.topSplitPane.getUI() instanceof BasicSplitPaneUI) {
                ((BasicSplitPaneUI)this.topSplitPane.getUI()).getDivider().setBorder(BorderFactory.createLineBorder(msgNameBackground));
            }
            ChatTransport chatTransport = chatSession.getCurrentChatTransport();
            JPanel localUserLabelPanel = new JPanel(new BorderLayout());
            JLabel localUserLabel = new JLabel(chatTransport.getProtocolProvider().getAccountID().getDisplayName());
            localUserLabel.setFont(localUserLabel.getFont().deriveFont(1));
            localUserLabel.setHorizontalAlignment(0);
            localUserLabel.setBorder(BorderFactory.createEmptyBorder(2, 0, 3, 0));
            localUserLabel.setForeground(Color.decode("#488fe7"));
            localUserLabelPanel.add((Component)localUserLabel, "Center");
            localUserLabelPanel.setBackground(msgNameBackground);
            JButton joinConference = new JButton(GuiActivator.getResources().getI18NString("service.gui.JOIN_VIDEO"));
            joinConference.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    ChatPanel.this.showChatConferenceDialog();
                }
            });
            contactsPanel.add((Component)localUserLabelPanel, (Object)"North");
            contactsPanel.add((Component)this.chatContactListPanel, (Object)"Center");
            this.conferencePanel.add((Component)joinConference, (Object)"Center");
            rightPanel.add((Component)this.conferencePanel, (Object)"North");
            rightPanel.add((Component)contactsPanel, (Object)"Center");
            this.topSplitPane.setLeftComponent(this.conversationPanelContainer);
            this.topSplitPane.setRightComponent((Component)rightPanel);
            this.topPanel.add(this.topSplitPane);
        } else {
            if (this.topSplitPane != null) {
                if (this.chatContactListPanel != null) {
                    this.topSplitPane.remove(this.chatContactListPanel);
                    this.chatContactListPanel = null;
                }
                this.messagePane.remove(this.topSplitPane);
                this.topSplitPane = null;
            }
            this.topPanel.add(this.conversationPanelContainer);
        }
        if (chatSession instanceof MetaContactChatSession) {
            if (this.subjectPanel != null) {
                this.remove((Component)((Object)this.subjectPanel));
                this.subjectPanel = null;
                this.revalidate();
                this.repaint();
            }
            this.writeMessagePanel.initPluginComponents();
            this.writeMessagePanel.setTransportSelectorBoxVisible(true);
            ActionMap amap = this.getActionMap();
            amap.put("ChangeProtocol", new ChangeTransportAction());
            InputMap imap = this.getInputMap(2);
            imap.put(KeyStroke.getKeyStroke(80, 128), "ChangeProtocol");
        } else if (chatSession instanceof ConferenceChatSession) {
            ConferenceChatSession confSession = (ConferenceChatSession)chatSession;
            this.writeMessagePanel.setTransportSelectorBoxVisible(false);
            confSession.addLocalUserRoleListener(this);
            confSession.addMemberRoleListener(this);
            ChatRoom room = ((ChatRoomWrapper)chatSession.getDescriptor()).getChatRoom();
            room.addMemberPropertyChangeListener((ChatRoomMemberPropertyChangeListener)this);
            this.setConferencesPanelVisible(room.getCachedConferenceDescriptionSize() > 0);
            this.subjectPanel = new ChatRoomSubjectPanel((ConferenceChatSession)chatSession);
            this.add((Component)((Object)this.subjectPanel), "North");
            this.revalidate();
            this.repaint();
        }
        if (this.chatContactListPanel != null) {
            Iterator<ChatContact<?>> chatParticipants = chatSession.getParticipants();
            while (chatParticipants.hasNext()) {
                this.chatContactListPanel.addContact(chatParticipants.next());
            }
        }
    }

    public void showChatConferenceDialog() {
        if (this.chatConferencesDialog == null) {
            this.chatConferencesDialog = new ChatConferenceCallDialog(this);
            this.chatConferencesDialog.initConferences();
        }
        this.chatConferencesDialog.setVisible(true);
        this.chatConferencesDialog.toFront();
        this.chatConferencesDialog.pack();
    }

    public ChatSession getChatSession() {
        return this.chatSession;
    }

    public void dispose() {
        this.writeMessagePanel.dispose();
        this.chatSession.dispose();
        this.conversationPanel.dispose();
        if (this.chatSession instanceof ConferenceChatSession) {
            if (this.chatConferencesDialog != null) {
                this.chatConferencesDialog.dispose();
            }
            ConferenceChatSession confSession = (ConferenceChatSession)this.chatSession;
            confSession.removeLocalUserRoleListener(this);
            confSession.removeMemberRoleListener(this);
            ((ChatRoomWrapper)this.chatSession.getDescriptor()).getChatRoom().removeMemberPropertyChangeListener((ChatRoomMemberPropertyChangeListener)this);
        }
        if (this.subjectPanel != null) {
            this.subjectPanel.dispose();
        }
        if (this.chatContactListPanel != null) {
            this.chatContactListPanel.dispose();
        }
    }

    public ChatContainer getChatContainer() {
        return this.chatContainer;
    }

    @Override
    public Window getConversationContainerWindow() {
        return this.chatContainer.getFrame();
    }

    @Override
    public void addTypingNotification(final String typingNotification) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ChatPanel.this.addTypingNotification(typingNotification);
                }
            });
            return;
        }
        this.typingNotificationLabel.setText(typingNotification);
        if (typingNotification != null && !typingNotification.equals(" ")) {
            this.typingNotificationLabel.setIcon(this.typingIcon);
        } else {
            this.typingNotificationLabel.setIcon(null);
        }
        this.revalidate();
        this.repaint();
    }

    public void addErrorSendingTypingNotification(final String typingNotification) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ChatPanel.this.addErrorSendingTypingNotification(typingNotification);
                }
            });
            return;
        }
        this.typingNotificationLabel.setText(typingNotification);
        if (typingNotification != null && !typingNotification.equals(" ")) {
            this.typingNotificationLabel.setIcon(this.typingIcon);
        } else {
            this.typingNotificationLabel.setIcon(null);
        }
        this.revalidate();
        this.repaint();
    }

    public void removeTypingNotification() {
        this.addTypingNotification(" ");
    }

    private void initTypingNotificationLabel(JPanel typingLabelParent) {
        this.typingNotificationLabel = new JLabel(" ", 0);
        this.typingNotificationLabel.setPreferredSize(new Dimension(500, 20));
        this.typingNotificationLabel.setForeground(Color.GRAY);
        this.typingNotificationLabel.setFont(this.typingNotificationLabel.getFont().deriveFont(11.0f));
        this.typingNotificationLabel.setVerticalTextPosition(3);
        this.typingNotificationLabel.setHorizontalTextPosition(2);
        this.typingNotificationLabel.setIconTextGap(0);
        typingLabelParent.add((Component)this.typingNotificationLabel, "South");
    }

    public ChatConversationPanel getChatConversationPanel() {
        return this.conversationPanel;
    }

    public ChatWritePanel getChatWritePanel() {
        return this.writeMessagePanel;
    }

    public String getRoleDescription(ChatRoomMemberRole role) {
        String roleDescription = null;
        switch (role) {
            case OWNER: {
                roleDescription = GuiActivator.getResources().getI18NString("service.gui.OWNER");
                break;
            }
            case ADMINISTRATOR: {
                roleDescription = GuiActivator.getResources().getI18NString("service.gui.ADMINISTRATOR");
                break;
            }
            case MODERATOR: {
                roleDescription = GuiActivator.getResources().getI18NString("service.gui.MODERATOR");
                break;
            }
            case MEMBER: {
                roleDescription = GuiActivator.getResources().getI18NString("service.gui.MEMBER");
                break;
            }
            case GUEST: {
                roleDescription = GuiActivator.getResources().getI18NString("service.gui.GUEST");
                break;
            }
            case SILENT_MEMBER: {
                roleDescription = GuiActivator.getResources().getI18NString("service.gui.SILENT_MEMBER");
                break;
            }
            case OUTCAST: {
                roleDescription = GuiActivator.getResources().getI18NString("service.gui.BANNED");
                break;
            }
        }
        return roleDescription;
    }

    public void memberRoleChanged(ChatRoomMemberRoleChangeEvent evt) {
        this.conversationPanel.appendMessageToEnd("<DIV identifier=\"message\" style=\"color:#707070;\">" + GuiActivator.getResources().getI18NString("service.gui.IS_NOW", new String[]{evt.getSourceMember().getName(), this.getRoleDescription(evt.getNewRole())}) + "</DIV>", "text/html");
    }

    public void localUserRoleChanged(ChatRoomLocalUserRoleChangeEvent evt) {
        this.conversationPanel.appendMessageToEnd("<DIV identifier=\"message\" style=\"color:#707070;\">" + GuiActivator.getResources().getI18NString("service.gui.ARE_NOW", new String[]{this.getRoleDescription(evt.getNewRole())}) + "</DIV>", "text/html");
    }

    public String getLastSentMessageUID() {
        return this.lastSentMessageUID;
    }

    @Override
    public void currentChatTransportChanged(ChatSession chatSession) {
        this.setChatIcon(new ImageIcon(Constants.getStatusIcon(this.chatSession.getCurrentChatTransport().getStatus())));
        this.writeMessagePanel.currentChatTransportChanged(chatSession);
    }

    @Override
    public void currentChatTransportUpdated(int eventID) {
        if (eventID == 1) {
            this.setChatIcon(new ImageIcon(Constants.getStatusIcon(this.chatSession.getCurrentChatTransport().getStatus())));
        }
        this.writeMessagePanel.currentChatTransportUpdated(eventID);
    }

    public void requestFocusInWriteArea() {
        this.getChatWritePanel().getEditorPane().requestFocus();
    }

    public boolean isWriteAreaEmpty() {
        JEditorPane editorPane = this.getChatWritePanel().getEditorPane();
        Document doc = editorPane.getDocument();
        try {
            String text = doc.getText(0, doc.getLength());
            if (text == null || text.equals("")) {
                return true;
            }
        }
        catch (BadLocationException e) {
            logger.error((Object)"Failed to obtain document text.", (Throwable)e);
        }
        return false;
    }

    public boolean isPrivateMessagingChat() {
        return this.isPrivateMessagingChat;
    }

    private void processHistory(Collection<Object> historyList, String escapedMessageID) {
        for (Object o : historyList) {
            FileRecord fileRecord;
            String messageType;
            ProtocolProviderService protocolProvider;
            MessageDeliveredEvent evt;
            String historyString = "";
            if (o instanceof MessageDeliveredEvent) {
                evt = (MessageDeliveredEvent)o;
                protocolProvider = evt.getDestinationContact().getProtocolProvider();
                messageType = this.isGreyHistoryStyleDisabled(protocolProvider) ? "OutgoingMessage" : "HistoryOutgoingMessage";
                historyString = this.processHistoryMessage(GuiActivator.getUIService().getMainFrame().getAccountAddress(protocolProvider), GuiActivator.getUIService().getMainFrame().getAccountDisplayName(protocolProvider), evt.getTimestamp(), messageType, evt.getSourceMessage().getContent(), evt.getSourceMessage().getContentType(), evt.getSourceMessage().getMessageUID());
            } else if (o instanceof MessageReceivedEvent) {
                evt = (MessageReceivedEvent)o;
                protocolProvider = evt.getSourceContact().getProtocolProvider();
                if (!evt.getSourceMessage().getMessageUID().equals(escapedMessageID)) {
                    messageType = this.isGreyHistoryStyleDisabled(protocolProvider) ? "IncomingMessage" : "HistoryIncomingMessage";
                    historyString = this.processHistoryMessage(evt.getSourceContact().getAddress(), evt.getSourceContact().getDisplayName(), evt.getTimestamp(), messageType, evt.getSourceMessage().getContent(), evt.getSourceMessage().getContentType(), evt.getSourceMessage().getMessageUID());
                }
            } else if (o instanceof ChatRoomMessageDeliveredEvent) {
                evt = (ChatRoomMessageDeliveredEvent)o;
                protocolProvider = evt.getSourceChatRoom().getParentProvider();
                historyString = this.processHistoryMessage(GuiActivator.getUIService().getMainFrame().getAccountAddress(protocolProvider), GuiActivator.getUIService().getMainFrame().getAccountDisplayName(protocolProvider), evt.getTimestamp(), "HistoryOutgoingMessage", evt.getMessage().getContent(), evt.getMessage().getContentType(), evt.getMessage().getMessageUID());
            } else if (o instanceof ChatRoomMessageReceivedEvent) {
                evt = (ChatRoomMessageReceivedEvent)o;
                if (!evt.getMessage().getMessageUID().equals(escapedMessageID)) {
                    historyString = this.processHistoryMessage(evt.getSourceChatRoomMember().getContactAddress(), evt.getSourceChatRoomMember().getName(), evt.getTimestamp(), "HistoryIncomingMessage", evt.getMessage().getContent(), evt.getMessage().getContentType(), evt.getMessage().getMessageUID());
                }
            } else if (o instanceof FileRecord && !(fileRecord = (FileRecord)o).getID().equals(escapedMessageID)) {
                FileHistoryConversationComponent component = new FileHistoryConversationComponent(fileRecord);
                this.conversationPanel.addComponent(component);
            }
            if (historyString == null) continue;
            this.conversationPanel.appendMessageToEnd(historyString, "text/html");
        }
        this.fireChatHistoryChange();
    }

    public void addMessage(String contactName, Date date, String messageType, String message, String contentType) {
        this.addMessage(contactName, null, date, messageType, message, contentType, null, null);
    }

    public void addMessage(String contactName, String displayName, Date date, String messageType, String message, String contentType, String messageUID, String correctedMessageUID) {
        ChatMessage chatMessage = new ChatMessage(contactName, displayName, date, messageType, null, message, contentType, messageUID, correctedMessageUID);
        this.addChatMessage(chatMessage);
        this.fireChatHistoryChange();
    }

    public void addMessage(String contactName, Date date, String messageType, String title, String message, String contentType) {
        ChatMessage chatMessage = new ChatMessage(contactName, date, messageType, title, message, contentType);
        this.addChatMessage(chatMessage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addChatMessage(final ChatMessage chatMessage) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ChatPanel.this.addChatMessage(chatMessage);
                }
            });
            return;
        }
        if (ConfigurationUtils.isHistoryShown() && !this.isHistoryLoaded) {
            Vector<Object> vector = this.incomingEventBuffer;
            synchronized (vector) {
                this.incomingEventBuffer.add(chatMessage);
            }
        } else {
            this.displayChatMessage(chatMessage);
        }
        this.lastHistoryMsgTimestamp = chatMessage.getDate();
        if (chatMessage.getMessageType().equals("OutgoingMessage")) {
            this.lastSentMessageUID = chatMessage.getMessageUID();
        }
    }

    public void addErrorMessage(String contactName, String message) {
        this.addMessage(contactName, new Date(), "ErrorMessage", GuiActivator.getResources().getI18NString("service.gui.MSG_DELIVERY_FAILURE"), message, "text");
    }

    public void addErrorMessage(String contactName, String title, String message) {
        this.addMessage(contactName, new Date(), "ErrorMessage", title, message, "text");
    }

    private void displayChatMessage(ChatMessage chatMessage) {
        if (chatMessage.getCorrectedMessageUID() != null && this.conversationPanel.getMessageContents(chatMessage.getCorrectedMessageUID()) != null) {
            this.applyMessageCorrection(chatMessage);
        } else {
            this.appendChatMessage(chatMessage);
        }
    }

    private void appendChatMessage(ChatMessage chatMessage) {
        String meCommandMsg;
        String keyword = null;
        if (this.chatSession instanceof ConferenceChatSession && "IncomingMessage".equals(chatMessage.getMessageType())) {
            keyword = ((ChatRoomWrapper)this.chatSession.getDescriptor()).getChatRoom().getUserNickname();
        }
        String processedMessage = this.conversationPanel.processMessage(chatMessage, keyword, this.chatSession.getCurrentChatTransport().getProtocolProvider(), this.chatSession.getCurrentChatTransport().getName());
        if (this.chatSession instanceof ConferenceChatSession && (meCommandMsg = this.conversationPanel.processMeCommand(chatMessage)).length() > 0) {
            processedMessage = meCommandMsg;
        }
        this.conversationPanel.appendMessageToEnd(processedMessage, "text/html");
    }

    private void applyMessageCorrection(ChatMessage message) {
        this.conversationPanel.correctMessage(message);
    }

    private String processHistoryMessage(String contactName, String contactDisplayName, Date date, String messageType, String message, String contentType, String messageId) {
        String tempMessage;
        ChatMessage chatMessage = new ChatMessage(contactName, contactDisplayName, date, messageType, null, message, contentType, messageId, null);
        String processedMessage = this.conversationPanel.processMessage(chatMessage, this.chatSession.getCurrentChatTransport().getProtocolProvider(), this.chatSession.getCurrentChatTransport().getName());
        if (this.chatSession instanceof ConferenceChatSession && (tempMessage = this.conversationPanel.processMeCommand(chatMessage)).length() > 0) {
            processedMessage = tempMessage;
        }
        return processedMessage;
    }

    public void refreshWriteArea() {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ChatPanel.this.refreshWriteArea();
                }
            });
            return;
        }
        this.writeMessagePanel.clearWriteArea();
    }

    public void addTextInWriteArea(String text) {
        JEditorPane editorPane = this.writeMessagePanel.getEditorPane();
        editorPane.setText(editorPane.getText() + text);
    }

    public String getTextFromWriteArea(String mimeType) {
        if (mimeType.equals("text/plain")) {
            return this.writeMessagePanel.getText();
        }
        return this.writeMessagePanel.getTextAsHtml();
    }

    public void cut() {
        this.writeMessagePanel.getEditorPane().cut();
    }

    public void copy() {
        JEditorPane textPane = this.conversationPanel.getChatTextPane();
        if (textPane.getSelectedText() == null) {
            textPane = this.writeMessagePanel.getEditorPane();
        }
        textPane.copy();
    }

    public void copyWriteArea() {
        JEditorPane editorPane = this.writeMessagePanel.getEditorPane();
        editorPane.copy();
    }

    public void paste() {
        JEditorPane editorPane = this.writeMessagePanel.getEditorPane();
        editorPane.paste();
        editorPane.requestFocus();
    }

    public void sendButtonDoClick() {
        if (!this.isWriteAreaEmpty()) {
            new Thread(){

                @Override
                public void run() {
                    ChatPanel.this.sendMessage();
                }
            }.start();
        }
        this.requestFocusInWriteArea();
    }

    public boolean isShown() {
        return this.isShown;
    }

    public void setShown(boolean isShown) {
        this.isShown = isShown;
    }

    public void setChatVisible(boolean isVisible) {
        ChatWindowManager chatWindowManager = GuiActivator.getUIService().getChatWindowManager();
        if (isVisible) {
            chatWindowManager.openChat(this, isVisible);
        } else {
            chatWindowManager.closeChat(this);
        }
    }

    @Override
    public void setConferencesPanelVisible(boolean isVisible) {
        this.conferencePanel.setVisible(isVisible);
    }

    public boolean isChatFocused() {
        ChatPanel currentChatPanel = this.chatContainer.getCurrentChat();
        return currentChatPanel != null && currentChatPanel.equals(this) && this.chatContainer.getFrame().isActive();
    }

    public void addChatEditorKeyListener(KeyListener l) {
        this.getChatWritePanel().getEditorPane().addKeyListener(l);
    }

    public void removeChatEditorKeyListener(KeyListener l) {
        this.getChatWritePanel().getEditorPane().removeKeyListener(l);
    }

    public String getMessage() {
        Document writeEditorDoc = this.writeMessagePanel.getEditorPane().getDocument();
        try {
            return writeEditorDoc.getText(0, writeEditorDoc.getLength());
        }
        catch (BadLocationException e) {
            return this.writeMessagePanel.getEditorPane().getText();
        }
    }

    public void setMessage(String message) {
        this.writeMessagePanel.getEditorPane().setText(message);
    }

    private boolean isGreyHistoryStyleDisabled(ProtocolProviderService protocolProvider) {
        boolean isProtocolHidden = protocolProvider.getAccountID().isHidden();
        boolean isGreyHistoryDisabled = false;
        String greyHistoryProperty = GuiActivator.getResources().getSettingsString("impl.gui.GREY_HISTORY_ENABLED");
        if (greyHistoryProperty != null) {
            isGreyHistoryDisabled = Boolean.parseBoolean(greyHistoryProperty);
        }
        return isProtocolHidden && isGreyHistoryDisabled;
    }

    public void sendFile(final File file, final SendFileConversationComponent fileComponent) {
        final ChatTransport sendFileTransport = this.findFileTransferChatTransport();
        this.setSelectedChatTransport(sendFileTransport, true);
        if (file.length() > sendFileTransport.getMaximumFileLength()) {
            this.addMessage(this.chatSession.getCurrentChatTransport().getName(), new Date(), "ErrorMessage", GuiActivator.getResources().getI18NString("service.gui.FILE_TOO_BIG", new String[]{sendFileTransport.getMaximumFileLength() / 1024L / 1024L + " MB"}), "", "text");
            fileComponent.setFailed();
            return;
        }
        SwingWorker worker = new SwingWorker(){

            public Object construct() throws Exception {
                FileTransfer ft = ChatPanel.this.writeMessagePanel.isSmsSelected() ? sendFileTransport.sendMultimediaFile(file) : sendFileTransport.sendFile(file);
                FileTransfer fileTransfer = ft;
                ChatPanel.this.addActiveFileTransfer(fileTransfer.getID(), fileTransfer);
                fileTransfer.addStatusListener((FileTransferStatusListener)ChatPanel.this);
                fileComponent.setProtocolFileTransfer(fileTransfer);
                return "";
            }

            public void catchException(Throwable ex) {
                logger.error((Object)"Failed to send file.", ex);
                if (ex instanceof IllegalStateException) {
                    ChatPanel.this.addErrorMessage(ChatPanel.this.chatSession.getCurrentChatTransport().getName(), GuiActivator.getResources().getI18NString("service.gui.MSG_SEND_CONNECTION_PROBLEM"));
                } else {
                    ChatPanel.this.addErrorMessage(ChatPanel.this.chatSession.getCurrentChatTransport().getName(), GuiActivator.getResources().getI18NString("service.gui.MSG_DELIVERY_ERROR", new String[]{ex.getMessage()}));
                }
            }
        };
        worker.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendFile(final File file) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ChatPanel.this.sendFile(file);
                }
            });
            return;
        }
        ChatTransport fileTransferTransport = this.findFileTransferChatTransport();
        if (fileTransferTransport == null) {
            logger.error((Object)"Failed to send file.");
            this.addErrorMessage(this.chatSession.getChatName(), GuiActivator.getResources().getI18NString("service.gui.FILE_SEND_FAILED", new String[]{file.getName()}), GuiActivator.getResources().getI18NString("service.gui.FILE_TRANSFER_NOT_SUPPORTED"));
            return;
        }
        SendFileConversationComponent fileComponent = new SendFileConversationComponent(this, fileTransferTransport.getDisplayName(), file);
        if (ConfigurationUtils.isHistoryShown() && !this.isHistoryLoaded) {
            Vector<Object> vector = this.incomingEventBuffer;
            synchronized (vector) {
                this.incomingEventBuffer.add(fileComponent);
            }
        } else {
            this.getChatConversationPanel().addComponent(fileComponent);
        }
        this.sendFile(file, fileComponent);
    }

    protected void sendMessage() {
        if (this.writeMessagePanel.isSmsSelected()) {
            this.sendSmsMessage();
        } else {
            this.sendInstantMessage();
        }
    }

    public void sendSmsMessage() {
        String messageText = this.getTextFromWriteArea("text/plain");
        ChatTransport smsChatTransport = this.chatSession.getCurrentChatTransport();
        if (!smsChatTransport.allowsSmsMessage()) {
            Iterator<ChatTransport> chatTransports = this.chatSession.getChatTransports();
            while (chatTransports.hasNext()) {
                ChatTransport transport = chatTransports.next();
                if (!transport.allowsSmsMessage()) continue;
                smsChatTransport = transport;
                break;
            }
        }
        if (!smsChatTransport.allowsSmsMessage()) {
            logger.error((Object)"Failed to send SMS.");
            this.refreshWriteArea();
            this.addMessage(smsChatTransport.getName(), new Date(), "OutgoingMessage", messageText, "plain/text");
            this.addErrorMessage(smsChatTransport.getName(), GuiActivator.getResources().getI18NString("service.gui.SEND_SMS_NOT_SUPPORTED"));
            return;
        }
        SendSmsDialog smsDialog = new SendSmsDialog(this, smsChatTransport, messageText);
        if (smsChatTransport.askForSMSNumber()) {
            Object desc = smsChatTransport.getParentChatSession().getDescriptor();
            if (desc instanceof MetaContact) {
                UIPhoneUtil contactPhoneUtil = UIPhoneUtil.getPhoneUtil((MetaContact)((MetaContact)desc));
                boolean useAllNumbers = GuiActivator.getConfigurationService().getBoolean(USE_ADDITIONAL_NUMBERS_PROP, false);
                List uiContactDetailList = useAllNumbers ? contactPhoneUtil.getAdditionalNumbers() : contactPhoneUtil.getAdditionalMobileNumbers();
                if (uiContactDetailList.size() != 0) {
                    SMSManager.sendSMS((JComponent)((Object)this), uiContactDetailList, messageText, this);
                    return;
                }
            }
            smsDialog.setPreferredSize(new Dimension(400, 200));
            smsDialog.setVisible(true);
        } else {
            smsDialog.sendSmsMessage(null, messageText);
            smsDialog.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendInstantMessage() {
        String mimeType;
        String messageText;
        String plainText;
        String htmlText;
        ChatWritePanel chatWritePanel = this.writeMessagePanel;
        synchronized (chatWritePanel) {
            if (this.isWriteAreaEmpty()) {
                return;
            }
            htmlText = this.getTextFromWriteArea("text/html").trim();
            plainText = this.getTextFromWriteArea("text/plain").trim();
            this.refreshWriteArea();
        }
        if (this.chatSession.getCurrentChatTransport().isContentTypeSupported("text/html") && (htmlText.indexOf("<b") > -1 || htmlText.indexOf("<i") > -1 || htmlText.indexOf("<u") > -1 || htmlText.indexOf("<font") > -1)) {
            messageText = htmlText;
            mimeType = "text/html";
        } else {
            messageText = plainText;
            mimeType = "text/plain";
        }
        try {
            if (this.isMessageCorrectionActive() && this.chatSession.getCurrentChatTransport().allowsMessageCorrections()) {
                this.chatSession.getCurrentChatTransport().correctInstantMessage(messageText, mimeType, this.correctedMessageUID);
            } else {
                this.chatSession.getCurrentChatTransport().sendInstantMessage(messageText, mimeType);
            }
            this.stopMessageCorrection();
        }
        catch (IllegalStateException ex) {
            logger.error((Object)"Failed to send message.", (Throwable)ex);
            this.addMessage(this.chatSession.getCurrentChatTransport().getName(), new Date(), "OutgoingMessage", messageText, mimeType);
            String protocolError = "";
            if (ex.getMessage() != null) {
                protocolError = " " + GuiActivator.getResources().getI18NString("service.gui.ERROR_WAS", new String[]{ex.getMessage()});
            }
            this.addErrorMessage(this.chatSession.getCurrentChatTransport().getName(), GuiActivator.getResources().getI18NString("service.gui.MSG_SEND_CONNECTION_PROBLEM") + protocolError);
        }
        catch (Exception ex) {
            logger.error((Object)"Failed to send message.", (Throwable)ex);
            this.refreshWriteArea();
            this.addMessage(this.chatSession.getCurrentChatTransport().getName(), new Date(), "OutgoingMessage", messageText, mimeType);
            String protocolError = "";
            if (ex.getMessage() != null) {
                protocolError = " " + GuiActivator.getResources().getI18NString("service.gui.ERROR_WAS", new String[]{ex.getMessage()});
            }
            this.addErrorMessage(this.chatSession.getCurrentChatTransport().getName(), GuiActivator.getResources().getI18NString("service.gui.MSG_DELIVERY_ERROR", new String[]{protocolError}));
        }
        if (this.chatSession.getCurrentChatTransport().allowsTypingNotifications()) {
            this.getChatWritePanel().stopTypingTimer();
        }
    }

    public void setPrivateMessagingChat(boolean isPrivateMessagingChat) {
        this.isPrivateMessagingChat = isPrivateMessagingChat;
    }

    public void startLastMessageCorrection() {
        this.startMessageCorrection(this.lastSentMessageUID);
    }

    public void startMessageCorrection(String correctedMessageUID) {
        if (!this.showMessageInWriteArea(correctedMessageUID)) {
            return;
        }
        if (this.chatSession.getCurrentChatTransport().allowsMessageCorrections()) {
            this.correctedMessageUID = correctedMessageUID;
            Color bgColor = new Color(GuiActivator.getResources().getColor("service.gui.CHAT_EDIT_MESSAGE_BACKGROUND"));
            this.writeMessagePanel.setEditorPaneBackground(bgColor);
        }
    }

    public boolean showLastMessageInWriteArea() {
        return this.showMessageInWriteArea(this.lastSentMessageUID);
    }

    public boolean showMessageInWriteArea(String messageUID) {
        String messageContents = this.conversationPanel.getMessageContents(messageUID);
        if (messageContents == null) {
            return false;
        }
        this.refreshWriteArea();
        this.setMessage(messageContents);
        return true;
    }

    public void stopMessageCorrection() {
        this.correctedMessageUID = null;
        this.writeMessagePanel.setEditorPaneBackground(Color.WHITE);
        this.refreshWriteArea();
    }

    public boolean isMessageCorrectionActive() {
        return this.correctedMessageUID != null;
    }

    public Date getFirstHistoryMsgTimestamp() {
        return this.firstHistoryMsgTimestamp;
    }

    public Date getLastHistoryMsgTimestamp() {
        return this.lastHistoryMsgTimestamp;
    }

    public void loadHistory(final String escapedMessageID) {
        if (!ConfigurationUtils.isHistoryShown()) {
            this.isHistoryLoaded = true;
            return;
        }
        SwingWorker historyWorker = new SwingWorker(){
            private Collection<Object> historyList;

            public Object construct() throws Exception {
                ChatPanel.this.loadHistoryPeriod();
                this.historyList = ChatPanel.this.chatSession.getHistory(ConfigurationUtils.getChatHistorySize());
                return this.historyList;
            }

            public void finished() {
                if (this.historyList != null && this.historyList.size() > 0) {
                    ChatPanel.this.processHistory(this.historyList, escapedMessageID);
                }
                ChatPanel.this.isHistoryLoaded = true;
                ChatPanel.this.addIncomingEvents();
                ChatPanel.this.chatContainer.updateHistoryButtonState(ChatPanel.this);
            }
        };
        historyWorker.start();
    }

    public void loadHistory() {
        this.loadHistory(null);
    }

    private void loadHistoryPeriod() {
        this.firstHistoryMsgTimestamp = this.chatSession.getHistoryStartDate();
        this.lastHistoryMsgTimestamp = this.chatSession.getHistoryEndDate();
    }

    public void setSmsSelected(boolean isSmsSelected) {
        this.writeMessagePanel.setSmsSelected(isSmsSelected);
    }

    @Override
    public void setContactName(ChatContact<?> chatContact, String name) {
        if (this.chatContactListPanel != null) {
            this.chatContactListPanel.renameContact(chatContact);
        }
        ChatContainer chatContainer = this.getChatContainer();
        chatContainer.setChatTitle(this, name);
        if (chatContainer.getCurrentChat() == this) {
            chatContainer.setTitle(name);
        }
    }

    @Override
    public void addChatTransport(ChatTransport chatTransport) {
        this.writeMessagePanel.addChatTransport(chatTransport);
    }

    @Override
    public void removeChatTransport(ChatTransport chatTransport) {
        this.writeMessagePanel.removeChatTransport(chatTransport);
    }

    @Override
    public void setSelectedChatTransport(ChatTransport chatTransport, boolean isMessageOrFileTransferReceived) {
        this.writeMessagePanel.setSelectedChatTransport(chatTransport, isMessageOrFileTransferReceived);
    }

    @Override
    public void updateChatTransportStatus(final ChatTransport chatTransport) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ChatPanel.this.updateChatTransportStatus(chatTransport);
                }
            });
            return;
        }
        this.writeMessagePanel.updateChatTransportStatus(chatTransport);
        if (!chatTransport.equals(this.chatSession.getCurrentChatTransport())) {
            return;
        }
        if (ConfigurationUtils.isShowStatusChangedInChat()) {
            this.addMessage(chatTransport.getName(), new Date(), "StatusMessage", GuiActivator.getResources().getI18NString("service.gui.STATUS_CHANGED_CHAT_MESSAGE", new String[]{chatTransport.getStatus().getStatusName()}), "text/plain");
        }
    }

    @Override
    public void setChatIcon(Icon icon) {
        if (ConfigurationUtils.isMultiChatWindowEnabled() && this.getChatContainer().getChatCount() > 0) {
            this.getChatContainer().setChatIcon(this, icon);
        }
    }

    public void loadPreviousPageFromHistory() {
        MetaHistoryService chatHistory = GuiActivator.getMetaHistoryService();
        if (chatHistory == null) {
            return;
        }
        SwingWorker worker = new SwingWorker(){

            public Object construct() throws Exception {
                ChatConversationPanel conversationPanel = ChatPanel.this.getChatConversationPanel();
                Date firstMsgDate = conversationPanel.getPageFirstMsgTimestamp();
                Collection<Object> c = null;
                if (firstMsgDate != null) {
                    c = ChatPanel.this.chatSession.getHistoryBeforeDate(firstMsgDate, 20);
                }
                if (c != null && c.size() > 0) {
                    SwingUtilities.invokeLater(new HistoryMessagesLoader(c));
                }
                return "";
            }

            public void finished() {
                ChatPanel.this.getChatContainer().updateHistoryButtonState(ChatPanel.this);
            }
        };
        worker.start();
    }

    public void loadNextPageFromHistory() {
        MetaHistoryService chatHistory = GuiActivator.getMetaHistoryService();
        if (chatHistory == null) {
            return;
        }
        SwingWorker worker = new SwingWorker(){

            public Object construct() throws Exception {
                Date lastMsgDate = ChatPanel.this.getChatConversationPanel().getPageLastMsgTimestamp();
                Collection<Object> c = null;
                if (lastMsgDate != null) {
                    c = ChatPanel.this.chatSession.getHistoryAfterDate(lastMsgDate, 20);
                }
                if (c != null && c.size() > 0) {
                    SwingUtilities.invokeLater(new HistoryMessagesLoader(c));
                }
                return "";
            }

            public void finished() {
                ChatPanel.this.getChatContainer().updateHistoryButtonState(ChatPanel.this);
            }
        };
        worker.start();
    }

    @Override
    public void addChatContact(ChatContact<?> chatContact) {
        if (this.chatContactListPanel != null) {
            this.chatContactListPanel.addContact(chatContact);
        }
    }

    @Override
    public void removeChatContact(ChatContact<?> chatContact) {
        if (this.chatContactListPanel != null) {
            this.chatContactListPanel.removeContact(chatContact);
        }
    }

    @Override
    public void addChatConferenceCall(ConferenceDescription conferenceDescription) {
        if (this.chatConferencesDialog != null) {
            this.chatConferencesDialog.addConference(conferenceDescription);
        }
    }

    @Override
    public void removeChatConferenceCall(ConferenceDescription conferenceDescription) {
        if (this.chatConferencesDialog != null) {
            this.chatConferencesDialog.removeConference(conferenceDescription);
        }
    }

    @Override
    public void removeAllChatContacts() {
        if (this.chatContactListPanel != null) {
            this.chatContactListPanel.removeAllChatContacts();
        }
    }

    @Override
    public void updateChatContactStatus(final ChatContact<?> chatContact, final String statusMessage) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ChatPanel.this.updateChatContactStatus(chatContact, statusMessage);
                }
            });
            return;
        }
        this.addMessage(chatContact.getName(), new Date(), "StatusMessage", statusMessage, "text/plain");
    }

    @Override
    public void setChatSubject(final String subject) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ChatPanel.this.setChatSubject(subject);
                }
            });
            return;
        }
        if (this.subjectPanel != null) {
            String oldSubject = this.subjectPanel.getSubject();
            if (subject == null || subject.length() == 0 ? oldSubject == null || oldSubject.length() == 0 : subject.equals(oldSubject)) {
                return;
            }
            this.subjectPanel.setSubject(subject);
            this.addMessage(this.chatSession.getChatName(), new Date(), "StatusMessage", GuiActivator.getResources().getI18NString("service.gui.CHAT_ROOM_SUBJECT_CHANGED", new String[]{this.chatSession.getChatName(), subject}), "text/plain");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addIncomingFileTransferRequest(final OperationSetFileTransfer fileTransferOpSet, final IncomingFileTransferRequest request, final Date date) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ChatPanel.this.addIncomingFileTransferRequest(fileTransferOpSet, request, date);
                }
            });
            return;
        }
        this.addActiveFileTransfer(request.getID(), request);
        ReceiveFileConversationComponent component = new ReceiveFileConversationComponent(this, fileTransferOpSet, request, date);
        if (ConfigurationUtils.isHistoryShown() && !this.isHistoryLoaded) {
            Vector<Object> vector = this.incomingEventBuffer;
            synchronized (vector) {
                this.incomingEventBuffer.add(component);
            }
        } else {
            this.getChatConversationPanel().addComponent(component);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChatFocusListener(ChatFocusListener listener) {
        List<ChatFocusListener> list = this.focusListeners;
        synchronized (list) {
            if (!this.focusListeners.contains(listener)) {
                this.focusListeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChatFocusListener(ChatFocusListener listener) {
        List<ChatFocusListener> list = this.focusListeners;
        synchronized (list) {
            this.focusListeners.remove(listener);
        }
    }

    public ChatTransport findFileTransferChatTransport() {
        if (this.chatSession instanceof ConferenceChatSession) {
            return null;
        }
        ChatTransport currentChatTransport = this.chatSession.getCurrentChatTransport();
        if (currentChatTransport.getProtocolProvider().getOperationSet(OperationSetFileTransfer.class) != null) {
            return currentChatTransport;
        }
        Iterator<ChatTransport> chatTransportsIter = this.chatSession.getChatTransports();
        while (chatTransportsIter.hasNext()) {
            ChatTransport chatTransport = chatTransportsIter.next();
            OperationSet fileTransferOpSet = chatTransport.getProtocolProvider().getOperationSet(OperationSetFileTransfer.class);
            if (fileTransferOpSet == null) continue;
            return chatTransport;
        }
        return null;
    }

    public ChatTransport findInviteChatTransport() {
        ChatTransport currentChatTransport = this.chatSession.getCurrentChatTransport();
        ProtocolProviderService protocolProvider = currentChatTransport.getProtocolProvider();
        if (protocolProvider.getOperationSet(OperationSetMultiUserChat.class) != null || protocolProvider.getOperationSet(OperationSetAdHocMultiUserChat.class) != null) {
            return this.chatSession.getCurrentChatTransport();
        }
        Iterator<ChatTransport> chatTransportsIter = this.chatSession.getChatTransports();
        while (chatTransportsIter.hasNext()) {
            ChatTransport chatTransport = chatTransportsIter.next();
            OperationSet groupChatOpSet = chatTransport.getProtocolProvider().getOperationSet(OperationSetMultiUserChat.class);
            if (groupChatOpSet == null) continue;
            return chatTransport;
        }
        return null;
    }

    public void inviteContacts(ChatTransport inviteChatTransport, Collection<String> chatContacts, String reason) {
        ChatSession conferenceChatSession = null;
        if (this.chatSession instanceof MetaContactChatSession) {
            chatContacts.add(inviteChatTransport.getName());
            ConferenceChatManager conferenceChatManager = GuiActivator.getUIService().getConferenceChatManager();
            if (inviteChatTransport.getProtocolProvider().getOperationSet(OperationSetMultiUserChat.class) != null) {
                ChatRoomWrapper chatRoomWrapper = GuiActivator.getMUCService().createPrivateChatRoom(inviteChatTransport.getProtocolProvider(), chatContacts, reason, false);
                conferenceChatSession = new ConferenceChatSession(this, chatRoomWrapper);
            } else if (inviteChatTransport.getProtocolProvider().getOperationSet(OperationSetAdHocMultiUserChat.class) != null) {
                AdHocChatRoomWrapper chatRoomWrapper = conferenceChatManager.createAdHocChatRoom(inviteChatTransport.getProtocolProvider(), chatContacts, reason);
                conferenceChatSession = new AdHocConferenceChatSession(this, chatRoomWrapper);
            }
            if (conferenceChatSession != null) {
                this.setChatSession(conferenceChatSession);
            }
        } else {
            conferenceChatSession = this.chatSession;
            for (String contactAddress : chatContacts) {
                conferenceChatSession.getCurrentChatTransport().inviteChatContact(contactAddress, reason);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireChatFocusEvent(int eventID) {
        ArrayList<ChatFocusListener> listeners;
        ChatFocusEvent evt = new ChatFocusEvent((Object)this, eventID);
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Will dispatch the following chat event: " + evt));
        }
        List<ChatFocusListener> list = this.focusListeners;
        synchronized (list) {
            listeners = new ArrayList<ChatFocusListener>(this.focusListeners);
        }
        block7: for (ChatFocusListener listener : listeners) {
            switch (evt.getEventID()) {
                case 1: {
                    listener.chatFocusGained(evt);
                    continue block7;
                }
                case 2: {
                    listener.chatFocusLost(evt);
                    continue block7;
                }
            }
            logger.error((Object)("Unknown event type " + evt.getEventID()));
        }
    }

    public void statusChanged(FileTransferStatusChangeEvent event) {
        FileTransfer fileTransfer = event.getFileTransfer();
        int newStatus = event.getNewStatus();
        if (newStatus == 0 || newStatus == 1 || newStatus == 2 || newStatus == 3) {
            this.removeActiveFileTransfer(fileTransfer.getID());
            fileTransfer.removeStatusListener((FileTransferStatusListener)this);
        }
    }

    public boolean containsActiveFileTransfers() {
        return !this.activeFileTransfers.isEmpty();
    }

    public void cancelActiveFileTransfers() {
        Enumeration<String> activeKeys = this.activeFileTransfers.keys();
        while (activeKeys.hasMoreElements()) {
            try {
                String key = activeKeys.nextElement();
                Object descriptor = this.activeFileTransfers.get(key);
                if (descriptor instanceof IncomingFileTransferRequest) {
                    ((IncomingFileTransferRequest)descriptor).rejectFile();
                    continue;
                }
                if (!(descriptor instanceof FileTransfer)) continue;
                ((FileTransfer)descriptor).cancel();
            }
            catch (Throwable t) {
                logger.error((Object)"Cannot cancel file transfer.", t);
            }
        }
    }

    public void setDividerLocation(int location) {
        int dividerLocation = this.messagePane.getHeight() - location;
        this.messagePane.setDividerLocation(dividerLocation);
        this.messagePane.revalidate();
        this.messagePane.repaint();
    }

    public int getDividerLocation() {
        return this.messagePane.getHeight() - this.messagePane.getDividerLocation();
    }

    public int getDividerSize() {
        return this.messagePane.getDividerSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addIncomingEvents() {
        Vector<Object> vector = this.incomingEventBuffer;
        synchronized (vector) {
            for (Object incomingEvent : this.incomingEventBuffer) {
                if (incomingEvent instanceof ChatMessage) {
                    this.displayChatMessage((ChatMessage)incomingEvent);
                    continue;
                }
                if (!(incomingEvent instanceof ChatConversationComponent)) continue;
                this.getChatConversationPanel().addComponent((ChatConversationComponent)incomingEvent);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addActiveFileTransfer(String id, Object descriptor) {
        Hashtable<String, Object> hashtable = this.activeFileTransfers;
        synchronized (hashtable) {
            this.activeFileTransfers.put(id, descriptor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeActiveFileTransfer(String id) {
        Hashtable<String, Object> hashtable = this.activeFileTransfers;
        synchronized (hashtable) {
            this.activeFileTransfers.remove(id);
        }
    }

    public void addChatEditorMenuListener(ChatMenuListener l) {
        this.getChatWritePanel().addChatEditorMenuListener(l);
    }

    public void addChatEditorCaretListener(CaretListener l) {
        this.getChatWritePanel().getEditorPane().addCaretListener(l);
    }

    public void addChatEditorDocumentListener(DocumentListener l) {
        this.getChatWritePanel().getEditorPane().getDocument().addDocumentListener(l);
    }

    public void removeChatEditorCaretListener(CaretListener l) {
        this.getChatWritePanel().getEditorPane().removeCaretListener(l);
    }

    public void removeChatEditorMenuListener(ChatMenuListener l) {
        this.getChatWritePanel().removeChatEditorMenuListener(l);
    }

    public void removeChatEditorDocumentListener(DocumentListener l) {
        this.getChatWritePanel().getEditorPane().getDocument().removeDocumentListener(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChatHistoryListener(ChatHistoryListener l) {
        List<ChatHistoryListener> list = this.historyListeners;
        synchronized (list) {
            this.historyListeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChatHistoryListener(ChatHistoryListener l) {
        List<ChatHistoryListener> list = this.historyListeners;
        synchronized (list) {
            this.historyListeners.remove(l);
        }
    }

    private void fireChatHistoryChange() {
        Iterator<ChatHistoryListener> listeners = this.historyListeners.iterator();
        while (listeners.hasNext()) {
            listeners.next().chatHistoryChanged(this);
        }
    }

    public Highlighter getHighlighter() {
        return this.getChatWritePanel().getEditorPane().getHighlighter();
    }

    public int getCaretPosition() {
        return this.getChatWritePanel().getEditorPane().getCaretPosition();
    }

    public void promptRepaint() {
        this.getChatWritePanel().getEditorPane().repaint();
    }

    public void showFontChooserDialog() {
        JEditorPane editorPane = this.writeMessagePanel.getEditorPane();
        FontChooser fontChooser = new FontChooser();
        int result = fontChooser.showDialog((Component)((Object)this));
        if (result != 0) {
            String fontFamily = fontChooser.getFontFamily();
            int fontSize = fontChooser.getFontSize();
            boolean isBold = fontChooser.isBoldStyleSelected();
            boolean isItalic = fontChooser.isItalicStyleSelected();
            boolean isUnderline = fontChooser.isUnderlineStyleSelected();
            Color fontColor = fontChooser.getFontColor();
            this.writeMessagePanel.setFontFamilyAndSize(fontFamily, fontSize);
            this.writeMessagePanel.setBoldStyleEnable(isBold);
            this.writeMessagePanel.setItalicStyleEnable(isItalic);
            this.writeMessagePanel.setUnderlineStyleEnable(isUnderline);
            this.writeMessagePanel.setFontColor(fontColor);
            this.writeMessagePanel.saveDefaultFontConfiguration(fontFamily, fontSize, isBold, isItalic, isUnderline, fontColor);
        }
        editorPane.requestFocus();
    }

    public void loadSkin() {
        this.getChatConversationPanel().clear();
        this.loadHistory();
        this.getChatConversationPanel().setDefaultContent();
    }

    public void chatRoomPropertyChanged(ChatRoomMemberPropertyChangeEvent event) {
        if ("MemberNickname".equals(event.getPropertyName())) {
            String message = GuiActivator.getResources().getI18NString("service.gui.CHAT_NICKNAME_CHANGE", new String[]{(String)event.getOldValue(), (String)event.getNewValue()});
            this.conversationPanel.appendMessageToEnd("<DIV identifier=\"message\" style=\"color:#707070;\">" + StringEscapeUtils.escapeHtml4((String)message) + "</DIV>", "text/html");
        }
    }

    public void addChatLinkClickedListener(ChatLinkClickedListener listener) {
        this.conversationPanel.addChatLinkClickedListener(listener);
    }

    public void removeChatLinkClickedListener(ChatLinkClickedListener listener) {
        this.conversationPanel.removeChatLinkClickedListener(listener);
    }

    @Override
    public void chatConferenceDescriptionSent(ConferenceDescription conferenceDescription) {
        boolean available = conferenceDescription.isAvailable();
        this.chatConferencesDialog.setCreatePanelEnabled(!available);
        this.chatConferencesDialog.setEndConferenceButtonEnabled(available);
    }

    private class DividerLocationListener
    implements PropertyChangeListener {
        private DividerLocationListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("dividerLocation")) {
                int dividerLocation = (Integer)evt.getNewValue();
                int writeAreaSize = ChatPanel.this.messagePane.getHeight() - dividerLocation - ChatPanel.this.messagePane.getDividerSize();
                ConfigurationUtils.setChatWriteAreaSize((int)writeAreaSize);
            }
        }
    }

    private class HistoryMessagesLoader
    implements Runnable {
        private final Collection<Object> chatHistory;

        public HistoryMessagesLoader(Collection<Object> history) {
            this.chatHistory = history;
        }

        @Override
        public void run() {
            ChatConversationPanel chatConversationPanel = ChatPanel.this.getChatConversationPanel();
            chatConversationPanel.clear();
            ChatPanel.this.processHistory(this.chatHistory, "");
            chatConversationPanel.setDefaultContent();
        }
    }

    private class ChangeTransportAction
    extends AbstractAction {
        private ChangeTransportAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ChatPanel.this.writeMessagePanel.openChatTransportSelectorBox();
        }
    }

    private class TabSelectionComponentListener
    extends ComponentAdapter {
        private TabSelectionComponentListener() {
        }

        @Override
        public void componentShown(ComponentEvent evt) {
            Component component = evt.getComponent();
            Container parent = component.getParent();
            if (!(parent instanceof JTabbedPane)) {
                return;
            }
            JTabbedPane tabbedPane = (JTabbedPane)parent;
            if (tabbedPane.getSelectedComponent() != component) {
                return;
            }
            ChatPanel.this.chatContainer.setCurrentChat(ChatPanel.this);
        }
    }
}

