/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.gui.main.call;

import java.awt.Component;
import java.awt.Container;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Iterator;
import java.util.Observable;
import net.java.sip.communicator.service.protocol.Call;
import net.java.sip.communicator.service.protocol.CallConference;
import net.java.sip.communicator.service.protocol.CallPeer;
import net.java.sip.communicator.service.protocol.ConferenceMember;
import net.java.sip.communicator.service.protocol.OperationSetVideoTelephony;
import net.java.sip.communicator.service.protocol.event.CallChangeEvent;
import net.java.sip.communicator.service.protocol.event.CallChangeListener;
import net.java.sip.communicator.service.protocol.event.CallPeerConferenceAdapter;
import net.java.sip.communicator.service.protocol.event.CallPeerConferenceEvent;
import net.java.sip.communicator.service.protocol.event.CallPeerConferenceListener;
import net.java.sip.communicator.service.protocol.event.CallPeerEvent;
import org.jitsi.util.event.VideoEvent;
import org.jitsi.util.event.VideoListener;

public class UIVideoHandler2
extends Observable {
    public static final String LOCAL_VIDEO_VISIBLE_PROPERTY_NAME = "localVideoVisible";
    private final CallConference callConference;
    private final CallConferenceListener callConferenceListener;
    private boolean localVideoVisible = true;

    public UIVideoHandler2(CallConference callConference) {
        this.callConference = callConference;
        this.callConferenceListener = new CallConferenceListener();
    }

    protected void callConferenceCallsPropertyChange(PropertyChangeEvent ev) {
        this.notifyObservers(ev);
    }

    protected void conferenceMemberVideoPropertyChange(PropertyChangeEvent ev) {
        this.notifyObservers(ev);
    }

    void dispose() {
        this.callConferenceListener.dispose();
    }

    public static boolean isAncestor(Container container, Component component) {
        Container parent;
        while ((parent = component.getParent()) != null) {
            if (parent.equals(container)) {
                return true;
            }
            component = parent;
        }
        return false;
    }

    public boolean isLocalVideoVisible() {
        return this.localVideoVisible;
    }

    protected void localVideoStreamingPropertyChange(PropertyChangeEvent ev) {
        this.notifyObservers(ev);
    }

    @Override
    public void notifyObservers(Object arg) {
        this.setChanged();
        super.notifyObservers(arg);
    }

    protected void onCallPeerConferenceEvent(CallPeerConferenceEvent ev) {
        this.notifyObservers(ev);
    }

    protected void onCallPeerEvent(CallPeerEvent ev) {
        this.notifyObservers(ev);
    }

    protected void onVideoEvent(VideoEvent ev) {
        this.notifyObservers(ev);
    }

    public void setLocalVideoVisible(boolean localVideoVisible) {
        if (this.localVideoVisible != localVideoVisible) {
            boolean oldValue = this.localVideoVisible;
            this.localVideoVisible = localVideoVisible;
            this.notifyObservers(new PropertyChangeEvent(this, LOCAL_VIDEO_VISIBLE_PROPERTY_NAME, oldValue, this.localVideoVisible));
        }
    }

    private class CallConferenceListener
    extends CallPeerConferenceAdapter
    implements CallChangeListener,
    PropertyChangeListener,
    VideoListener {
        CallConferenceListener() {
            UIVideoHandler2.this.callConference.addCallChangeListener((CallChangeListener)this);
            UIVideoHandler2.this.callConference.addCallPeerConferenceListener((CallPeerConferenceListener)this);
            UIVideoHandler2.this.callConference.addPropertyChangeListener((PropertyChangeListener)this);
            for (Call call : UIVideoHandler2.this.callConference.getCalls()) {
                this.addListeners(call);
            }
        }

        private void addListeners(Call call) {
            OperationSetVideoTelephony videoTelephony = (OperationSetVideoTelephony)call.getProtocolProvider().getOperationSet(OperationSetVideoTelephony.class);
            if (videoTelephony != null) {
                videoTelephony.addPropertyChangeListener(call, (PropertyChangeListener)this);
            }
            Iterator callPeerIter = call.getCallPeers();
            while (callPeerIter.hasNext()) {
                this.addListeners((CallPeer)callPeerIter.next());
            }
        }

        private void addListeners(CallPeer callPeer) {
            OperationSetVideoTelephony videoTelephony = (OperationSetVideoTelephony)callPeer.getProtocolProvider().getOperationSet(OperationSetVideoTelephony.class);
            if (videoTelephony != null) {
                videoTelephony.addVideoListener(callPeer, (VideoListener)this);
            }
            for (ConferenceMember conferenceMember : callPeer.getConferenceMembers()) {
                this.addListeners(conferenceMember);
            }
        }

        private void addListeners(ConferenceMember conferenceMember) {
            conferenceMember.addPropertyChangeListener((PropertyChangeListener)this);
        }

        public void callPeerAdded(CallPeerEvent ev) {
            this.onCallPeerEvent(ev);
        }

        public void callPeerRemoved(CallPeerEvent ev) {
            this.onCallPeerEvent(ev);
        }

        public void callStateChanged(CallChangeEvent ev) {
        }

        void dispose() {
            UIVideoHandler2.this.callConference.removeCallChangeListener((CallChangeListener)this);
            UIVideoHandler2.this.callConference.removeCallPeerConferenceListener((CallPeerConferenceListener)this);
            UIVideoHandler2.this.callConference.removePropertyChangeListener((PropertyChangeListener)this);
            for (Call call : UIVideoHandler2.this.callConference.getCalls()) {
                this.removeListeners(call);
            }
        }

        protected void onCallPeerConferenceEvent(CallPeerConferenceEvent ev) {
            switch (ev.getEventID()) {
                case 2: {
                    this.addListeners(ev.getConferenceMember());
                    break;
                }
                case 3: {
                    this.removeListeners(ev.getConferenceMember());
                }
            }
            UIVideoHandler2.this.onCallPeerConferenceEvent(ev);
        }

        private void onCallPeerEvent(CallPeerEvent ev) {
            switch (ev.getEventID()) {
                case 1: {
                    this.addListeners(ev.getSourceCallPeer());
                    break;
                }
                case 2: {
                    this.removeListeners(ev.getSourceCallPeer());
                }
            }
            UIVideoHandler2.this.onCallPeerEvent(ev);
        }

        private void onVideoEvent(VideoEvent ev) {
            UIVideoHandler2.this.onVideoEvent(ev);
        }

        @Override
        public void propertyChange(PropertyChangeEvent ev) {
            String propertyName = ev.getPropertyName();
            if ("calls".equals(propertyName)) {
                if (ev.getSource() instanceof CallConference) {
                    Object newValue;
                    Object oldValue = ev.getOldValue();
                    if (oldValue instanceof Call) {
                        this.removeListeners((Call)oldValue);
                    }
                    if ((newValue = ev.getNewValue()) instanceof Call) {
                        this.addListeners((Call)newValue);
                    }
                    UIVideoHandler2.this.callConferenceCallsPropertyChange(ev);
                }
            } else if ("videoSsrc".equals(propertyName) || "videoStatus".equals(propertyName)) {
                if (ev.getSource() instanceof ConferenceMember) {
                    UIVideoHandler2.this.conferenceMemberVideoPropertyChange(ev);
                }
            } else if ("LOCAL_VIDEO_STREAMING".equals(propertyName)) {
                UIVideoHandler2.this.localVideoStreamingPropertyChange(ev);
            }
        }

        private void removeListeners(Call call) {
            OperationSetVideoTelephony videoTelephony = (OperationSetVideoTelephony)call.getProtocolProvider().getOperationSet(OperationSetVideoTelephony.class);
            if (videoTelephony != null) {
                videoTelephony.addPropertyChangeListener(call, (PropertyChangeListener)this);
            }
            Iterator callPeerIter = call.getCallPeers();
            while (callPeerIter.hasNext()) {
                this.removeListeners((CallPeer)callPeerIter.next());
            }
        }

        private void removeListeners(CallPeer callPeer) {
            OperationSetVideoTelephony videoTelephony = (OperationSetVideoTelephony)callPeer.getProtocolProvider().getOperationSet(OperationSetVideoTelephony.class);
            if (videoTelephony != null) {
                videoTelephony.removeVideoListener(callPeer, (VideoListener)this);
            }
            for (ConferenceMember conferenceMember : callPeer.getConferenceMembers()) {
                this.removeListeners(conferenceMember);
            }
        }

        private void removeListeners(ConferenceMember conferenceMember) {
            conferenceMember.removePropertyChangeListener((PropertyChangeListener)this);
        }

        public void videoAdded(VideoEvent ev) {
            this.onVideoEvent(ev);
        }

        public void videoRemoved(VideoEvent ev) {
            this.onVideoEvent(ev);
        }

        public void videoUpdate(VideoEvent ev) {
            this.onVideoEvent(ev);
        }
    }
}

