/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.gui.main.authorization;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import net.java.sip.communicator.impl.gui.GuiActivator;
import net.java.sip.communicator.impl.gui.main.MainFrame;
import net.java.sip.communicator.impl.gui.main.contactlist.AddContactDialog;
import net.java.sip.communicator.impl.gui.utils.ImageLoader;
import net.java.sip.communicator.plugin.desktoputil.SIPCommCheckBox;
import net.java.sip.communicator.plugin.desktoputil.SIPCommDialog;
import net.java.sip.communicator.plugin.desktoputil.TransparentPanel;
import net.java.sip.communicator.service.contactlist.MetaContactGroup;
import net.java.sip.communicator.service.protocol.AuthorizationRequest;
import net.java.sip.communicator.service.protocol.Contact;
import net.java.sip.communicator.util.Logger;
import net.java.sip.communicator.util.skin.Skinnable;

public class AuthorizationRequestedDialog
extends SIPCommDialog
implements ActionListener,
Skinnable {
    private final Logger logger = Logger.getLogger(AuthorizationRequestedDialog.class);
    public static final int UNDEFINED_CODE = -2;
    public static final int ACCEPT_CODE = 0;
    public static final int REJECT_CODE = 1;
    public static final int IGNORE_CODE = 2;
    public static final int ERROR_CODE = -1;
    private JTextArea infoTextArea = new JTextArea();
    private JTextPane requestPane = new JTextPane();
    private JPanel buttonsPanel = new TransparentPanel((LayoutManager)new FlowLayout(2));
    private JPanel northPanel = new TransparentPanel((LayoutManager)new BorderLayout(10, 0));
    private JPanel titlePanel = new TransparentPanel((LayoutManager)new GridLayout(0, 1));
    private JLabel titleLabel = new JLabel();
    private JLabel iconLabel = new JLabel(new ImageIcon(ImageLoader.getImage(ImageLoader.AUTHORIZATION_ICON)));
    private JButton acceptButton = new JButton(GuiActivator.getResources().getI18NString("service.gui.AUTHORIZE"));
    private JButton rejectButton = new JButton(GuiActivator.getResources().getI18NString("service.gui.DENY"));
    private JButton ignoreButton = new JButton(GuiActivator.getResources().getI18NString("service.gui.IGNORE"));
    private JScrollPane requestScrollPane = new JScrollPane();
    private JPanel mainPanel = new TransparentPanel((LayoutManager)new BorderLayout(10, 10));
    private JPanel reasonsPanel = new TransparentPanel();
    private String title = GuiActivator.getResources().getI18NString("service.gui.AUTHORIZATION_REQUESTED");
    private SIPCommCheckBox addContactCheckBox;
    private JComboBox groupComboBox;
    private Object lock = new Object();
    private int result = -2;

    public AuthorizationRequestedDialog(MainFrame mainFrame, Contact contact, AuthorizationRequest request) {
        super((Frame)((Object)mainFrame), false);
        this.setModal(false);
        this.setTitle(this.title);
        this.titleLabel.setHorizontalAlignment(0);
        this.titleLabel.setText(this.title);
        Font font = this.titleLabel.getFont();
        this.titleLabel.setFont(font.deriveFont(1, font.getSize2D() + 6.0f));
        String contactName = "";
        if (contact.getAddress().equals(contact.getDisplayName())) {
            contactName = contact.getAddress();
        } else {
            String displayName = contact.getDisplayName();
            if (displayName.length() > 64) {
                displayName = displayName.substring(0, 47) + "...";
            }
            contactName = displayName + " <" + contact.getAddress() + ">";
        }
        String infoText = GuiActivator.getResources().getI18NString("service.gui.AUTHORIZATION_REQUESTED_INFO", new String[]{contactName});
        if (infoText.length() > 256) {
            infoText = infoText.substring(0, 253) + "...";
        }
        this.infoTextArea.setText(infoText);
        this.infoTextArea.setFont(this.infoTextArea.getFont().deriveFont(1));
        this.infoTextArea.setLineWrap(true);
        this.infoTextArea.setWrapStyleWord(true);
        this.infoTextArea.setOpaque(false);
        this.infoTextArea.setEditable(false);
        this.titlePanel.add(this.titleLabel);
        this.titlePanel.add(this.infoTextArea);
        this.northPanel.add((Component)this.iconLabel, "West");
        this.northPanel.add((Component)this.titlePanel, "Center");
        this.reasonsPanel.setLayout(new BoxLayout(this.reasonsPanel, 1));
        this.reasonsPanel.setBorder(BorderFactory.createEmptyBorder(0, this.iconLabel.getIcon().getIconWidth() + 5, 0, 0));
        if (request.getReason() != null && !request.getReason().equals("")) {
            this.requestScrollPane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createEmptyBorder(3, 3, 3, 3)));
            this.requestScrollPane.getViewport().setOpaque(false);
            this.requestPane.setEditable(false);
            this.requestPane.setOpaque(false);
            this.requestPane.setText(request.getReason());
            this.requestScrollPane.getViewport().add(this.requestPane);
            this.reasonsPanel.add(this.requestScrollPane);
            this.mainPanel.setPreferredSize(new Dimension(700, 270));
        } else {
            this.mainPanel.setPreferredSize(new Dimension(700, 220));
        }
        if (!contact.isPersistent()) {
            String addContactText = "";
            addContactText = contactName.length() > 50 ? GuiActivator.getResources().getI18NString("service.gui.ADD_CONTACT_TO_CONTACTLIST", new String[]{contactName}) : GuiActivator.getResources().getI18NString("service.gui.ADD_AUTHORIZED_CONTACT", new String[]{contactName});
            this.addContactCheckBox = new SIPCommCheckBox(addContactText, true);
            this.addContactCheckBox.setBorder(null);
            TransparentPanel checkBoxPanel = new TransparentPanel((LayoutManager)new FlowLayout(0));
            checkBoxPanel.add((Component)this.addContactCheckBox);
            JLabel groupLabel = new JLabel(GuiActivator.getResources().getI18NString("service.gui.SELECT_GROUP"));
            this.groupComboBox = AddContactDialog.createGroupCombo((Dialog)((Object)this));
            TransparentPanel groupPanel = new TransparentPanel((LayoutManager)new BorderLayout(5, 5));
            groupPanel.add((Component)groupLabel, "West");
            groupPanel.add((Component)this.groupComboBox, "Center");
            this.reasonsPanel.add((Component)checkBoxPanel);
            this.reasonsPanel.add((Component)groupPanel);
        }
        this.acceptButton.setName("authorize");
        this.rejectButton.setName("deny");
        this.ignoreButton.setName("ignore");
        this.acceptButton.addActionListener(this);
        this.rejectButton.addActionListener(this);
        this.ignoreButton.addActionListener(this);
        this.acceptButton.setMnemonic(GuiActivator.getResources().getI18nMnemonic("service.gui.AUTHORIZE"));
        this.rejectButton.setMnemonic(GuiActivator.getResources().getI18nMnemonic("service.gui.DENY"));
        this.ignoreButton.setMnemonic(GuiActivator.getResources().getI18nMnemonic("service.gui.IGNORE"));
        this.buttonsPanel.add(this.acceptButton);
        this.buttonsPanel.add(this.rejectButton);
        this.buttonsPanel.add(this.ignoreButton);
        this.mainPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.mainPanel.add((Component)this.northPanel, "North");
        this.mainPanel.add((Component)this.reasonsPanel, "Center");
        this.mainPanel.add((Component)this.buttonsPanel, "South");
        this.getContentPane().add(this.mainPanel);
    }

    public void showDialog() {
        this.setVisible(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getReturnCode() {
        Object object = this.lock;
        synchronized (object) {
            try {
                if (this.result == -2) {
                    this.lock.wait();
                }
            }
            catch (InterruptedException e) {
                this.logger.error((Object)"Authorization request interrupted.", (Throwable)e);
            }
        }
        return this.result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent e) {
        JButton button = (JButton)e.getSource();
        String name = button.getName();
        Object object = this.lock;
        synchronized (object) {
            this.result = name.equals("authorize") ? 0 : (name.equals("deny") ? 1 : (name.equals("ignore") ? 2 : -1));
            this.lock.notify();
        }
        this.dispose();
    }

    protected void close(boolean isEscaped) {
        this.ignoreButton.doClick();
    }

    public void loadSkin() {
        this.iconLabel.setIcon(new ImageIcon(ImageLoader.getImage(ImageLoader.AUTHORIZATION_ICON)));
    }

    public boolean isAddContact() {
        if (this.addContactCheckBox != null) {
            return this.addContactCheckBox.isSelected();
        }
        return false;
    }

    public MetaContactGroup getSelectedMetaContactGroup() {
        return (MetaContactGroup)this.groupComboBox.getSelectedItem();
    }
}

