/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.gui.main.account;

import java.util.Enumeration;
import javax.swing.DefaultListModel;
import javax.swing.SwingUtilities;
import net.java.sip.communicator.impl.gui.main.account.Account;
import net.java.sip.communicator.service.protocol.AccountID;

public class AccountListModel
extends DefaultListModel {
    public void contentChanged(Account account) {
        int index = this.indexOf(account);
        this.fireContentsChanged(this, index, index);
    }

    public void addAccount(final Account account) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    AccountListModel.this.addAccount(account);
                }
            });
            return;
        }
        if (this.getSize() == 0) {
            this.addElement(account);
            return;
        }
        boolean isAccountAdded = false;
        Enumeration accounts = this.elements();
        while (accounts.hasMoreElements()) {
            Account a = (Account)accounts.nextElement();
            int accountIndex = this.indexOf(a);
            int protocolCompare = account.getProtocolName().compareTo(a.getProtocolName());
            if (protocolCompare < 0) {
                this.insertElementAt(account, accountIndex);
                isAccountAdded = true;
                break;
            }
            if (protocolCompare != 0 || account.getName().compareTo(a.getName()) >= 0) continue;
            this.insertElementAt(account, accountIndex);
            isAccountAdded = true;
            break;
        }
        if (!isAccountAdded) {
            this.addElement(account);
        }
    }

    public void removeAccount(final Account account) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    AccountListModel.this.removeAccount(account);
                }
            });
            return;
        }
        super.removeElement(account);
    }

    public Account getAccount(AccountID accountID) {
        Enumeration accounts = this.elements();
        while (accounts.hasMoreElements()) {
            Account account = (Account)accounts.nextElement();
            if (!account.getAccountID().equals((Object)accountID)) continue;
            return account;
        }
        return null;
    }
}

