/*
 * Decompiled with CFR 0.152.
 */
package com.explodingpixels.macwidgets;

import com.explodingpixels.macwidgets.DEverything;
import com.explodingpixels.macwidgets.MacButtonFactory;
import com.explodingpixels.macwidgets.MacIcons;
import com.explodingpixels.macwidgets.MacUtils;
import com.explodingpixels.macwidgets.MacWidgetFactory;
import com.explodingpixels.macwidgets.SourceList;
import com.explodingpixels.macwidgets.SourceListCategory;
import com.explodingpixels.macwidgets.SourceListControlBar;
import com.explodingpixels.macwidgets.SourceListItem;
import com.explodingpixels.macwidgets.SourceListModel;
import com.explodingpixels.macwidgets.UnifiedToolBar;
import com.explodingpixels.widgets.PopupMenuCustomizerUsingStrings;
import com.explodingpixels.widgets.TrackingSpacer;
import com.explodingpixels.widgets.WindowUtils;
import java.awt.Component;
import java.awt.Image;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;

public class DTrackingSpacer {
    private static UnifiedToolBar createUnifiedToolBar(SourceList sourceList) {
        ImageIcon blueGlobeIcon = new ImageIcon(DEverything.class.getResource("/com/explodingpixels/macwidgets/icons/DotMac.png"));
        ImageIcon greyGlobeIcon = new ImageIcon(DEverything.class.getResource("/com/explodingpixels/macwidgets/icons/Network.png"));
        ImageIcon preferences = new ImageIcon(DEverything.class.getResource("/com/explodingpixels/macwidgets/icons/PreferencesGeneral.png"));
        ImageIcon gear = new ImageIcon(DEverything.class.getResource("/com/explodingpixels/macwidgets/icons/Advanced.png"));
        AbstractButton greyGlobeButton = MacButtonFactory.makeUnifiedToolBarButton(new JButton("Network", greyGlobeIcon));
        greyGlobeButton.setEnabled(false);
        JButton blueButton = new JButton("MobileMe", blueGlobeIcon);
        blueButton.setEnabled(true);
        UnifiedToolBar toolBar = new UnifiedToolBar();
        TrackingSpacer spacer = new TrackingSpacer(sourceList.getComponent(), TrackingSpacer.TrackingDimension.WIDTH, -10);
        toolBar.addComponentToLeft(spacer);
        toolBar.addComponentToLeft(MacButtonFactory.makeUnifiedToolBarButton(blueButton));
        toolBar.addComponentToLeft(greyGlobeButton);
        toolBar.addComponentToLeft(MacButtonFactory.makeUnifiedToolBarButton(new JButton("Preferences", preferences)));
        toolBar.addComponentToRight(MacButtonFactory.makeUnifiedToolBarButton(new JButton("Advanced", gear)));
        return toolBar;
    }

    private static SourceList createSourceList() {
        Image blueGlobeImage = new ImageIcon(DEverything.class.getResource("/com/explodingpixels/macwidgets/icons/DotMac.png")).getImage().getScaledInstance(16, 16, 4);
        Image greyGlobeImage = new ImageIcon(DEverything.class.getResource("/com/explodingpixels/macwidgets/icons/Network.png")).getImage().getScaledInstance(16, 16, 4);
        ImageIcon blueGlobeIcon = new ImageIcon(blueGlobeImage);
        ImageIcon greyGlobeIcon = new ImageIcon(greyGlobeImage);
        SourceListCategory categoryOne = new SourceListCategory("Category 1");
        SourceListCategory categoryTwo = new SourceListCategory("Category 2");
        SourceListCategory categoryThree = new SourceListCategory("Category 3");
        SourceListItem itemA = new SourceListItem("SourceListItem A", blueGlobeIcon);
        SourceListItem itemB = new SourceListItem("SourceListItem B", greyGlobeIcon);
        SourceListItem itemC = new SourceListItem("SourceListItem D", greyGlobeIcon);
        SourceListItem itemD = new SourceListItem("SourceListItem E", greyGlobeIcon);
        SourceListItem itemE = new SourceListItem("Really really really really really long SourceListItem", greyGlobeIcon);
        SourceListItem itemG = new SourceListItem("SourceListItem G", greyGlobeIcon);
        SourceListItem itemH = new SourceListItem("SourceListItem H", greyGlobeIcon);
        SourceListItem itemI = new SourceListItem("SourceListItem I", greyGlobeIcon);
        SourceListItem itemJ = new SourceListItem("SourceListItem J", greyGlobeIcon);
        SourceListItem itemK = new SourceListItem("SourceListItem K", greyGlobeIcon);
        SourceListItem itemL = new SourceListItem("SourceListItem L", greyGlobeIcon);
        itemA.setCounterValue(1);
        itemC.setCounterValue(385);
        itemE.setCounterValue(3);
        itemI.setCounterValue(17);
        SourceListModel model = new SourceListModel();
        model.addCategory(categoryOne);
        model.addItemToCategory(itemA, categoryOne);
        model.addItemToCategory(itemB, categoryOne);
        model.addCategory(categoryTwo);
        model.addItemToCategory(itemC, categoryTwo);
        model.addItemToCategory(itemD, categoryTwo);
        model.addItemToCategory(itemE, categoryTwo);
        model.addCategory(categoryThree);
        model.addItemToCategory(itemG, categoryThree);
        model.addItemToCategory(itemH, categoryThree);
        model.addItemToCategory(itemI, categoryThree);
        model.addItemToCategory(itemJ, categoryThree);
        model.addItemToCategory(itemK, categoryThree);
        model.addItemToCategory(itemL, categoryThree);
        SourceList sourceList = new SourceList(model);
        return sourceList;
    }

    private static JSplitPane createJSplitPane(SourceList sourceList) {
        JTextArea textArea = new JTextArea();
        JSplitPane splitPane = MacWidgetFactory.createSplitPaneForSourceList(sourceList, textArea);
        splitPane.setDividerLocation(200);
        return splitPane;
    }

    private static void createAndInstallControlBar(SourceList sourceList, JSplitPane splitPane) {
        SourceListControlBar controlBar = new SourceListControlBar();
        controlBar.createAndAddButton(MacIcons.PLUS, null);
        controlBar.createAndAddButton(MacIcons.MINUS, null);
        controlBar.createAndAddPopdownButton(MacIcons.GEAR, new PopupMenuCustomizerUsingStrings(null, "Item One", "Item Two", "Item Three"));
        sourceList.installSourceListControlBar(controlBar);
        controlBar.installDraggableWidgetOnSplitPane(splitPane);
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                JFrame frame = new JFrame();
                MacUtils.makeWindowLeopardStyle(frame.getRootPane());
                WindowUtils.createAndInstallRepaintWindowFocusListener(frame);
                SourceList sourceList = DTrackingSpacer.createSourceList();
                JSplitPane splitPane = DTrackingSpacer.createJSplitPane(sourceList);
                UnifiedToolBar unifiedToolBar = DTrackingSpacer.createUnifiedToolBar(sourceList);
                DTrackingSpacer.createAndInstallControlBar(sourceList, splitPane);
                unifiedToolBar.installWindowDraggerOnWindow(frame);
                frame.add((Component)unifiedToolBar.getComponent(), "North");
                frame.add((Component)splitPane, "Center");
                frame.setSize(650, 450);
                frame.setLocationRelativeTo(null);
                frame.setDefaultCloseOperation(2);
                frame.setVisible(true);
            }
        });
    }
}

