/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.spellcheck;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.JTextComponent;
import net.java.sip.communicator.plugin.desktoputil.SIPCommDialog;
import net.java.sip.communicator.plugin.desktoputil.TransparentPanel;
import net.java.sip.communicator.plugin.spellcheck.Resources;
import net.java.sip.communicator.plugin.spellcheck.Word;
import net.java.sip.communicator.service.gui.Chat;
import net.java.sip.communicator.util.Logger;
import org.dts.spell.dictionary.SpellDictionary;
import org.dts.spell.dictionary.SpellDictionaryException;
import org.jitsi.service.resources.ResourceManagementService;

public class SpellCheckerConfigDialog
extends SIPCommDialog
implements ActionListener {
    private static final long serialVersionUID = 0L;
    private static final Logger logger = Logger.getLogger(SpellCheckerConfigDialog.class);
    private JTextComponent currentWord;
    private JList suggestionList;
    private JScrollPane suggestionScroll;
    private JButton changeButton;
    private JButton nextButton;
    private JButton addButton;
    private JPanel checkPanel;
    private JPanel buttonsPanel;
    private JPanel topPanel;
    private JPanel suggestionPanel;
    private SpellDictionary dict;
    private Chat chat;
    private final ResourceManagementService resources = Resources.getResources();
    private String word;
    private int index;
    private Word clickedWord;

    public SpellCheckerConfigDialog(Chat chat, Word clickedWord, SpellDictionary dict) {
        super(false);
        this.dict = dict;
        this.chat = chat;
        this.initComponents(clickedWord);
        this.setTitle(this.resources.getI18NString("plugin.spellcheck.TITLE"));
        this.setMinimumSize(new Dimension(450, 320));
        this.setPreferredSize(new Dimension(450, 320));
        this.setResizable(false);
        JPanel mainPanel = new JPanel(new BorderLayout(10, 10));
        mainPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        mainPanel.add(this.topPanel);
        this.getContentPane().add(mainPanel);
        this.pack();
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension screenSize = toolkit.getScreenSize();
        int x = (screenSize.width - this.getWidth()) / 2;
        int y = (screenSize.height - this.getHeight()) / 2;
        this.setLocation(x, y);
        if (!this.currentWord.getText().equals("  ") && this.dict.isCorrect(this.currentWord.getText())) {
            this.nextButton.doClick();
        }
    }

    private void initComponents(Word clickWord) {
        this.clickedWord = clickWord == null ? Word.getWord("  ", 1, false) : clickWord;
        this.topPanel = new TransparentPanel((LayoutManager)new BorderLayout());
        this.topPanel.setBorder(BorderFactory.createEmptyBorder(0, 8, 0, 8));
        this.topPanel.setLayout(new BoxLayout(this.topPanel, 1));
        this.checkPanel = new TransparentPanel((LayoutManager)new BorderLayout(10, 10));
        this.checkPanel.setBorder(BorderFactory.createEmptyBorder(0, 8, 0, 8));
        this.checkPanel.setLayout(new BoxLayout(this.checkPanel, 0));
        this.currentWord = new JTextField(this.clickedWord.getText());
        this.currentWord.setAlignmentX(0.0f);
        this.currentWord.setMaximumSize(new Dimension(550, 30));
        this.currentWord.setText(this.clickedWord.getText());
        this.currentWord.selectAll();
        this.buttonsPanel = new TransparentPanel((LayoutManager)new FlowLayout(2, 0, 10));
        this.changeButton = new JButton(this.resources.getI18NString("plugin.spellcheck.dialog.REPLACE"));
        this.changeButton.setMnemonic(this.resources.getI18nMnemonic("plugin.spellcheck.dialog.REPLACE"));
        this.changeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (SpellCheckerConfigDialog.this.suggestionList.getSelectedValue() != null) {
                    StringBuffer newMessage = new StringBuffer(SpellCheckerConfigDialog.this.chat.getMessage());
                    if (SpellCheckerConfigDialog.this.word != null) {
                        int endIndex = SpellCheckerConfigDialog.this.index + SpellCheckerConfigDialog.this.currentWord.getText().length();
                        newMessage.replace(SpellCheckerConfigDialog.this.index, endIndex, (String)SpellCheckerConfigDialog.this.suggestionList.getSelectedValue());
                        SpellCheckerConfigDialog.this.word = (String)SpellCheckerConfigDialog.this.suggestionList.getSelectedValue();
                    } else {
                        int endIndex = SpellCheckerConfigDialog.this.clickedWord.getStart() + SpellCheckerConfigDialog.this.clickedWord.getText().length();
                        newMessage.replace(SpellCheckerConfigDialog.this.clickedWord.getStart(), endIndex, (String)SpellCheckerConfigDialog.this.suggestionList.getSelectedValue());
                    }
                    SpellCheckerConfigDialog.this.currentWord.setText((String)SpellCheckerConfigDialog.this.suggestionList.getSelectedValue());
                    SpellCheckerConfigDialog.this.chat.setMessage(newMessage.toString());
                }
            }
        });
        this.changeButton.setEnabled(false);
        this.nextButton = new JButton(this.resources.getI18NString("plugin.spellcheck.dialog.FIND"));
        this.nextButton.setMnemonic(this.resources.getI18nMnemonic("plugin.spellcheck.dialog.FIND"));
        this.nextButton.addActionListener(new ActionListener(){

            public Word getNextWord() {
                Word presentWord;
                int wordIndex;
                if (SpellCheckerConfigDialog.this.word == null) {
                    if (SpellCheckerConfigDialog.this.currentWord.getText().equals("  ")) {
                        String[] words = SpellCheckerConfigDialog.this.chat.getMessage().split(" ");
                        SpellCheckerConfigDialog.this.currentWord.setText(words[0]);
                    }
                    wordIndex = SpellCheckerConfigDialog.this.chat.getMessage().indexOf(SpellCheckerConfigDialog.this.currentWord.getText());
                    if (SpellCheckerConfigDialog.this.dict.isCorrect(SpellCheckerConfigDialog.this.currentWord.getText())) {
                        SpellCheckerConfigDialog.this.currentWord.setText("");
                    }
                } else {
                    wordIndex = SpellCheckerConfigDialog.this.chat.getMessage().indexOf(SpellCheckerConfigDialog.this.word, SpellCheckerConfigDialog.this.index);
                }
                Word nextWord = (presentWord = Word.getWord(SpellCheckerConfigDialog.this.chat.getMessage(), wordIndex, false)).getEnd() == SpellCheckerConfigDialog.this.chat.getMessage().length() ? Word.getWord(SpellCheckerConfigDialog.this.chat.getMessage(), 0, false) : Word.getWord(SpellCheckerConfigDialog.this.chat.getMessage(), presentWord.getEnd() + 1, false);
                SpellCheckerConfigDialog.this.index = nextWord.getStart();
                SpellCheckerConfigDialog.this.word = nextWord.getText();
                return nextWord;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                Word nextWord = this.getNextWord();
                int breakIndex = nextWord.getStart();
                if (breakIndex == 0) {
                    breakIndex = nextWord.getEnd() + 1;
                }
                if (nextWord.getText().length() == 0) {
                    ++breakIndex;
                    nextWord = this.getNextWord();
                }
                while (SpellCheckerConfigDialog.this.dict.isCorrect(nextWord.getText()) && nextWord.getEnd() + 1 != breakIndex) {
                    nextWord = this.getNextWord();
                }
                if (!SpellCheckerConfigDialog.this.dict.isCorrect(nextWord.getText())) {
                    SpellCheckerConfigDialog.this.word = nextWord.getText();
                    SpellCheckerConfigDialog.this.currentWord.setText(nextWord.getText());
                    String clickedWord = SpellCheckerConfigDialog.this.currentWord.getText();
                    SpellCheckerConfigDialog.this.setSuggestionModel(clickedWord);
                }
            }
        });
        this.buttonsPanel.setLayout(new BoxLayout(this.buttonsPanel, 1));
        this.buttonsPanel.add(this.changeButton);
        this.buttonsPanel.add(this.nextButton);
        this.checkPanel.add((Component)this.currentWord, "North");
        this.checkPanel.add(Box.createHorizontalStrut(10));
        this.checkPanel.add((Component)this.buttonsPanel, "East");
        this.topPanel.add((Component)this.checkPanel, "North");
        this.topPanel.add(Box.createVerticalStrut(10));
        DefaultListModel dataModel = new DefaultListModel();
        this.suggestionList = new JList(dataModel);
        this.suggestionScroll = new JScrollPane(this.suggestionList);
        this.suggestionScroll.setAlignmentX(0.0f);
        if (!this.dict.isCorrect(this.clickedWord.getText())) {
            this.setSuggestionModel(this.clickedWord.getText());
        }
        this.suggestionList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    SpellCheckerConfigDialog.this.changeButton.setEnabled(true);
                }
            }
        });
        MouseAdapter clickListener = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    StringBuffer newMessage = new StringBuffer(SpellCheckerConfigDialog.this.chat.getMessage());
                    if (SpellCheckerConfigDialog.this.word != null) {
                        int endIndex = SpellCheckerConfigDialog.this.index + SpellCheckerConfigDialog.this.currentWord.getText().length();
                        newMessage.replace(SpellCheckerConfigDialog.this.index, endIndex, (String)SpellCheckerConfigDialog.this.suggestionList.getSelectedValue());
                        SpellCheckerConfigDialog.this.word = (String)SpellCheckerConfigDialog.this.suggestionList.getSelectedValue();
                    } else {
                        int endIndex = SpellCheckerConfigDialog.this.clickedWord.getStart() + SpellCheckerConfigDialog.this.clickedWord.getText().length();
                        newMessage.replace(SpellCheckerConfigDialog.this.clickedWord.getStart(), endIndex, (String)SpellCheckerConfigDialog.this.suggestionList.getSelectedValue());
                    }
                    SpellCheckerConfigDialog.this.currentWord.setText((String)SpellCheckerConfigDialog.this.suggestionList.getSelectedValue());
                    SpellCheckerConfigDialog.this.chat.setMessage(newMessage.toString());
                }
            }
        };
        this.suggestionList.addMouseListener(clickListener);
        this.addButton = new JButton(this.resources.getI18NString("plugin.spellcheck.dialog.ADD"));
        this.addButton.setMnemonic(this.resources.getI18nMnemonic("plugin.spellcheck.dialog.ADD"));
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    SpellCheckerConfigDialog.this.dict.addWord(SpellCheckerConfigDialog.this.currentWord.getText());
                    SpellCheckerConfigDialog.this.chat.promptRepaint();
                }
                catch (SpellDictionaryException exc) {
                    String msg = "Unable to add word to personal dictionary";
                    logger.error((Object)msg, (Throwable)exc);
                }
            }
        });
        this.suggestionPanel = new TransparentPanel((LayoutManager)new BorderLayout(10, 10));
        this.suggestionPanel.setBorder(BorderFactory.createEmptyBorder(0, 8, 0, 8));
        this.suggestionPanel.setLayout(new BoxLayout(this.suggestionPanel, 0));
        this.suggestionPanel.add(this.suggestionScroll);
        this.suggestionPanel.add(Box.createHorizontalStrut(10));
        this.suggestionPanel.add(this.addButton);
        this.topPanel.add((Component)this.suggestionPanel, "South");
    }

    private void setSuggestionModel(String clickedWord) {
        DefaultListModel<String> dataModel = new DefaultListModel<String>();
        List<String> corrections = this.dict.getSuggestions(clickedWord);
        for (String correction : corrections) {
            dataModel.addElement(correction);
        }
        this.suggestionList.setModel(dataModel);
    }

    public Object getCorrection() {
        return this.suggestionList.getSelectedValue();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
    }

    protected void close(boolean escaped) {
    }
}

