/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.spellcheck;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import net.java.sip.communicator.plugin.spellcheck.DocUnderliner;
import net.java.sip.communicator.plugin.spellcheck.Resources;
import net.java.sip.communicator.plugin.spellcheck.SpellCheckerConfigDialog;
import net.java.sip.communicator.plugin.spellcheck.Word;
import net.java.sip.communicator.service.gui.Chat;
import net.java.sip.communicator.service.gui.event.ChatMenuListener;
import net.java.sip.communicator.util.Logger;
import org.dts.spell.dictionary.SpellDictionary;
import org.dts.spell.dictionary.SpellDictionaryException;
import org.jitsi.service.resources.ResourceManagementService;

class ChatAttachments {
    private static final Logger logger = Logger.getLogger(ChatAttachments.class);
    private static final ImageIcon ADD_WORD_ICON = Resources.getImage("plugin.spellcheck.ADD_WORD_ICON");
    public final Chat chat;
    private final DocUnderliner docListener;
    private final CaretListener caretListener;
    private final ChatMenuListener menuListener;
    private boolean isEnabled = true;
    private SpellDictionary dict;
    private boolean isAttached = false;
    private final ResourceManagementService resources = Resources.getResources();
    private SpellCheckerConfigDialog dialog;

    public ChatAttachments(Chat chat, final SpellDictionary dict) {
        this.chat = chat;
        this.dict = dict;
        this.docListener = new DocUnderliner(chat.getHighlighter()){

            @Override
            boolean getFormatting(String word) {
                try {
                    return !ChatAttachments.this.dict.isCorrect(word);
                }
                catch (NullPointerException exc) {
                    logger.error((Object)"Spell checker dictionary failed to be accessed", (Throwable)exc);
                    return false;
                }
            }

            @Override
            int getCaretPosition() {
                return ChatAttachments.this.chat.getCaretPosition();
            }

            @Override
            void promptRepaint() {
                ChatAttachments.this.chat.promptRepaint();
            }
        };
        this.caretListener = this.docListener.getEndChecker();
        this.menuListener = new ChatMenuListener(){

            public List<JMenuItem> getMenuElements(final Chat chat, MouseEvent event) {
                if (ChatAttachments.this.isEnabled && event.getSource() instanceof JTextComponent) {
                    JTextComponent comp = (JTextComponent)event.getSource();
                    int index = comp.viewToModel(event.getPoint());
                    try {
                        String compText = comp.getDocument().getText(0, comp.getDocument().getLength());
                        if (index != -1 && compText.length() != 0) {
                            return ChatAttachments.this.getCorrections(Word.getWord(comp.getDocument().getText(0, comp.getDocument().getLength()), index, false));
                        }
                    }
                    catch (BadLocationException e) {
                        logger.error((Object)"Error", (Throwable)e);
                    }
                }
                JMenuItem spellCheck = new JMenuItem(ChatAttachments.this.resources.getI18NString("plugin.spellcheck.MENU"));
                ArrayList<JMenuItem> spellCheckItem = new ArrayList<JMenuItem>();
                spellCheckItem.add(spellCheck);
                spellCheck.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if (ChatAttachments.this.dialog != null) {
                            ChatAttachments.this.dialog.dispose();
                        }
                        ChatAttachments.this.dialog = new SpellCheckerConfigDialog(chat, null, dict);
                        ChatAttachments.this.dialog.setVisible(true);
                    }
                });
                return spellCheckItem;
            }
        };
    }

    synchronized void attachListeners() {
        if (!this.isAttached) {
            this.chat.addChatEditorDocumentListener((DocumentListener)this.docListener);
            this.chat.addChatEditorCaretListener(this.caretListener);
            this.chat.addChatEditorMenuListener(this.menuListener);
        }
    }

    synchronized void detachListeners() {
        if (this.isAttached) {
            this.chat.removeChatEditorDocumentListener((DocumentListener)this.docListener);
            this.chat.removeChatEditorCaretListener(this.caretListener);
            this.chat.removeChatEditorMenuListener(this.menuListener);
        }
    }

    boolean isEnabled() {
        return this.isEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setEnabled(boolean enable) {
        SpellDictionary spellDictionary = this.dict;
        synchronized (spellDictionary) {
            this.isEnabled = enable;
            this.docListener.setEnabled(enable, this.chat.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setDictionary(SpellDictionary dict) {
        SpellDictionary spellDictionary = this.dict;
        synchronized (spellDictionary) {
            this.dict = dict;
            this.docListener.reset(this.chat.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<JMenuItem> getCorrections(final Word clickedWord) {
        ArrayList<JMenuItem> correctionEntries = new ArrayList<JMenuItem>();
        SpellDictionary spellDictionary = this.dict;
        synchronized (spellDictionary) {
            if (!this.dict.isCorrect(clickedWord.getText())) {
                List<String> corrections = this.dict.getSuggestions(clickedWord.getText());
                for (String correction : corrections) {
                    JMenuItem newEntry = new JMenuItem(correction);
                    newEntry.addActionListener(new CorrectionListener(clickedWord, correction));
                    correctionEntries.add(newEntry);
                }
                JMenuItem addWord = new JMenuItem(this.resources.getI18NString("plugin.spellcheck.dialog.ADD"), ADD_WORD_ICON);
                addWord.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent event) {
                        try {
                            ChatAttachments.this.dict.addWord(clickedWord.getText());
                            ChatAttachments.this.docListener.format(clickedWord);
                            ChatAttachments.this.chat.promptRepaint();
                        }
                        catch (SpellDictionaryException exc) {
                            String msg = "Unable to add word to personal dictionary";
                            logger.error((Object)msg, (Throwable)exc);
                        }
                    }
                });
                correctionEntries.add(addWord);
            }
            JMenuItem spellCheck = new JMenuItem(this.resources.getI18NString("plugin.spellcheck.MENU"));
            correctionEntries.add(spellCheck);
            spellCheck.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (ChatAttachments.this.dialog != null) {
                        ChatAttachments.this.dialog.dispose();
                    }
                    ChatAttachments.this.dialog = new SpellCheckerConfigDialog(ChatAttachments.this.chat, clickedWord, ChatAttachments.this.dict);
                    ChatAttachments.this.dialog.setVisible(true);
                }
            });
        }
        return correctionEntries;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ChatAttachments) {
            return this.chat.equals(((ChatAttachments)obj).chat);
        }
        return false;
    }

    public int hashCode() {
        return this.chat.hashCode();
    }

    private class CorrectionListener
    implements ActionListener {
        private final Word clickedWord;
        private final String correction;

        public CorrectionListener(Word clickedWord, String correction) {
            this.clickedWord = clickedWord;
            this.correction = correction;
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            StringBuffer newMessage = new StringBuffer(ChatAttachments.this.chat.getMessage());
            int endIndex = this.clickedWord.getStart() + this.clickedWord.getText().length();
            newMessage.replace(this.clickedWord.getStart(), endIndex, this.correction);
            ChatAttachments.this.chat.setMessage(newMessage.toString());
        }
    }
}

