/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.header;

import gov.nist.core.Host;
import gov.nist.core.HostPort;
import gov.nist.core.NameValue;
import gov.nist.core.NameValueList;
import gov.nist.javax.sip.header.ParametersHeader;
import gov.nist.javax.sip.header.Protocol;
import gov.nist.javax.sip.header.ViaHeaderExt;
import gov.nist.javax.sip.stack.HopImpl;
import java.text.ParseException;
import javax.sip.InvalidArgumentException;
import javax.sip.address.Hop;
import javax.sip.header.Parameters;
import javax.sip.header.ViaHeader;

public class Via
extends ParametersHeader
implements ViaHeader,
ViaHeaderExt {
    private static final long serialVersionUID = 5281728373401351378L;
    public static final String BRANCH = "branch";
    public static final String RECEIVED = "received";
    public static final String MADDR = "maddr";
    public static final String TTL = "ttl";
    public static final String RPORT = "rport";
    protected Protocol sentProtocol = new Protocol();
    protected HostPort sentBy;
    protected String comment;

    public Via() {
        super("Via");
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof ViaHeader) {
            ViaHeader o = (ViaHeader)other;
            return this.getProtocol().equalsIgnoreCase(o.getProtocol()) && this.getTransport().equalsIgnoreCase(o.getTransport()) && this.getHost().equalsIgnoreCase(o.getHost()) && this.getPort() == o.getPort() && this.equalParameters((Parameters)o);
        }
        return false;
    }

    public String getProtocolVersion() {
        if (this.sentProtocol == null) {
            return null;
        }
        return this.sentProtocol.getProtocolVersion();
    }

    public Protocol getSentProtocol() {
        return this.sentProtocol;
    }

    public HostPort getSentBy() {
        return this.sentBy;
    }

    public Hop getHop() {
        HopImpl hop = new HopImpl(this.sentBy.getHost().getHostname(), this.sentBy.getPort(), this.sentProtocol.getTransport());
        return hop;
    }

    public NameValueList getViaParms() {
        return this.parameters;
    }

    public String getComment() {
        return this.comment;
    }

    public boolean hasPort() {
        return this.getSentBy().hasPort();
    }

    public boolean hasComment() {
        return this.comment != null;
    }

    public void removePort() {
        this.sentBy.removePort();
    }

    public void removeComment() {
        this.comment = null;
    }

    public void setProtocolVersion(String protocolVersion) {
        if (this.sentProtocol == null) {
            this.sentProtocol = new Protocol();
        }
        this.sentProtocol.setProtocolVersion(protocolVersion);
    }

    public void setHost(Host host) {
        if (this.sentBy == null) {
            this.sentBy = new HostPort();
        }
        this.sentBy.setHost(host);
    }

    public void setSentProtocol(Protocol s) {
        this.sentProtocol = s;
    }

    public void setSentBy(HostPort s) {
        this.sentBy = s;
    }

    public void setComment(String c) {
        this.comment = c;
    }

    protected String encodeBody() {
        return this.encodeBody(new StringBuilder()).toString();
    }

    @Override
    protected StringBuilder encodeBody(StringBuilder buffer) {
        this.sentProtocol.encode(buffer);
        buffer.append(" ");
        this.sentBy.encode(buffer);
        if (!this.parameters.isEmpty()) {
            buffer.append(";");
            this.parameters.encode(buffer);
        }
        if (this.comment != null) {
            buffer.append(" ").append("(").append(this.comment).append(")");
        }
        return buffer;
    }

    public void setHost(String host) throws ParseException {
        if (this.sentBy == null) {
            this.sentBy = new HostPort();
        }
        try {
            Host h = new Host(host);
            this.sentBy.setHost(h);
        }
        catch (Exception e) {
            throw new NullPointerException(" host parameter is null");
        }
    }

    public String getHost() {
        if (this.sentBy == null) {
            return null;
        }
        Host host = this.sentBy.getHost();
        if (host == null) {
            return null;
        }
        return host.getHostname();
    }

    public void setPort(int port) throws InvalidArgumentException {
        if (port != -1 && (port < 1 || port > 65535)) {
            throw new InvalidArgumentException("Port value out of range -1, [1..65535]");
        }
        if (this.sentBy == null) {
            this.sentBy = new HostPort();
        }
        this.sentBy.setPort(port);
    }

    public void setRPort() {
        try {
            this.setParameter(RPORT, null);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
    }

    public int getPort() {
        if (this.sentBy == null) {
            return -1;
        }
        return this.sentBy.getPort();
    }

    public int getRPort() {
        String strRport = this.getParameter(RPORT);
        if (strRport != null && !strRport.equals("")) {
            return Integer.valueOf(strRport);
        }
        return -1;
    }

    public String getTransport() {
        if (this.sentProtocol == null) {
            return null;
        }
        return this.sentProtocol.getTransport();
    }

    public void setTransport(String transport) throws ParseException {
        if (transport == null) {
            throw new NullPointerException("JAIN-SIP Exception, Via, setTransport(), the transport parameter is null.");
        }
        if (this.sentProtocol == null) {
            this.sentProtocol = new Protocol();
        }
        this.sentProtocol.setTransport(transport);
    }

    public String getProtocol() {
        if (this.sentProtocol == null) {
            return null;
        }
        return this.sentProtocol.getProtocol();
    }

    public void setProtocol(String protocol) throws ParseException {
        if (protocol == null) {
            throw new NullPointerException("JAIN-SIP Exception, Via, setProtocol(), the protocol parameter is null.");
        }
        if (this.sentProtocol == null) {
            this.sentProtocol = new Protocol();
        }
        this.sentProtocol.setProtocol(protocol);
    }

    public int getTTL() {
        int ttl = this.getParameterAsInt(TTL);
        return ttl;
    }

    public void setTTL(int ttl) throws InvalidArgumentException {
        if (ttl < 0 && ttl != -1) {
            throw new InvalidArgumentException("JAIN-SIP Exception, Via, setTTL(), the ttl parameter is < 0");
        }
        this.setParameter(new NameValue(TTL, ttl));
    }

    public String getMAddr() {
        return this.getParameter(MADDR);
    }

    public void setMAddr(String mAddr) throws ParseException {
        if (mAddr == null) {
            throw new NullPointerException("JAIN-SIP Exception, Via, setMAddr(), the mAddr parameter is null.");
        }
        Host host = new Host();
        host.setAddress(mAddr);
        NameValue nameValue = new NameValue(MADDR, host);
        this.setParameter(nameValue);
    }

    public String getReceived() {
        return this.getParameter(RECEIVED);
    }

    public void setReceived(String received) throws ParseException {
        if (received == null) {
            throw new NullPointerException("JAIN-SIP Exception, Via, setReceived(), the received parameter is null.");
        }
        this.setParameter(RECEIVED, received);
    }

    public String getBranch() {
        return this.getParameter(BRANCH);
    }

    public void setBranch(String branch) throws ParseException {
        if (branch == null || branch.length() == 0) {
            throw new NullPointerException("JAIN-SIP Exception, Via, setBranch(), the branch parameter is null or length 0.");
        }
        this.setParameter(BRANCH, branch);
    }

    @Override
    public Object clone() {
        Via retval = (Via)super.clone();
        if (this.sentProtocol != null) {
            retval.sentProtocol = (Protocol)this.sentProtocol.clone();
        }
        if (this.sentBy != null) {
            retval.sentBy = (HostPort)this.sentBy.clone();
        }
        if (this.getRPort() != -1) {
            retval.setParameter(RPORT, this.getRPort());
        }
        return retval;
    }

    @Override
    public String getSentByField() {
        if (this.sentBy != null) {
            return this.sentBy.encode();
        }
        return null;
    }

    @Override
    public String getSentProtocolField() {
        if (this.sentProtocol != null) {
            return this.sentProtocol.encode();
        }
        return null;
    }
}

