/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.history;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import net.java.sip.communicator.impl.history.DBStructSerializer;
import net.java.sip.communicator.impl.history.HistoryImpl;
import net.java.sip.communicator.service.history.History;
import net.java.sip.communicator.service.history.HistoryID;
import net.java.sip.communicator.service.history.HistoryService;
import net.java.sip.communicator.service.history.records.HistoryRecordStructure;
import net.java.sip.communicator.util.Logger;
import net.java.sip.communicator.util.ServiceUtils;
import org.jitsi.service.configuration.ConfigurationService;
import org.jitsi.service.fileaccess.FileAccessService;
import org.jitsi.service.fileaccess.FileCategory;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class HistoryServiceImpl
implements HistoryService {
    public static final String DATA_DIRECTORY = "history_ver1.0";
    public static final String DATA_FILE = "dbstruct.dat";
    private static final Logger logger = Logger.getLogger(HistoryServiceImpl.class);
    private final Map<HistoryID, History> histories = new Hashtable<HistoryID, History>();
    private final FileAccessService fileAccessService;
    private final DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
    private final boolean cacheEnabled;
    private static final String[][] ESCAPE_SEQUENCES = new String[][]{{"&", "&_amp"}, {"/", "&_sl"}, {"\\\\", "&_bs"}, {":", "&_co"}, {"\\*", "&_as"}, {"\\?", "&_qm"}, {"\"", "&_pa"}, {"<", "&_lt"}, {">", "&_gt"}, {"\\|", "&_pp"}};

    public HistoryServiceImpl(BundleContext bundleContext) throws Exception {
        this.cacheEnabled = HistoryServiceImpl.getConfigurationService(bundleContext).getBoolean("net.java.sip.communicator.service.history.CACHE_ENABLED", false);
        this.fileAccessService = HistoryServiceImpl.getFileAccessService(bundleContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<HistoryID> getExistingIDs() {
        Vector<File> vect = new Vector<File>();
        try {
            String userSetDataDirectory = System.getProperty("HistoryServiceDirectory");
            File histDir = this.getFileAccessService().getPrivatePersistentDirectory(userSetDataDirectory == null ? DATA_DIRECTORY : userSetDataDirectory, FileCategory.PROFILE);
            this.findDatFiles(vect, histDir);
        }
        catch (Exception e) {
            logger.error((Object)"Error opening directory", (Throwable)e);
        }
        DBStructSerializer structParse = new DBStructSerializer(this);
        for (File f : vect) {
            Map<HistoryID, History> map = this.histories;
            synchronized (map) {
                try {
                    History hist = structParse.loadHistory(f);
                    if (!this.histories.containsKey(hist.getID())) {
                        this.histories.put(hist.getID(), hist);
                    }
                }
                catch (Exception e) {
                    logger.error((Object)("Could not load history from file: " + f.getAbsolutePath()), (Throwable)e);
                }
            }
        }
        Map<HistoryID, History> map = this.histories;
        synchronized (map) {
            return this.histories.keySet().iterator();
        }
    }

    @Override
    public boolean isHistoryExisting(HistoryID id) {
        return this.histories.containsKey(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public History getHistory(HistoryID id) throws IllegalArgumentException {
        History retVal = null;
        Map<HistoryID, History> map = this.histories;
        synchronized (map) {
            if (!this.histories.containsKey(id)) {
                throw new IllegalArgumentException("No history corresponds to the specified ID.");
            }
            retVal = this.histories.get(id);
        }
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public History createHistory(HistoryID id, HistoryRecordStructure recordStructure) throws IllegalArgumentException, IOException {
        History retVal = null;
        Map<HistoryID, History> map = this.histories;
        synchronized (map) {
            if (this.histories.containsKey(id)) {
                retVal = this.histories.get(id);
                retVal.setHistoryRecordsStructure(recordStructure);
            } else {
                File dir = this.createHistoryDirectories(id);
                HistoryImpl history = new HistoryImpl(id, dir, recordStructure, this);
                File dbDatFile = new File(dir, DATA_FILE);
                DBStructSerializer dbss = new DBStructSerializer(this);
                dbss.writeHistory(dbDatFile, history);
                this.histories.put(id, history);
                retVal = history;
            }
        }
        return retVal;
    }

    protected FileAccessService getFileAccessService() {
        return this.fileAccessService;
    }

    protected DocumentBuilder getDocumentBuilder() {
        return this.builder;
    }

    protected synchronized Document parse(File file) throws SAXException, IOException {
        FileInputStream fis = new FileInputStream(file);
        Document doc = this.builder.parse(fis);
        fis.close();
        return doc;
    }

    protected synchronized Document parse(ByteArrayInputStream in) throws SAXException, IOException {
        return this.builder.parse(in);
    }

    private void findDatFiles(List<File> vect, File directory) {
        File[] files = directory.listFiles();
        for (int i = 0; i < files.length; ++i) {
            if (files[i].isDirectory()) {
                this.findDatFiles(vect, files[i]);
                continue;
            }
            if (!DATA_FILE.equalsIgnoreCase(files[i].getName())) continue;
            vect.add(files[i]);
        }
    }

    private File createHistoryDirectories(HistoryID id) throws IOException {
        String[] idComponents = id.getID();
        this.escapeCharacters(idComponents);
        String userSetDataDirectory = System.getProperty("HistoryServiceDirectory");
        File dir = new File(userSetDataDirectory != null ? userSetDataDirectory : DATA_DIRECTORY);
        for (String s : idComponents) {
            dir = new File(dir, s);
        }
        File directory = null;
        try {
            directory = this.getFileAccessService().getPrivatePersistentDirectory(dir.toString(), FileCategory.PROFILE);
        }
        catch (Exception e) {
            IOException ioe = new IOException("Could not create history due to file system error");
            ioe.initCause(e);
            throw ioe;
        }
        if (!directory.exists() && !directory.mkdirs()) {
            throw new IOException("Could not create requested history service files:" + directory.getAbsolutePath());
        }
        return directory;
    }

    protected boolean isCacheEnabled() {
        return this.cacheEnabled;
    }

    @Override
    public void purgeLocallyStoredHistory(HistoryID id) throws IOException {
        File dir = this.createHistoryDirectories(id);
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Removing history directory " + dir));
        }
        this.deleteDirAndContent(dir);
        History history = this.histories.remove(id);
        if (history == null) {
            String[] ids = id.getID();
            Iterator<Map.Entry<HistoryID, History>> iter = this.histories.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry<HistoryID, History> entry = iter.next();
                if (!this.isSubHistory(ids, entry.getKey())) continue;
                iter.remove();
            }
        }
    }

    @Override
    public void purgeLocallyCachedHistories() {
        this.histories.clear();
    }

    private boolean isSubHistory(String[] parentIDs, HistoryID hid) {
        String[] hids = hid.getID();
        if (hids.length < parentIDs.length) {
            return false;
        }
        for (int i = 0; i < parentIDs.length; ++i) {
            if (parentIDs[i].equals(hids[i])) continue;
            return false;
        }
        return true;
    }

    private void deleteDirAndContent(File dir) throws IOException {
        if (!dir.isDirectory()) {
            return;
        }
        File[] content = dir.listFiles();
        for (int i = 0; i < content.length; ++i) {
            File tmp = content[i];
            if (tmp.isDirectory()) {
                this.deleteDirAndContent(tmp);
                continue;
            }
            tmp.delete();
        }
        dir.delete();
    }

    private void escapeCharacters(String[] ids) {
        for (int i = 0; i < ids.length; ++i) {
            String currId = ids[i];
            for (int j = 0; j < ESCAPE_SEQUENCES.length; ++j) {
                currId = currId.replaceAll(ESCAPE_SEQUENCES[j][0], ESCAPE_SEQUENCES[j][1]);
            }
            ids[i] = currId;
        }
    }

    private static ConfigurationService getConfigurationService(BundleContext bundleContext) {
        ServiceReference serviceReference = bundleContext.getServiceReference(ConfigurationService.class.getName());
        return serviceReference == null ? null : (ConfigurationService)bundleContext.getService(serviceReference);
    }

    private static FileAccessService getFileAccessService(BundleContext bundleContext) {
        return (FileAccessService)ServiceUtils.getService((BundleContext)bundleContext, FileAccessService.class);
    }

    @Override
    public void moveHistory(HistoryID oldId, HistoryID newId) throws IOException {
        if (!this.isHistoryCreated(oldId)) {
            return;
        }
        File oldDir = this.createHistoryDirectories(oldId);
        File newDir = this.getDirForHistory(newId);
        newDir.getParentFile().mkdirs();
        if (!oldDir.renameTo(newDir)) {
            if (logger.isInfoEnabled()) {
                logger.info((Object)"Cannot move history!");
            }
            throw new IOException("Cannot move history!");
        }
        this.histories.remove(oldId);
    }

    private File getDirForHistory(HistoryID id) {
        String[] dirNames = id.getID();
        StringBuffer dirName = new StringBuffer();
        for (int i = 0; i < dirNames.length; ++i) {
            if (i > 0) {
                dirName.append(File.separatorChar);
            }
            dirName.append(dirNames[i]);
        }
        File histDir = null;
        try {
            String userSetDataDirectory = System.getProperty("HistoryServiceDirectory");
            histDir = this.getFileAccessService().getPrivatePersistentDirectory(userSetDataDirectory == null ? DATA_DIRECTORY : userSetDataDirectory, FileCategory.PROFILE);
        }
        catch (Exception e) {
            logger.error((Object)"Error opening directory", (Throwable)e);
        }
        return new File(histDir, dirName.toString());
    }

    @Override
    public boolean isHistoryCreated(HistoryID id) {
        return this.getDirForHistory(id).exists();
    }

    @Override
    public List<HistoryID> getExistingHistories(String[] rawid) throws IllegalArgumentException {
        File histDir = null;
        try {
            histDir = this.getFileAccessService().getPrivatePersistentDirectory(DATA_DIRECTORY, FileCategory.PROFILE);
        }
        catch (Exception e) {
            logger.error((Object)"Error opening directory", (Throwable)e);
        }
        if (histDir == null || !histDir.exists()) {
            return new ArrayList<HistoryID>();
        }
        StringBuilder folderPath = new StringBuilder();
        for (String id : rawid) {
            folderPath.append(id).append(File.separator);
        }
        File srcFolder = new File(histDir, folderPath.toString());
        if (!srcFolder.exists()) {
            return new ArrayList<HistoryID>();
        }
        TreeMap<File, HistoryID> recentFiles = new TreeMap<File, HistoryID>(new Comparator<File>(){

            @Override
            public int compare(File o1, File o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        this.getExistingFiles(srcFolder, Arrays.asList(rawid), recentFiles);
        ArrayList<HistoryID> result = new ArrayList<HistoryID>();
        for (Map.Entry<File, HistoryID> entry : recentFiles.entrySet()) {
            HistoryID hid = entry.getValue();
            if (result.contains(hid)) continue;
            result.add(hid);
        }
        return result;
    }

    private void getExistingFiles(File sourceFolder, List<String> rawID, Map<File, HistoryID> res) {
        for (File f : sourceFolder.listFiles()) {
            if (f.isDirectory()) {
                ArrayList<String> newRawID = new ArrayList<String>(rawID);
                newRawID.add(f.getName());
                this.getExistingFiles(f, newRawID, res);
                continue;
            }
            if (f.getName().equals(DATA_FILE)) continue;
            res.put(f, HistoryID.createFromRawStrings(rawID.toArray(new String[rawID.size()])));
        }
    }
}

