/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.sip;

import gov.nist.javax.sip.address.SipUri;
import java.net.URI;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.sip.address.Address;
import javax.sip.address.SipURI;
import net.java.sip.communicator.impl.protocol.sip.ContactGroupSipImpl;
import net.java.sip.communicator.impl.protocol.sip.ContactSipImpl;
import net.java.sip.communicator.impl.protocol.sip.OperationSetPresenceSipImpl;
import net.java.sip.communicator.impl.protocol.sip.ProtocolProviderServiceSipImpl;
import net.java.sip.communicator.impl.protocol.sip.ServerStoredContactList;
import net.java.sip.communicator.impl.protocol.sip.SipAccountIDImpl;
import net.java.sip.communicator.impl.protocol.sip.SipActivator;
import net.java.sip.communicator.impl.protocol.sip.xcap.XCapClient;
import net.java.sip.communicator.impl.protocol.sip.xcap.XCapClientImpl;
import net.java.sip.communicator.impl.protocol.sip.xcap.XCapException;
import net.java.sip.communicator.impl.protocol.sip.xcap.model.commonpolicy.ActionsType;
import net.java.sip.communicator.impl.protocol.sip.xcap.model.commonpolicy.ConditionsType;
import net.java.sip.communicator.impl.protocol.sip.xcap.model.commonpolicy.IdentityType;
import net.java.sip.communicator.impl.protocol.sip.xcap.model.commonpolicy.OneType;
import net.java.sip.communicator.impl.protocol.sip.xcap.model.commonpolicy.RuleType;
import net.java.sip.communicator.impl.protocol.sip.xcap.model.commonpolicy.RulesetType;
import net.java.sip.communicator.impl.protocol.sip.xcap.model.commonpolicy.TransformationsType;
import net.java.sip.communicator.impl.protocol.sip.xcap.model.prescontent.ContentType;
import net.java.sip.communicator.impl.protocol.sip.xcap.model.prescontent.DataType;
import net.java.sip.communicator.impl.protocol.sip.xcap.model.prescontent.EncodingType;
import net.java.sip.communicator.impl.protocol.sip.xcap.model.prescontent.MimeType;
import net.java.sip.communicator.impl.protocol.sip.xcap.model.presrules.ProvideDevicePermissionType;
import net.java.sip.communicator.impl.protocol.sip.xcap.model.presrules.ProvidePersonPermissionType;
import net.java.sip.communicator.impl.protocol.sip.xcap.model.presrules.ProvideServicePermissionType;
import net.java.sip.communicator.impl.protocol.sip.xcap.model.presrules.SubHandlingType;
import net.java.sip.communicator.impl.protocol.sip.xcap.model.resourcelists.EntryType;
import net.java.sip.communicator.impl.protocol.sip.xcap.model.resourcelists.ListType;
import net.java.sip.communicator.impl.protocol.sip.xcap.model.resourcelists.ResourceListsType;
import net.java.sip.communicator.service.protocol.AccountID;
import net.java.sip.communicator.service.protocol.Contact;
import net.java.sip.communicator.service.protocol.ContactGroup;
import net.java.sip.communicator.service.protocol.OperationFailedException;
import net.java.sip.communicator.service.protocol.ServerStoredDetails;
import net.java.sip.communicator.util.Base64;
import net.java.sip.communicator.util.Logger;
import org.jitsi.util.xml.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ServerStoredContactListSipImpl
extends ServerStoredContactList {
    private static final Logger logger = Logger.getLogger(ServerStoredContactListSipImpl.class);
    public static final String PRES_CONTENT_IMAGE_NAME = "sip_communicator";
    private static final String DEFAULT_WHITE_RULE_ID = "presence_allow";
    private static final String DEFAULT_BLOCK_RULE_ID = "presence_block";
    private static final String DEFAULT_POLITE_BLOCK_RULE_ID = "presence_polite_block";
    private static final String CONTACT_TYPE_ELEMENT_NAME = "contact-type";
    private static final String CONTACT_TYPE_NS = "http://jitsi.org/contact-type";
    private final XCapClient xCapClient = new XCapClientImpl();
    private RulesetType presRules;

    ServerStoredContactListSipImpl(ProtocolProviderServiceSipImpl sipProvider, OperationSetPresenceSipImpl parentOperationSet) {
        super(sipProvider, parentOperationSet);
    }

    @Override
    public synchronized ContactSipImpl createContact(ContactGroupSipImpl parentGroup, String contactId, String displayName, boolean persistent, String contactType) throws OperationFailedException {
        Address contactAddress;
        if (parentGroup == null) {
            throw new IllegalArgumentException("Parent group cannot be null");
        }
        if (contactId == null || contactId.trim().length() == 0) {
            throw new IllegalArgumentException("Contact identifier cannot be null or empty");
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)String.format("createContact %1s, %2s, %3s", parentGroup.getGroupName(), contactId, persistent));
        }
        if (parentGroup.getContact(contactId) != null) {
            throw new OperationFailedException("Contact " + contactId + " already exists.", 5);
        }
        try {
            contactAddress = this.sipProvider.parseAddressString(contactId);
        }
        catch (ParseException ex) {
            throw new IllegalArgumentException(contactId + " is not a valid string.", ex);
        }
        ContactSipImpl newContact = this.parentOperationSet.resolveContactID(contactAddress.getURI().toString());
        if (newContact != null && !newContact.isPersistent() && !newContact.getParentContactGroup().isPersistent()) {
            ContactGroupSipImpl oldParentGroup = (ContactGroupSipImpl)newContact.getParentContactGroup();
            oldParentGroup.removeContact(newContact);
            this.fireContactRemoved(oldParentGroup, newContact);
        }
        newContact = new ContactSipImpl(contactAddress, this.sipProvider);
        newContact.setPersistent(persistent);
        if (displayName == null || displayName.length() <= 0) {
            displayName = ((SipURI)contactAddress.getURI()).getUser();
        }
        newContact.setDisplayName(displayName);
        if (contactType != null) {
            this.setContactType((Contact)newContact, contactType);
        }
        parentGroup.addContact(newContact);
        if (newContact.isPersistent()) {
            try {
                this.updateResourceLists();
            }
            catch (XCapException e) {
                parentGroup.removeContact(newContact);
                throw new OperationFailedException("Error while creating XCAP contact", 2, (Throwable)e);
            }
            newContact.setResolved(true);
            if (this.xCapClient.isConnected() && this.xCapClient.isResourceListsSupported()) {
                newContact.setXCapResolved(true);
                try {
                    if (!this.isContactInWhiteRule(contactId) && this.addContactToWhiteList(newContact)) {
                        this.updatePresRules();
                    }
                }
                catch (XCapException e) {
                    logger.error((Object)"Cannot add contact to white list while creating it", (Throwable)e);
                }
            }
        }
        this.fireContactAdded(parentGroup, newContact);
        return newContact;
    }

    @Override
    public synchronized void removeContact(ContactSipImpl contact) throws OperationFailedException {
        if (contact == null) {
            throw new IllegalArgumentException("Removing contact cannot be null");
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("removeContact " + contact.getUri()));
        }
        ContactGroupSipImpl parentGroup = (ContactGroupSipImpl)contact.getParentContactGroup();
        parentGroup.removeContact(contact);
        if (contact.isPersistent()) {
            try {
                boolean updateRules = this.removeContactFromWhiteList(contact);
                updateRules = this.removeContactFromBlockList(contact) || updateRules;
                boolean bl = updateRules = this.removeContactFromPoliteBlockList(contact) || updateRules;
                if (updateRules) {
                    this.updatePresRules();
                }
            }
            catch (XCapException e) {
                logger.error((Object)"Error while removing XCAP contact", (Throwable)e);
            }
            try {
                this.updateResourceLists();
            }
            catch (XCapException e) {
                parentGroup.removeContact(contact);
                throw new OperationFailedException("Error while removing XCAP contact", 2, (Throwable)e);
            }
        }
        this.fireContactRemoved(parentGroup, contact);
    }

    @Override
    public void moveContactToGroup(ContactSipImpl contact, ContactGroupSipImpl newParentGroup) throws OperationFailedException {
        if (contact == null) {
            throw new IllegalArgumentException("Moving contact cannot be null");
        }
        if (newParentGroup == null) {
            throw new IllegalArgumentException("New contact's parent group  be null");
        }
        if (newParentGroup.getContact(contact.getUri()) != null) {
            throw new OperationFailedException("Contact " + contact.getUri() + " already exists.", 5);
        }
        ContactGroupSipImpl oldParentGroup = (ContactGroupSipImpl)contact.getParentContactGroup();
        oldParentGroup.removeContact(contact);
        boolean wasContactPersistent = contact.isPersistent();
        if (newParentGroup.isPersistent()) {
            contact.setPersistent(true);
        }
        newParentGroup.addContact(contact);
        if (contact.isPersistent()) {
            try {
                this.updateResourceLists();
            }
            catch (XCapException e) {
                newParentGroup.removeContact(contact);
                oldParentGroup.addContact(contact);
                throw new OperationFailedException("Error while moving XCAP contact", 2, (Throwable)e);
            }
            if (!wasContactPersistent) {
                contact.setResolved(true);
                if (this.xCapClient.isConnected() && this.xCapClient.isResourceListsSupported()) {
                    contact.setXCapResolved(true);
                    try {
                        if (!this.isContactInWhiteRule(contact.getAddress()) && this.addContactToWhiteList(contact)) {
                            this.updatePresRules();
                        }
                    }
                    catch (XCapException e) {
                        logger.error((Object)"Cannot add contact to white list while creating it", (Throwable)e);
                    }
                }
            }
        }
        this.fireContactMoved(oldParentGroup, newParentGroup, contact);
    }

    @Override
    public synchronized void renameContact(ContactSipImpl contact, String newName) {
        if (contact == null) {
            throw new IllegalArgumentException("Renaming contact cannot be null");
        }
        String oldName = contact.getDisplayName();
        if (oldName.equals(newName)) {
            return;
        }
        contact.setDisplayName(newName);
        if (contact.isPersistent()) {
            try {
                this.updateResourceLists();
            }
            catch (XCapException e) {
                contact.setDisplayName(oldName);
                throw new IllegalStateException("Error while renaming XCAP group", e);
            }
        }
        this.parentOperationSet.fireContactPropertyChangeEvent("DisplayName", (Contact)contact, oldName, newName);
    }

    @Override
    public synchronized ContactGroupSipImpl createGroup(ContactGroupSipImpl parentGroup, String groupName, boolean persistent) throws OperationFailedException {
        if (parentGroup == null) {
            throw new IllegalArgumentException("Parent group cannot be null");
        }
        if (groupName == null || groupName.length() == 0) {
            throw new IllegalArgumentException("Creating group name cannot be null or empry");
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("createGroup " + parentGroup.getGroupName() + "," + groupName + "," + persistent));
        }
        if (parentGroup.getGroup(groupName) != null) {
            throw new OperationFailedException(String.format("Group %1s already exists.", groupName), 6);
        }
        ContactGroupSipImpl subGroup = new ContactGroupSipImpl(groupName, this.sipProvider);
        subGroup.setPersistent(persistent);
        parentGroup.addSubgroup(subGroup);
        if (subGroup.isPersistent()) {
            try {
                this.updateResourceLists();
            }
            catch (XCapException e) {
                parentGroup.removeSubGroup(subGroup);
                throw new OperationFailedException("Error while creating XCAP group", 2, (Throwable)e);
            }
            subGroup.setResolved(true);
        }
        this.fireGroupEvent(subGroup, 1);
        return subGroup;
    }

    @Override
    public synchronized void removeGroup(ContactGroupSipImpl group) {
        if (group == null) {
            throw new IllegalArgumentException("Removing group cannot be null");
        }
        if (this.rootGroup.equals(group)) {
            throw new IllegalArgumentException("Root group cannot be deleted");
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("removeGroup " + group.getGroupName()));
        }
        ContactGroupSipImpl parentGroup = (ContactGroupSipImpl)group.getParentContactGroup();
        parentGroup.removeSubGroup(group);
        if (group.isPersistent()) {
            try {
                this.updateResourceLists();
                Iterator<Contact> iter = group.contacts();
                boolean updateRules = false;
                while (iter.hasNext()) {
                    ContactSipImpl c = (ContactSipImpl)iter.next();
                    updateRules = this.removeContactFromWhiteList(c) || updateRules;
                    updateRules = this.removeContactFromBlockList(c) || updateRules;
                    updateRules = this.removeContactFromPoliteBlockList(c) || updateRules;
                }
                if (updateRules) {
                    this.updatePresRules();
                }
            }
            catch (XCapException e) {
                parentGroup.addSubgroup(group);
                throw new IllegalStateException("Error while removing XCAP group", e);
            }
        }
        this.fireGroupEvent(group, 2);
    }

    @Override
    public synchronized void renameGroup(ContactGroupSipImpl group, String newName) {
        if (group == null) {
            throw new IllegalArgumentException("Renaming group cannot be null");
        }
        if (this.rootGroup.equals(group)) {
            throw new IllegalArgumentException("Root group cannot be renamed");
        }
        String oldName = group.getGroupName();
        if (oldName.equals(newName)) {
            return;
        }
        ContactGroupSipImpl parentGroup = (ContactGroupSipImpl)group.getParentContactGroup();
        if (parentGroup.getGroup(newName) != null) {
            throw new IllegalStateException(String.format("Group with name %1s already exists", newName));
        }
        group.setName(newName);
        if (group.isPersistent()) {
            try {
                this.updateResourceLists();
            }
            catch (XCapException e) {
                group.setName(oldName);
                throw new IllegalStateException("Error while renaming XCAP group", e);
            }
        }
        this.fireGroupEvent(group, 3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public synchronized void init() {
        try {
            URI uri;
            String password;
            SipAccountIDImpl accountID = (SipAccountIDImpl)this.sipProvider.getAccountID();
            if (!accountID.isXCapEnable()) {
                return;
            }
            String serverUri = accountID.getClistOptionServerUri();
            Object username = accountID.getAccountPropertyString("USER_ID");
            Address address = this.sipProvider.parseAddressString((String)username);
            if (accountID.isClistOptionUseSipCredentials()) {
                username = ((SipUri)address.getURI()).getUser();
                password = SipActivator.getProtocolProviderFactory().loadPassword((AccountID)accountID);
            } else {
                username = accountID.getClistOptionUser();
                password = accountID.getClistOptionPassword();
            }
            if (serverUri != null && (uri = new URI(serverUri.trim())).getHost() != null && uri.getPath() != null) {
                this.xCapClient.connect(uri, address, (String)username, password);
            }
        }
        catch (Throwable ex) {
            logger.error((Object)"Error while connecting to XCAP server. Contact list won't be saved", ex);
        }
        try {
            if (!this.xCapClient.isConnected() || !this.xCapClient.isResourceListsSupported()) {
                return;
            }
            ResourceListsType resourceLists = this.xCapClient.getResourceLists();
            ListType serverRootList = new ListType();
            for (ListType listType : resourceLists.getList()) {
                if (listType.getName().equals("RootGroup")) {
                    serverRootList.setName("RootGroup");
                    serverRootList.setDisplayName(listType.getDisplayName());
                    serverRootList.getEntries().addAll(listType.getEntries());
                    serverRootList.getEntryRefs().addAll(listType.getEntryRefs());
                    serverRootList.getExternals().addAll(listType.getExternals());
                    serverRootList.setAny(listType.getAny());
                    serverRootList.setAnyAttributes(listType.getAnyAttributes());
                    continue;
                }
                serverRootList.getLists().add(listType);
            }
            boolean updateResourceLists = false;
            this.resolveContactGroup(this.rootGroup, serverRootList, false);
            for (ContactSipImpl contact : this.getAllContacts(this.rootGroup)) {
                if (contact.isResolved() || !contact.isPersistent()) continue;
                contact.setResolved(true);
                ContactGroupSipImpl parentGroup = (ContactGroupSipImpl)contact.getParentContactGroup();
                if (contact.isXCapResolved()) {
                    parentGroup.removeContact(contact);
                    this.fireContactRemoved(parentGroup, contact);
                    continue;
                }
                updateResourceLists = true;
                String oldValue = contact.getPersistentData();
                contact.setXCapResolved(true);
                this.fireContactResolved(parentGroup, contact);
                this.parentOperationSet.fireContactPropertyChangeEvent("PersistentData", (Contact)contact, oldValue, contact.getPersistentData());
            }
            for (ContactGroupSipImpl group : this.getAllGroups(this.rootGroup)) {
                if (group.isResolved() || !group.isPersistent()) continue;
                updateResourceLists = true;
                group.setResolved(true);
                this.fireGroupEvent(group, 4);
            }
            if (updateResourceLists) {
                this.updateResourceLists();
            }
            if (this.xCapClient.isPresRulesSupported()) {
                RuleType ruleType = this.getRule(SubHandlingType.Allow);
                boolean updateRules = false;
                if (ruleType == null) {
                    RuleType ruleType2 = ServerStoredContactListSipImpl.createWhiteRule();
                    this.presRules.getRules().add(ruleType2);
                }
                List<ContactSipImpl> uniqueContacts = this.getUniqueContacts(this.rootGroup);
                for (ContactSipImpl contact : uniqueContacts) {
                    void var4_14;
                    if (!contact.isPersistent() || ServerStoredContactListSipImpl.isContactInRule((RuleType)var4_14, contact.getUri())) continue;
                    ServerStoredContactListSipImpl.addContactToRule((RuleType)var4_14, contact);
                    updateRules = true;
                }
                if (updateRules) {
                    this.updatePresRules();
                }
            }
        }
        catch (XCapException e) {
            logger.error((Object)"Error initializing serverside list!", (Throwable)e);
            this.xCapClient.disconnect();
        }
    }

    @Override
    public URI getImageUri() {
        if (this.xCapClient.isConnected() && this.xCapClient.isPresContentSupported()) {
            return this.xCapClient.getPresContentImageUri(PRES_CONTENT_IMAGE_NAME);
        }
        return null;
    }

    @Override
    public byte[] getImage(URI imageUri) {
        block3: {
            if (this.xCapClient.isConnected()) {
                try {
                    return this.xCapClient.getImage(imageUri);
                }
                catch (XCapException e) {
                    String errorMessage = String.format("Error while getting icon %1s", imageUri);
                    logger.warn((Object)errorMessage);
                    if (!logger.isDebugEnabled()) break block3;
                    logger.debug((Object)errorMessage, (Throwable)e);
                }
            }
        }
        return null;
    }

    @Override
    public synchronized void destroy() {
        this.xCapClient.disconnect();
        List<ContactSipImpl> contacts = this.getAllContacts(this.rootGroup);
        for (ContactSipImpl contact : contacts) {
            contact.setResolved(false);
        }
        this.presRules = null;
    }

    private static RuleType createWhiteRule() {
        RuleType whiteList = new RuleType();
        whiteList.setId(DEFAULT_WHITE_RULE_ID);
        ConditionsType conditions = new ConditionsType();
        whiteList.setConditions(conditions);
        ActionsType actions = new ActionsType();
        actions.setSubHandling(SubHandlingType.Allow);
        whiteList.setActions(actions);
        TransformationsType transformations = new TransformationsType();
        ProvideServicePermissionType servicePermission = new ProvideServicePermissionType();
        servicePermission.setAllServices(new ProvideServicePermissionType.AllServicesType());
        transformations.setServicePermission(servicePermission);
        ProvidePersonPermissionType personPermission = new ProvidePersonPermissionType();
        personPermission.setAllPersons(new ProvidePersonPermissionType.AllPersonsType());
        transformations.setPersonPermission(personPermission);
        ProvideDevicePermissionType devicePermission = new ProvideDevicePermissionType();
        devicePermission.setAllDevices(new ProvideDevicePermissionType.AllDevicesType());
        transformations.setDevicePermission(devicePermission);
        whiteList.setTransformations(transformations);
        return whiteList;
    }

    private static RuleType createBlockRule() {
        RuleType blackList = new RuleType();
        blackList.setId(DEFAULT_BLOCK_RULE_ID);
        ConditionsType conditions = new ConditionsType();
        blackList.setConditions(conditions);
        ActionsType actions = new ActionsType();
        actions.setSubHandling(SubHandlingType.Block);
        blackList.setActions(actions);
        TransformationsType transformations = new TransformationsType();
        blackList.setTransformations(transformations);
        return blackList;
    }

    private static RuleType createPoliteBlockRule() {
        RuleType blackList = new RuleType();
        blackList.setId(DEFAULT_POLITE_BLOCK_RULE_ID);
        ConditionsType conditions = new ConditionsType();
        blackList.setConditions(conditions);
        ActionsType actions = new ActionsType();
        actions.setSubHandling(SubHandlingType.PoliteBlock);
        blackList.setActions(actions);
        TransformationsType transformations = new TransformationsType();
        blackList.setTransformations(transformations);
        return blackList;
    }

    private RuleType getRule(SubHandlingType type) throws XCapException {
        if (this.presRules == null) {
            if (!this.xCapClient.isConnected() || !this.xCapClient.isResourceListsSupported()) {
                return null;
            }
            this.presRules = this.xCapClient.getPresRules();
        }
        for (RuleType rule : this.presRules.getRules()) {
            SubHandlingType currType = rule.getActions().getSubHandling();
            if (currType == null || !currType.equals((Object)type)) continue;
            return rule;
        }
        return null;
    }

    private static boolean isContactInRule(RuleType rule, String contactUri) {
        if (rule.getConditions().getIdentities().size() == 0) {
            return false;
        }
        IdentityType identity = rule.getConditions().getIdentities().get(0);
        for (OneType one : identity.getOneList()) {
            if (!one.getId().equals(contactUri)) continue;
            return true;
        }
        return false;
    }

    private static boolean addContactToRule(RuleType rule, ContactSipImpl contact) {
        IdentityType identity;
        if (ServerStoredContactListSipImpl.isContactInRule(rule, contact.getUri())) {
            return false;
        }
        if (rule.getConditions().getIdentities().size() == 0) {
            identity = new IdentityType();
            rule.getConditions().getIdentities().add(identity);
        } else {
            identity = rule.getConditions().getIdentities().get(0);
        }
        OneType one = new OneType();
        one.setId(contact.getUri());
        identity.getOneList().add(one);
        return true;
    }

    private static boolean removeContactFromRule(RuleType rule, ContactSipImpl contact) {
        if (rule.getConditions().getIdentities().size() == 0) {
            return false;
        }
        IdentityType identity = rule.getConditions().getIdentities().get(0);
        OneType contactOne = null;
        for (OneType one : identity.getOneList()) {
            if (!contact.getUri().equals(one.getId())) continue;
            contactOne = one;
            break;
        }
        if (contactOne != null) {
            identity.getOneList().remove(contactOne);
        }
        if (identity.getOneList().size() == 0) {
            rule.getConditions().getIdentities().remove(identity);
            rule.getConditions().getIdentities().remove(identity);
        }
        return true;
    }

    boolean addContactToWhiteList(ContactSipImpl contact) throws XCapException {
        RuleType whiteRule = this.getRule(SubHandlingType.Allow);
        RuleType blockRule = this.getRule(SubHandlingType.Block);
        RuleType politeBlockRule = this.getRule(SubHandlingType.PoliteBlock);
        if (whiteRule == null) {
            whiteRule = ServerStoredContactListSipImpl.createWhiteRule();
            this.presRules.getRules().add(whiteRule);
        }
        boolean updateRule = ServerStoredContactListSipImpl.addContactToRule(whiteRule, contact);
        if (blockRule != null) {
            boolean bl = updateRule = ServerStoredContactListSipImpl.removeContactFromRule(blockRule, contact) || updateRule;
        }
        if (politeBlockRule != null) {
            updateRule = ServerStoredContactListSipImpl.removeContactFromRule(politeBlockRule, contact) || updateRule;
        }
        return updateRule;
    }

    boolean addContactToBlockList(ContactSipImpl contact) throws XCapException {
        RuleType whiteRule = this.getRule(SubHandlingType.Allow);
        RuleType blockRule = this.getRule(SubHandlingType.Block);
        RuleType politeBlockRule = this.getRule(SubHandlingType.PoliteBlock);
        if (blockRule == null) {
            blockRule = ServerStoredContactListSipImpl.createBlockRule();
            this.presRules.getRules().add(blockRule);
        }
        boolean updateRule = ServerStoredContactListSipImpl.addContactToRule(blockRule, contact);
        if (whiteRule != null) {
            boolean bl = updateRule = ServerStoredContactListSipImpl.removeContactFromRule(whiteRule, contact) || updateRule;
        }
        if (politeBlockRule != null) {
            updateRule = ServerStoredContactListSipImpl.removeContactFromRule(politeBlockRule, contact) || updateRule;
        }
        return updateRule;
    }

    boolean addContactToPoliteBlockList(ContactSipImpl contact) throws XCapException {
        RuleType whiteRule = this.getRule(SubHandlingType.Allow);
        RuleType blockRule = this.getRule(SubHandlingType.Block);
        RuleType politeBlockRule = this.getRule(SubHandlingType.PoliteBlock);
        if (politeBlockRule == null) {
            politeBlockRule = ServerStoredContactListSipImpl.createPoliteBlockRule();
            this.presRules.getRules().add(politeBlockRule);
        }
        boolean updateRule = ServerStoredContactListSipImpl.addContactToRule(politeBlockRule, contact);
        if (whiteRule != null) {
            boolean bl = updateRule = ServerStoredContactListSipImpl.removeContactFromRule(whiteRule, contact) || updateRule;
        }
        if (blockRule != null) {
            updateRule = ServerStoredContactListSipImpl.removeContactFromRule(blockRule, contact) || updateRule;
        }
        return updateRule;
    }

    private boolean isContactInWhiteRule(String contactUri) throws XCapException {
        RuleType whiteRule = this.getRule(SubHandlingType.Allow);
        if (whiteRule == null) {
            return false;
        }
        return ServerStoredContactListSipImpl.isContactInRule(whiteRule, contactUri);
    }

    boolean removeContactFromWhiteList(ContactSipImpl contact) throws XCapException {
        RuleType whiteRule = this.getRule(SubHandlingType.Allow);
        if (whiteRule != null) {
            return ServerStoredContactListSipImpl.removeContactFromRule(whiteRule, contact);
        }
        return false;
    }

    boolean removeContactFromBlockList(ContactSipImpl contact) throws XCapException {
        RuleType blockRule = this.getRule(SubHandlingType.Block);
        if (blockRule != null) {
            return ServerStoredContactListSipImpl.removeContactFromRule(blockRule, contact);
        }
        return false;
    }

    boolean removeContactFromPoliteBlockList(ContactSipImpl contact) throws XCapException {
        RuleType blockRule = this.getRule(SubHandlingType.PoliteBlock);
        if (blockRule != null) {
            return ServerStoredContactListSipImpl.removeContactFromRule(blockRule, contact);
        }
        return false;
    }

    private void resolveContactGroup(ContactGroupSipImpl clientGroup, ListType serverGroup, boolean deleteUnresolved) {
        ArrayList<ContactGroupSipImpl> unresolvedGroups = new ArrayList<ContactGroupSipImpl>();
        Iterator<ContactGroup> groupIterator = clientGroup.subgroups();
        while (groupIterator.hasNext()) {
            ContactGroupSipImpl group = (ContactGroupSipImpl)groupIterator.next();
            unresolvedGroups.add(group);
        }
        ArrayList<ContactSipImpl> unresolvedContacts = new ArrayList<ContactSipImpl>();
        Iterator<Contact> contactIterator = clientGroup.contacts();
        while (contactIterator.hasNext()) {
            ContactSipImpl contact = (ContactSipImpl)contactIterator.next();
            unresolvedContacts.add(contact);
        }
        for (ListType serverList : serverGroup.getLists()) {
            ContactGroupSipImpl newGroup = (ContactGroupSipImpl)clientGroup.getGroup(serverList.getName());
            if (newGroup == null) {
                newGroup = new ContactGroupSipImpl(serverList.getName(), this.sipProvider);
                newGroup.setOtherAttributes(serverList.getAnyAttributes());
                newGroup.setAny(serverList.getAny());
                newGroup.setResolved(true);
                clientGroup.addSubgroup(newGroup);
                this.fireGroupEvent(newGroup, 1);
                this.resolveContactGroup(newGroup, serverList, deleteUnresolved);
                continue;
            }
            newGroup.setResolved(true);
            newGroup.setOtherAttributes(serverList.getAnyAttributes());
            newGroup.setAny(serverList.getAny());
            unresolvedGroups.remove(newGroup);
            this.fireGroupEvent(newGroup, 4);
            this.resolveContactGroup(newGroup, serverList, deleteUnresolved);
        }
        for (EntryType serverEntry : serverGroup.getEntries()) {
            ContactSipImpl newContact = (ContactSipImpl)clientGroup.getContact(serverEntry.getUri());
            if (newContact == null) {
                Address sipAddress;
                try {
                    sipAddress = this.sipProvider.parseAddressString(serverEntry.getUri());
                }
                catch (ParseException e) {
                    logger.error((Object)e);
                    continue;
                }
                newContact = new ContactSipImpl(sipAddress, this.sipProvider);
                newContact.setDisplayName(serverEntry.getDisplayName());
                newContact.setOtherAttributes(serverEntry.getAnyAttributes());
                newContact.setAny(serverEntry.getAny());
                newContact.setResolved(true);
                newContact.setXCapResolved(true);
                clientGroup.addContact(newContact);
                this.fireContactAdded(clientGroup, newContact);
                continue;
            }
            newContact.setDisplayName(serverEntry.getDisplayName());
            newContact.setOtherAttributes(serverEntry.getAnyAttributes());
            newContact.setAny(serverEntry.getAny());
            newContact.setResolved(true);
            newContact.setXCapResolved(true);
            unresolvedContacts.remove((Object)newContact);
            this.fireContactResolved(clientGroup, newContact);
        }
        clientGroup.getList().getExternals().addAll(serverGroup.getExternals());
        clientGroup.getList().getEntryRefs().addAll(serverGroup.getEntryRefs());
        clientGroup.getList().getAny().addAll(serverGroup.getAny());
        if (deleteUnresolved) {
            for (ContactSipImpl unresolvedContact : unresolvedContacts) {
                if (!unresolvedContact.isPersistent()) continue;
                unresolvedContact.setResolved(true);
                unresolvedContact.setXCapResolved(true);
                clientGroup.removeContact(unresolvedContact);
                this.fireContactRemoved(clientGroup, unresolvedContact);
            }
        }
        if (deleteUnresolved) {
            for (ContactGroupSipImpl unresolvedGroup : unresolvedGroups) {
                if (!unresolvedGroup.isPersistent()) continue;
                unresolvedGroup.setResolved(true);
                clientGroup.removeSubGroup(unresolvedGroup);
                this.fireGroupEvent(unresolvedGroup, 2);
            }
        }
    }

    synchronized void updateResourceLists() throws XCapException {
        if (!this.xCapClient.isConnected() || !this.xCapClient.isResourceListsSupported()) {
            return;
        }
        ResourceListsType resourceLists = new ResourceListsType();
        for (ListType list : this.rootGroup.getList().getLists()) {
            resourceLists.getList().add(list);
        }
        ListType serverRootList = new ListType();
        serverRootList.setName("RootGroup");
        serverRootList.setDisplayName(this.rootGroup.getList().getDisplayName());
        serverRootList.getEntries().addAll(this.rootGroup.getList().getEntries());
        serverRootList.getEntryRefs().addAll(this.rootGroup.getList().getEntryRefs());
        serverRootList.getExternals().addAll(this.rootGroup.getList().getExternals());
        serverRootList.setAny(this.rootGroup.getList().getAny());
        serverRootList.setAnyAttributes(this.rootGroup.getList().getAnyAttributes());
        resourceLists.getList().add(serverRootList);
        this.xCapClient.putResourceLists(resourceLists);
    }

    synchronized void updatePresRules() throws XCapException {
        if (!this.xCapClient.isConnected() || !this.xCapClient.isPresRulesSupported()) {
            return;
        }
        this.xCapClient.putPresRules(this.presRules);
    }

    @Override
    public void authorizationAccepted(ContactSipImpl contact) {
        try {
            if (this.addContactToWhiteList(contact)) {
                this.updatePresRules();
            }
        }
        catch (XCapException ex) {
            logger.error((Object)"Cannot save presence rules!", (Throwable)ex);
        }
    }

    @Override
    public void authorizationRejected(ContactSipImpl contact) {
        try {
            if (this.addContactToBlockList(contact)) {
                this.updatePresRules();
            }
        }
        catch (XCapException ex) {
            logger.error((Object)"Cannot save presence rules!", (Throwable)ex);
        }
    }

    @Override
    public void authorizationIgnored(ContactSipImpl contact) {
        try {
            if (this.addContactToPoliteBlockList(contact)) {
                this.updatePresRules();
            }
        }
        catch (XCapException ex) {
            logger.error((Object)"Cannot save presence rules!", (Throwable)ex);
        }
    }

    @Override
    public ServerStoredDetails.ImageDetail getAccountImage() throws OperationFailedException {
        ServerStoredDetails.ImageDetail imageDetail;
        try {
            ContentType presContent = this.xCapClient.getPresContent(PRES_CONTENT_IMAGE_NAME);
            if (presContent == null) {
                return null;
            }
            String description = null;
            byte[] content = null;
            if (presContent.getDescription().size() > 0) {
                description = presContent.getDescription().get(0).getValue();
            }
            if (presContent.getData() != null) {
                content = Base64.decode((String)presContent.getData().getValue());
            }
            imageDetail = new ServerStoredDetails.ImageDetail(description, content);
        }
        catch (XCapException e) {
            throw new OperationFailedException("Cannot get image detail", 2);
        }
        return imageDetail;
    }

    @Override
    public void deleteAccountImage() throws OperationFailedException {
        try {
            this.xCapClient.deletePresContent(PRES_CONTENT_IMAGE_NAME);
        }
        catch (XCapException e) {
            throw new OperationFailedException("Cannot delete image detail", 2);
        }
    }

    @Override
    public boolean isAccountImageSupported() {
        return this.xCapClient != null && this.xCapClient.isConnected() && this.xCapClient.isPresContentSupported();
    }

    @Override
    public void setAccountImage(byte[] newImageBytes) throws OperationFailedException {
        ContentType presContent = new ContentType();
        MimeType mimeType = new MimeType();
        mimeType.setValue("image/png");
        presContent.setMimeType(mimeType);
        EncodingType encoding = new EncodingType();
        encoding.setValue("base64");
        presContent.setEncoding(encoding);
        String encodedImageContent = new String(Base64.encode((byte[])newImageBytes));
        DataType data = new DataType();
        data.setValue(encodedImageContent);
        presContent.setData(data);
        try {
            this.xCapClient.putPresContent(presContent, PRES_CONTENT_IMAGE_NAME);
        }
        catch (XCapException e) {
            throw new OperationFailedException("Cannot put image detail", 2);
        }
    }

    public String getContactType(Contact contact) {
        if (!(contact instanceof ContactSipImpl)) {
            String errorMessage = String.format("Contact %1s does not seem to belong to this protocol's contact list", contact.getAddress());
            throw new IllegalArgumentException(errorMessage);
        }
        ContactSipImpl contactSip = (ContactSipImpl)contact;
        List<Element> anyElements = contactSip.getAny();
        for (Element e : anyElements) {
            if (!e.getNodeName().equals(CONTACT_TYPE_ELEMENT_NAME)) continue;
            return XMLUtils.getText((Element)e);
        }
        return null;
    }

    public void setContactType(Contact contact, String contactType) {
        if (!(contact instanceof ContactSipImpl)) {
            String errorMessage = String.format("Contact %1s does not seem to belong to this protocol's contact list", contact.getAddress());
            throw new IllegalArgumentException(errorMessage);
        }
        ContactSipImpl contactSip = (ContactSipImpl)contact;
        List<Element> anyElements = contactSip.getAny();
        try {
            Node typeElement = null;
            for (Element el : anyElements) {
                if (!el.getNodeName().equals(CONTACT_TYPE_ELEMENT_NAME)) continue;
                typeElement = el;
                break;
            }
            if (typeElement == null) {
                Document document = XMLUtils.createDocument();
                typeElement = document.createElementNS(CONTACT_TYPE_NS, CONTACT_TYPE_ELEMENT_NAME);
                anyElements.add((Element)typeElement);
            }
            typeElement.setTextContent(contactType);
            contactSip.setAny(anyElements);
        }
        catch (Throwable t) {
            logger.error((Object)"Error creating element", t);
        }
    }
}

