/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.sip;

import ch.imvs.sdes4j.srtp.SrtpCryptoAttribute;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Vector;
import javax.sdp.Attribute;
import javax.sdp.Media;
import javax.sdp.MediaDescription;
import javax.sdp.SdpException;
import javax.sdp.SdpParseException;
import javax.sdp.SessionDescription;
import net.java.sip.communicator.impl.protocol.sip.CallPeerSipImpl;
import net.java.sip.communicator.impl.protocol.sip.ProtocolProviderServiceSipImpl;
import net.java.sip.communicator.impl.protocol.sip.QualityControlWrapper;
import net.java.sip.communicator.impl.protocol.sip.SipActivator;
import net.java.sip.communicator.impl.protocol.sip.TransportManagerSipImpl;
import net.java.sip.communicator.impl.protocol.sip.sdp.SdpUtils;
import net.java.sip.communicator.service.netaddr.NetworkAddressManagerService;
import net.java.sip.communicator.service.protocol.AccountID;
import net.java.sip.communicator.service.protocol.OperationFailedException;
import net.java.sip.communicator.service.protocol.media.CallPeerMediaHandler;
import net.java.sip.communicator.service.protocol.media.MediaAwareCallPeer;
import net.java.sip.communicator.service.protocol.media.SrtpControls;
import net.java.sip.communicator.util.Logger;
import org.jitsi.service.configuration.ConfigurationService;
import org.jitsi.service.neomedia.DtlsControl;
import org.jitsi.service.neomedia.MediaDirection;
import org.jitsi.service.neomedia.MediaService;
import org.jitsi.service.neomedia.MediaStream;
import org.jitsi.service.neomedia.MediaStreamTarget;
import org.jitsi.service.neomedia.MediaType;
import org.jitsi.service.neomedia.QualityControl;
import org.jitsi.service.neomedia.QualityPreset;
import org.jitsi.service.neomedia.RTPExtension;
import org.jitsi.service.neomedia.SDesControl;
import org.jitsi.service.neomedia.SrtpControl;
import org.jitsi.service.neomedia.SrtpControlType;
import org.jitsi.service.neomedia.StreamConnector;
import org.jitsi.service.neomedia.VideoMediaStream;
import org.jitsi.service.neomedia.ZrtpControl;
import org.jitsi.service.neomedia.device.MediaDevice;
import org.jitsi.service.neomedia.event.SrtpListener;
import org.jitsi.service.neomedia.format.MediaFormat;

public class CallPeerMediaHandlerSipImpl
extends CallPeerMediaHandler<CallPeerSipImpl> {
    private static final String DTLS_SRTP_FINGERPRINT_ATTR = "fingerprint";
    private static final String DTLS_SRTP_SETUP_ATTR = "setup";
    private static final Logger logger = Logger.getLogger(CallPeerMediaHandlerSipImpl.class);
    private SessionDescription localSess = null;
    private URL callInfoURL = null;
    private final TransportManagerSipImpl transportManager;
    private boolean supportQualityControls;
    private QualityControlWrapper qualityControls;
    private final Object offerAnswerLock = new Object();

    public CallPeerMediaHandlerSipImpl(CallPeerSipImpl peer) {
        super((MediaAwareCallPeer)peer, (SrtpListener)peer);
        this.transportManager = new TransportManagerSipImpl(peer);
        this.qualityControls = new QualityControlWrapper(peer);
    }

    public String createOffer() throws OperationFailedException {
        SessionDescription offer;
        SessionDescription sessionDescription = offer = this.localSess == null ? this.createFirstOffer() : this.createUpdateOffer(this.localSess);
        if (this.getConfigurationService().getBoolean("net.java.sip.communicator.impl.protocol.sip.USE_SESSION_LEVEL_DIRECTION_IN_SDP", false)) {
            SdpUtils.setSessionDirection(offer);
        }
        return offer.toString();
    }

    private SessionDescription createFirstOffer() throws OperationFailedException {
        SessionDescription sDes;
        List<MediaDescription> mediaDescs = this.createMediaDescriptions();
        String userName = ((ProtocolProviderServiceSipImpl)((CallPeerSipImpl)this.getPeer()).getProtocolProvider()).getAccountID().getUserID();
        this.localSess = sDes = SdpUtils.createSessionDescription(this.getTransportManager().getLastUsedLocalHost(), userName, mediaDescs);
        return this.localSess;
    }

    private List<MediaDescription> createMediaDescriptions() throws OperationFailedException {
        Vector<MediaDescription> mediaDescs = new Vector<MediaDescription>();
        QualityPreset sendQualityPreset = null;
        QualityPreset receiveQualityPreset = null;
        if (this.qualityControls != null) {
            sendQualityPreset = this.qualityControls.getRemoteReceivePreset();
            receiveQualityPreset = this.qualityControls.getRemoteSendMaxPreset();
        }
        for (MediaType mediaType : new MediaType[]{MediaType.AUDIO, MediaType.VIDEO}) {
            MediaDevice dev = this.getDefaultDevice(mediaType);
            if (!this.isDeviceActive(dev, sendQualityPreset, receiveQualityPreset)) {
                logger.warn((Object)("No active device for " + mediaType.toString() + " was found!"));
                continue;
            }
            MediaDirection direction = dev.getDirection().and(this.getDirectionUserPreference(mediaType));
            if (this.isLocallyOnHold()) {
                direction = direction.and(MediaDirection.SENDONLY);
            }
            if (direction == MediaDirection.INACTIVE) continue;
            for (String proto : this.getRtpTransports()) {
                QualityPreset effectiveSendQualityPreset = direction.allowsSending() ? sendQualityPreset : null;
                MediaDescription md = this.createMediaDescription(proto, this.getLocallySupportedFormats(dev, effectiveSendQualityPreset, receiveQualityPreset), this.getTransportManager().getStreamConnector(mediaType), direction, dev.getSupportedExtensions());
                try {
                    switch (mediaType) {
                        case AUDIO: {
                            int ptimeSetting;
                            String rtcpxr = md.getAttribute("rtcp-xr");
                            if (rtcpxr == null) {
                                md.setAttribute("rtcp-xr", "voip-metrics");
                            }
                            if ((ptimeSetting = SipActivator.getConfigurationService().getInt("net.java.sip.communicator.impl.protocol.sip.PTIME_VALUE", 20)) == 20) break;
                            md.setAttribute("ptime", String.valueOf(ptimeSetting));
                            break;
                        }
                        case VIDEO: {
                            if (receiveQualityPreset == null) break;
                            int frameRate = (int)receiveQualityPreset.getFameRate();
                            if (frameRate > 0) {
                                md.setAttribute("framerate", String.valueOf(frameRate));
                            }
                            break;
                        }
                    }
                }
                catch (SdpException sdpException) {
                    // empty catch block
                }
                if ("UDP/TLS/RTP/SAVP".equals(proto) || "UDP/TLS/RTP/SAVPF".equals(proto)) {
                    this.updateMediaDescriptionForDtls(mediaType, md, null);
                } else {
                    this.updateMediaDescriptionForZrtp(mediaType, md);
                    if ("RTP/SAVP".equals(proto) || "RTP/SAVPF".equals(proto)) {
                        this.updateMediaDescriptionForSDes(mediaType, md, null);
                    }
                    if ("RTP/SAVPF".equals(proto)) {
                        this.updateMediaDescriptionForDtls(mediaType, md, null);
                    }
                }
                mediaDescs.add(md);
            }
        }
        if (mediaDescs.isEmpty()) {
            ProtocolProviderServiceSipImpl.throwOperationFailedException("We couldn't find any active Audio/Video devices and couldn't create a call", 1, null, logger);
        }
        return mediaDescs;
    }

    private SessionDescription createUpdateOffer(SessionDescription sdescToUpdate) throws OperationFailedException {
        SessionDescription newOffer;
        List<MediaDescription> newMediaDescs = this.createMediaDescriptions();
        this.localSess = newOffer = SdpUtils.createSessionUpdateDescription(sdescToUpdate, this.getTransportManager().getLastUsedLocalHost(), newMediaDescs);
        return newOffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String processOffer(String offerString) throws OperationFailedException, IllegalArgumentException {
        SessionDescription offer = SdpUtils.parseSdpString(offerString);
        Object object = this.offerAnswerLock;
        synchronized (object) {
            SessionDescription answer;
            SessionDescription sessionDescription = answer = this.localSess == null ? this.processFirstOffer(offer) : this.processUpdateOffer(offer, this.localSess);
            if (this.getConfigurationService().getBoolean("net.java.sip.communicator.impl.protocol.sip.USE_SESSION_LEVEL_DIRECTION_IN_SDP", false)) {
                SdpUtils.setSessionDirection(answer);
            }
            return answer.toString();
        }
    }

    private SessionDescription processFirstOffer(SessionDescription offer) throws OperationFailedException, IllegalArgumentException {
        SessionDescription answer;
        Vector<MediaDescription> answerDescriptions = this.createMediaDescriptionsForAnswer(offer);
        this.localSess = answer = SdpUtils.createSessionDescription(this.getTransportManager().getLastUsedLocalHost(), this.getUserName(), answerDescriptions);
        return this.localSess;
    }

    private SessionDescription processUpdateOffer(SessionDescription newOffer, SessionDescription previousAnswer) throws OperationFailedException, IllegalArgumentException {
        SessionDescription newAnswer;
        Vector<MediaDescription> answerDescriptions = this.createMediaDescriptionsForAnswer(newOffer);
        this.localSess = newAnswer = SdpUtils.createSessionUpdateDescription(previousAnswer, this.getTransportManager().getLastUsedLocalHost(), answerDescriptions);
        return this.localSess;
    }

    private Vector<MediaDescription> createMediaDescriptionsForAnswer(SessionDescription offer) throws OperationFailedException, IllegalArgumentException {
        Vector<MediaDescription> remoteDescriptions = SdpUtils.extractMediaDescriptions(offer);
        Vector<MediaDescription> answerDescriptions = new Vector<MediaDescription>(remoteDescriptions.size());
        this.setCallInfoURL(SdpUtils.getCallInfoURL(offer));
        boolean atLeastOneValidDescription = false;
        boolean rejectedAvpOfferDueToSavpMandatory = false;
        AccountID accountID = ((ProtocolProviderServiceSipImpl)((CallPeerSipImpl)this.getPeer()).getProtocolProvider()).getAccountID();
        boolean useDefaultEncryption = accountID.getAccountPropertyBoolean((Object)"DEFAULT_ENCRYPTION", true);
        int savpOption = useDefaultEncryption ? accountID.getAccountPropertyInt((Object)"SAVP_OPTION", 0) : 0;
        boolean masterStreamSet = false;
        ArrayList<MediaType> seenMediaTypes = new ArrayList<MediaType>();
        for (MediaDescription mediaDescription : remoteDescriptions) {
            MediaStream stream;
            String rtcpxr;
            MediaFormat fmt;
            List mutuallySupportedFormats;
            String proto;
            try {
                proto = mediaDescription.getMedia().getProtocol();
            }
            catch (SdpParseException e) {
                throw new OperationFailedException("Unable to create the media description", 11, (Throwable)e);
            }
            if (savpOption == 1 && !proto.endsWith("RTP/SAVP") && !proto.endsWith("RTP/SAVPF")) {
                rejectedAvpOfferDueToSavpMandatory = true;
                answerDescriptions.add(SdpUtils.createDisablingAnswer(mediaDescription));
                continue;
            }
            MediaType mediaType = null;
            try {
                mediaType = SdpUtils.getMediaType(mediaDescription);
                if (seenMediaTypes.contains(mediaType)) continue;
                seenMediaTypes.add(mediaType);
            }
            catch (IllegalArgumentException iae) {
                answerDescriptions.add(SdpUtils.createDisablingAnswer(mediaDescription));
                continue;
            }
            List<MediaFormat> remoteFormats = SdpUtils.extractFormats(mediaDescription, this.getDynamicPayloadTypes());
            MediaDevice dev = this.getDefaultDevice(mediaType);
            MediaDirection devDirection = dev == null ? MediaDirection.INACTIVE : dev.getDirection();
            devDirection = devDirection.and(this.getDirectionUserPreference(mediaType));
            MediaDirection remoteDirection = SdpUtils.getDirection(mediaDescription);
            MediaDirection direction = devDirection.getDirectionForAnswer(remoteDirection);
            if (dev == null) {
                mutuallySupportedFormats = null;
            } else if (MediaType.VIDEO.equals((Object)mediaType) && this.qualityControls != null) {
                QualityPreset sendQualityPreset = direction.allowsSending() ? this.qualityControls.getRemoteReceivePreset() : null;
                QualityPreset receiveQualityPreset = this.qualityControls.getRemoteSendMaxPreset();
                mutuallySupportedFormats = this.intersectFormats(remoteFormats, this.getLocallySupportedFormats(dev, sendQualityPreset, receiveQualityPreset));
            } else {
                mutuallySupportedFormats = this.intersectFormats(remoteFormats, this.getLocallySupportedFormats(dev));
            }
            MediaStreamTarget target = SdpUtils.extractDefaultTarget(mediaDescription, offer);
            int targetDataPort = target.getDataAddress().getPort();
            if (devDirection == MediaDirection.INACTIVE || mutuallySupportedFormats == null || mutuallySupportedFormats.isEmpty() || targetDataPort == 0) {
                answerDescriptions.add(SdpUtils.createDisablingAnswer(mediaDescription));
                this.closeStream(mediaType);
                continue;
            }
            List<RTPExtension> offeredRTPExtensions = SdpUtils.extractRTPExtensions(mediaDescription, this.getRtpExtensionsRegistry());
            List supportedExtensions = this.getExtensionsForType(mediaType);
            List rtpExtensions = this.intersectRTPExtensions(offeredRTPExtensions, supportedExtensions);
            StreamConnector connector = this.getTransportManager().getStreamConnector(mediaType);
            if (MediaType.VIDEO.equals((Object)mediaType)) {
                List fmts;
                MediaStream stream2 = this.getStream(MediaType.VIDEO);
                if (stream2 != null && !(fmts = this.intersectFormats(this.getLocallySupportedFormats(dev), remoteFormats)).isEmpty()) {
                    fmt = (MediaFormat)fmts.get(0);
                    ((VideoMediaStream)stream2).updateQualityControl(fmt.getAdvancedAttributes());
                }
                this.supportQualityControls = SdpUtils.containsAttribute(mediaDescription, "imageattr");
                float frameRate = -1.0f;
                try {
                    String frStr = mediaDescription.getAttribute("framerate");
                    if (frStr != null) {
                        frameRate = Integer.parseInt(frStr);
                    }
                }
                catch (SdpParseException frStr) {
                    // empty catch block
                }
                if (frameRate > 0.0f) {
                    this.qualityControls.setMaxFrameRate(frameRate);
                }
            }
            MediaDescription md = this.createMediaDescription(proto, mutuallySupportedFormats, connector, direction, rtpExtensions);
            this.setAndAddPreferredEncryptionProtocol(mediaType, md, mediaDescription);
            try {
                rtcpxr = mediaDescription.getAttribute("rtcp-xr");
                if (rtcpxr != null) {
                    rtcpxr = rtcpxr.contains("voip-metrics") ? "voip-metrics" : "";
                    md.setAttribute("rtcp-xr", rtcpxr);
                }
            }
            catch (SdpException se) {
                rtcpxr = null;
            }
            fmt = this.findMediaFormat(remoteFormats, (MediaFormat)mutuallySupportedFormats.get(0));
            boolean masterStream = false;
            if (!masterStreamSet) {
                if (remoteDescriptions.size() > 1) {
                    if (MediaType.AUDIO.equals((Object)mediaType)) {
                        masterStream = true;
                        masterStreamSet = true;
                    }
                } else {
                    masterStream = true;
                    masterStreamSet = true;
                }
            }
            if ((stream = this.initStream(connector, dev, fmt, target, direction, rtpExtensions, masterStream)) != null) {
                stream.setProperty("rtcp-xr", (Object)rtcpxr);
            }
            answerDescriptions.add(md);
            atLeastOneValidDescription = true;
        }
        if (!atLeastOneValidDescription) {
            if (rejectedAvpOfferDueToSavpMandatory) {
                throw new OperationFailedException("Offer contained no valid media descriptions. Insecure media was rejected (only RTP/AVP instead of RTP/SAVP).", 11);
            }
            throw new OperationFailedException("Offer contained no valid media descriptions.", 11);
        }
        return answerDescriptions;
    }

    private boolean updateMediaDescriptionForDtls(MediaType mediaType, MediaDescription localMd, MediaDescription remoteMd) {
        Media localMedia;
        AccountID accountID = ((ProtocolProviderServiceSipImpl)((CallPeerSipImpl)this.getPeer()).getProtocolProvider()).getAccountID();
        boolean b = false;
        if (accountID.getAccountPropertyBoolean((Object)"DEFAULT_ENCRYPTION", true) && accountID.isEncryptionProtocolEnabled(SrtpControlType.DTLS_SRTP) && (localMedia = localMd.getMedia()) != null) {
            SrtpControl dtlsControl;
            boolean dtls;
            String proto;
            try {
                proto = localMedia.getProtocol();
            }
            catch (SdpParseException e) {
                proto = null;
            }
            boolean bl = dtls = "UDP/TLS/RTP/SAVP".equals(proto) || "UDP/TLS/RTP/SAVPF".equals(proto) || "RTP/SAVPF".equals(proto);
            if (dtls && remoteMd != null) {
                dtls = this.isDtlsMediaDescription(remoteMd);
            }
            SrtpControls srtpControls = this.getSrtpControls();
            if (dtls) {
                DtlsControl dtlsControl2 = (DtlsControl)srtpControls.getOrCreate(mediaType, SrtpControlType.DTLS_SRTP);
                Vector attrs = localMd.getAttributes(true);
                DtlsControl.Setup setup = remoteMd == null ? DtlsControl.Setup.ACTPASS : DtlsControl.Setup.ACTIVE;
                Attribute setupAttr = SdpUtils.createAttribute(DTLS_SRTP_SETUP_ATTR, setup.toString());
                attrs.add(setupAttr);
                String hashFunction = dtlsControl2.getLocalFingerprintHashFunction();
                String fingerprint = dtlsControl2.getLocalFingerprint();
                Attribute fingerprintAttr = SdpUtils.createAttribute(DTLS_SRTP_FINGERPRINT_ATTR, hashFunction + " " + fingerprint);
                attrs.add(fingerprintAttr);
                dtlsControl2.setSetup(setup);
                if (remoteMd != null) {
                    this.updateSrtpControlsForDtls(mediaType, localMd, remoteMd);
                }
                b = true;
            } else if (remoteMd != null && (dtlsControl = srtpControls.remove(mediaType, SrtpControlType.DTLS_SRTP)) != null) {
                dtlsControl.cleanup(null);
            }
        }
        return b;
    }

    private void updateSrtpControlsForDtls(MediaType mediaType, MediaDescription localMd, MediaDescription remoteMd) {
        SrtpControls srtpControls = this.getSrtpControls();
        DtlsControl dtlsControl = (DtlsControl)srtpControls.get(mediaType, SrtpControlType.DTLS_SRTP);
        if (dtlsControl == null) {
            return;
        }
        boolean dtls = this.isDtlsMediaDescription(remoteMd);
        if (dtls) {
            if (localMd == null) {
                String setup;
                try {
                    setup = remoteMd.getAttribute(DTLS_SRTP_SETUP_ATTR);
                }
                catch (SdpParseException spe) {
                    setup = null;
                }
                if (DtlsControl.Setup.PASSIVE.toString().equals(setup)) {
                    dtlsControl.setSetup(DtlsControl.Setup.ACTIVE);
                }
            }
            Vector attrs = remoteMd.getAttributes(false);
            LinkedHashMap<String, String> remoteFingerprints = new LinkedHashMap<String, String>();
            if (attrs != null) {
                for (Attribute attr : attrs) {
                    String fingerprint;
                    try {
                        if (!DTLS_SRTP_FINGERPRINT_ATTR.equals(attr.getName()) || (fingerprint = attr.getValue()) == null) continue;
                        fingerprint = fingerprint.trim();
                    }
                    catch (SdpParseException spe) {
                        continue;
                    }
                    int spIndex = fingerprint.indexOf(32);
                    if (spIndex <= 0 || spIndex >= fingerprint.length() - 1) continue;
                    String hashFunction = fingerprint.substring(0, spIndex);
                    fingerprint = fingerprint.substring(spIndex + 1);
                    remoteFingerprints.put(hashFunction, fingerprint);
                }
            }
            dtlsControl.setRemoteFingerprints(remoteFingerprints);
            this.removeAndCleanupOtherSrtpControls(mediaType, SrtpControlType.DTLS_SRTP);
        } else {
            srtpControls.remove(mediaType, SrtpControlType.DTLS_SRTP);
            dtlsControl.cleanup(null);
        }
    }

    private boolean updateMediaDescriptionForSDes(MediaType mediaType, MediaDescription localMd, MediaDescription remoteMd) {
        AccountID accountID = ((ProtocolProviderServiceSipImpl)((CallPeerSipImpl)this.getPeer()).getProtocolProvider()).getAccountID();
        if (!accountID.getAccountPropertyBoolean((Object)"DEFAULT_ENCRYPTION", true) || !accountID.isEncryptionProtocolEnabled(SrtpControlType.SDES)) {
            return false;
        }
        SrtpControls srtpControls = this.getSrtpControls();
        SDesControl sdesControl = (SDesControl)srtpControls.getOrCreate(mediaType, SrtpControlType.SDES);
        String ciphers = accountID.getAccountPropertyString((Object)"SDES_CIPHER_SUITES");
        if (ciphers == null) {
            ciphers = SipActivator.getResources().getSettingsString("net.java.sip.communicator.service.neomedia.SDES_CIPHER_SUITES");
        }
        sdesControl.setEnabledCiphers(Arrays.asList(ciphers.split(",")));
        if (remoteMd == null) {
            Vector atts = localMd.getAttributes(true);
            for (SrtpCryptoAttribute ca : sdesControl.getInitiatorCryptoAttributes()) {
                atts.add(SdpUtils.createAttribute("crypto", ca.encode()));
            }
            return true;
        }
        SrtpCryptoAttribute localAttr = this.selectSdesCryptoSuite(false, sdesControl, remoteMd);
        if (localAttr != null) {
            try {
                localMd.setAttribute("crypto", localAttr.encode());
                return true;
            }
            catch (SdpException e) {
                logger.error((Object)"unable to add crypto to answer", (Throwable)e);
            }
        } else {
            sdesControl.cleanup(null);
            srtpControls.remove(mediaType, SrtpControlType.SDES);
            logger.warn((Object)"Received unsupported sdes crypto attribute.");
        }
        return false;
    }

    private boolean updateMediaDescriptionForZrtp(MediaType mediaType, MediaDescription localMd) {
        MediaAwareCallPeer peer = this.getPeer();
        AccountID accountID = peer.getProtocolProvider().getAccountID();
        boolean b = false;
        if (accountID.getAccountPropertyBoolean((Object)"DEFAULT_ENCRYPTION", true) && accountID.isEncryptionProtocolEnabled(SrtpControlType.ZRTP) && peer.getCall().isSipZrtpAttribute()) {
            ZrtpControl zrtpControl = (ZrtpControl)this.getSrtpControls().getOrCreate(mediaType, SrtpControlType.ZRTP);
            int numberSupportedVersions = zrtpControl.getNumberSupportedVersions();
            try {
                for (int i = 0; i < numberSupportedVersions; ++i) {
                    String helloHash = zrtpControl.getHelloHash(i);
                    if (helloHash == null || helloHash.length() <= 0) continue;
                    localMd.setAttribute("zrtp-hash", helloHash);
                    b = true;
                }
            }
            catch (SdpException ex) {
                logger.error((Object)"Cannot add zrtp-hash to sdp", (Throwable)ex);
            }
        }
        return b;
    }

    private List<String> getRtpTransports() throws OperationFailedException {
        AccountID accountID = ((ProtocolProviderServiceSipImpl)((CallPeerSipImpl)this.getPeer()).getProtocolProvider()).getAccountID();
        int savpOption = accountID.getAccountPropertyBoolean((Object)"DEFAULT_ENCRYPTION", true) ? accountID.getAccountPropertyInt((Object)"SAVP_OPTION", 0) : 0;
        ArrayList<String> result = new ArrayList<String>(3);
        if (savpOption == 0) {
            result.add("RTP/AVP");
        } else {
            List encryptionProtocols = accountID.getSortedEnabledEncryptionProtocolList();
            for (int epi = encryptionProtocols.size() - 1; epi >= 0; --epi) {
                SrtpControlType srtpControlType = (SrtpControlType)encryptionProtocols.get(epi);
                String[] protos = srtpControlType == SrtpControlType.DTLS_SRTP ? new String[]{"UDP/TLS/RTP/SAVP", "RTP/SAVPF"} : new String[]{"RTP/SAVP"};
                for (int pi = protos.length - 1; pi >= 0; --pi) {
                    String proto = protos[pi];
                    int ri = result.indexOf(proto);
                    if (ri >= 0) {
                        result.remove(ri);
                    }
                    result.add(0, proto);
                }
            }
            if (savpOption == 2) {
                result.add("RTP/AVP");
            }
        }
        return result;
    }

    public void processAnswer(String answer) throws OperationFailedException, IllegalArgumentException {
        this.processAnswer(SdpUtils.parseSdpString(answer));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processAnswer(SessionDescription answer) throws OperationFailedException, IllegalArgumentException {
        Object object = this.offerAnswerLock;
        synchronized (object) {
            this.doNonSynchronisedProcessAnswer(answer);
        }
    }

    private void doNonSynchronisedProcessAnswer(SessionDescription answer) throws OperationFailedException, IllegalArgumentException {
        Vector<MediaDescription> remoteDescriptions = SdpUtils.extractMediaDescriptions(answer);
        this.setCallInfoURL(SdpUtils.getCallInfoURL(answer));
        boolean masterStreamSet = false;
        ArrayList<MediaType> seenMediaTypes = new ArrayList<MediaType>();
        for (MediaDescription mediaDescription : remoteDescriptions) {
            String rtcpxr;
            MediaStream stream;
            MediaType mediaType;
            try {
                mediaType = SdpUtils.getMediaType(mediaDescription);
                if (seenMediaTypes.contains(mediaType)) continue;
                seenMediaTypes.add(mediaType);
            }
            catch (IllegalArgumentException iae) {
                logger.info((Object)"Remote party added to answer a media type that we don't understand. Ignoring stream.");
                continue;
            }
            MediaStreamTarget target = SdpUtils.extractDefaultTarget(mediaDescription, answer);
            if (target.getDataAddress().getPort() == 0) {
                this.closeStream(mediaType);
                continue;
            }
            List<MediaFormat> supportedFormats = SdpUtils.extractFormats(mediaDescription, this.getDynamicPayloadTypes());
            MediaDevice dev = this.getDefaultDevice(mediaType);
            if (!this.isDeviceActive(dev)) {
                this.closeStream(mediaType);
                continue;
            }
            MediaDirection devDirection = dev == null ? MediaDirection.INACTIVE : dev.getDirection();
            devDirection = devDirection.and(this.getDirectionUserPreference(mediaType));
            if (supportedFormats.isEmpty()) {
                ProtocolProviderServiceSipImpl.throwOperationFailedException("Remote party sent an invalid SDP answer. The codecs in the answer are either not present or not supported", 11, null, logger);
            }
            StreamConnector connector = this.getTransportManager().getStreamConnector(mediaType);
            MediaDirection remoteDirection = SdpUtils.getDirection(mediaDescription);
            MediaDirection direction = devDirection.getDirectionForAnswer(remoteDirection);
            if (this.isLocallyOnHold()) {
                direction = direction.and(MediaDirection.SENDONLY);
            }
            List<RTPExtension> remoteRTPExtensions = SdpUtils.extractRTPExtensions(mediaDescription, this.getRtpExtensionsRegistry());
            List supportedExtensions = this.getExtensionsForType(mediaType);
            List rtpExtensions = this.intersectRTPExtensions(remoteRTPExtensions, supportedExtensions);
            if (MediaType.VIDEO.equals((Object)mediaType)) {
                this.supportQualityControls = SdpUtils.containsAttribute(mediaDescription, "imageattr");
            }
            this.updateSrtpControlsForDtls(mediaType, null, mediaDescription);
            SrtpControls srtpControls = this.getSrtpControls();
            SDesControl sdesControl = (SDesControl)srtpControls.get(mediaType, SrtpControlType.SDES);
            if (sdesControl != null) {
                if (this.selectSdesCryptoSuite(true, sdesControl, mediaDescription) == null) {
                    sdesControl.cleanup(null);
                    srtpControls.remove(mediaType, SrtpControlType.SDES);
                    logger.warn((Object)"Received unsupported sdes crypto attribute.");
                } else {
                    this.removeAndCleanupOtherSrtpControls(mediaType, SrtpControlType.SDES);
                    this.addAdvertisedEncryptionMethod(SrtpControlType.SDES);
                }
            }
            boolean masterStream = false;
            if (!masterStreamSet) {
                if (remoteDescriptions.size() > 1) {
                    if (MediaType.AUDIO.equals((Object)mediaType)) {
                        masterStream = true;
                        masterStreamSet = true;
                    }
                } else {
                    masterStream = true;
                    masterStreamSet = true;
                }
            }
            try {
                if (mediaDescription.getAttribute("zrtp-hash") != null) {
                    this.addAdvertisedEncryptionMethod(SrtpControlType.ZRTP);
                }
            }
            catch (SdpParseException e) {
                logger.error((Object)"received an unparsable sdp attribute", (Throwable)e);
            }
            if ((stream = this.initStream(connector, dev, supportedFormats.get(0), target, direction, rtpExtensions, masterStream)) == null) continue;
            try {
                rtcpxr = mediaDescription.getAttribute("rtcp-xr");
            }
            catch (SdpException se) {
                rtcpxr = null;
            }
            stream.setProperty("rtcp-xr", (Object)rtcpxr);
        }
    }

    private String getUserName() {
        return ((ProtocolProviderServiceSipImpl)((CallPeerSipImpl)this.getPeer()).getProtocolProvider()).getAccountID().getUserID();
    }

    private MediaDescription createMediaDescription(String transport, List<MediaFormat> formats, StreamConnector connector, MediaDirection direction, List<RTPExtension> extensions) throws OperationFailedException {
        return SdpUtils.createMediaDescription(transport, formats, connector, direction, extensions, this.getDynamicPayloadTypes(), this.getRtpExtensionsRegistry());
    }

    public URL getCallInfoURL() {
        return this.callInfoURL;
    }

    private void setCallInfoURL(URL callInfolURL) {
        this.callInfoURL = callInfolURL;
    }

    protected NetworkAddressManagerService getNetworkAddressManagerService() {
        return SipActivator.getNetworkAddressManagerService();
    }

    protected ConfigurationService getConfigurationService() {
        return SipActivator.getConfigurationService();
    }

    protected MediaService getMediaService() {
        return SipActivator.getMediaService();
    }

    protected void throwOperationFailedException(String message, int errorCode, Throwable cause) throws OperationFailedException {
        ProtocolProviderServiceSipImpl.throwOperationFailedException(message, errorCode, cause, logger);
    }

    protected TransportManagerSipImpl getTransportManager() {
        return this.transportManager;
    }

    protected TransportManagerSipImpl queryTransportManager() {
        return this.transportManager;
    }

    public QualityControl getQualityControl() {
        if (this.supportQualityControls) {
            return this.qualityControls;
        }
        return null;
    }

    public void setSupportQualityControls(boolean value) {
        this.supportQualityControls = value;
    }

    protected SrtpCryptoAttribute selectSdesCryptoSuite(boolean isInitiator, SDesControl sDesControl, MediaDescription mediaDescription) {
        Vector attrs = mediaDescription.getAttributes(true);
        Vector<SrtpCryptoAttribute> peerAttributes = new Vector<SrtpCryptoAttribute>(attrs.size());
        for (int i = 0; i < attrs.size(); ++i) {
            try {
                Attribute a = (Attribute)attrs.get(i);
                if (!a.getName().equals("crypto")) continue;
                peerAttributes.add(SrtpCryptoAttribute.create((String)a.getValue()));
                continue;
            }
            catch (Exception e) {
                logger.error((Object)"received an unparsable sdp attribute", (Throwable)e);
            }
        }
        if (isInitiator) {
            return sDesControl.initiatorSelectAttribute(peerAttributes);
        }
        return sDesControl.responderSelectAttribute(peerAttributes);
    }

    protected void setAndAddPreferredEncryptionProtocol(MediaType mediaType, MediaDescription localMd, MediaDescription remoteMd) {
        List preferredEncryptionProtocols = ((ProtocolProviderServiceSipImpl)((CallPeerSipImpl)this.getPeer()).getProtocolProvider()).getAccountID().getSortedEnabledEncryptionProtocolList();
        for (SrtpControlType srtpControlType : preferredEncryptionProtocols) {
            if (!(srtpControlType == SrtpControlType.DTLS_SRTP ? this.updateMediaDescriptionForDtls(mediaType, localMd, remoteMd) : (srtpControlType == SrtpControlType.SDES ? this.updateMediaDescriptionForSDes(mediaType, localMd, remoteMd) : srtpControlType == SrtpControlType.ZRTP && this.updateMediaDescriptionForZrtp(mediaType, localMd)))) continue;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws IllegalStateException {
        Object object = this.offerAnswerLock;
        synchronized (object) {
            super.start();
        }
    }

    private boolean isDtlsMediaDescription(MediaDescription mediaDescription) {
        Media media;
        boolean dtls = false;
        if (mediaDescription != null && (media = mediaDescription.getMedia()) != null) {
            try {
                String setup;
                String fingerprint;
                String proto = media.getProtocol();
                if (("UDP/TLS/RTP/SAVP".equals(proto) || "UDP/TLS/RTP/SAVPF".equals(proto) || "RTP/SAVPF".equals(proto)) && (fingerprint = mediaDescription.getAttribute(DTLS_SRTP_FINGERPRINT_ATTR)) != null && fingerprint.length() != 0 && (setup = mediaDescription.getAttribute(DTLS_SRTP_SETUP_ATTR)) != null && setup.length() != 0) {
                    dtls = true;
                }
            }
            catch (SdpParseException sdpParseException) {
                // empty catch block
            }
        }
        return dtls;
    }
}

