/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.model;

import com.google.gdata.model.Element;
import com.google.gdata.model.MetadataKey;
import com.google.gdata.model.QName;
import com.google.gdata.util.common.base.Preconditions;

public final class ElementKey<D, E extends Element>
extends MetadataKey<D> {
    final Class<? extends E> elementType;

    public static ElementKey<String, Element> of(QName id) {
        return ElementKey.of(id, String.class, Element.class);
    }

    public static <V extends Element> ElementKey<Void, V> of(QName id, Class<? extends V> elementType) {
        return ElementKey.of(id, Void.class, elementType);
    }

    public static <T, V extends Element> ElementKey<T, V> of(QName id, Class<? extends T> datatype, Class<? extends V> elementType) {
        return new ElementKey<T, V>(id, datatype, elementType);
    }

    private ElementKey(QName id, Class<? extends D> datatype, Class<? extends E> elementType) {
        super(id, datatype);
        Preconditions.checkNotNull(elementType, "elementType");
        if (Element.class == elementType) {
            Preconditions.checkNotNull(id, "id");
        }
        this.elementType = elementType;
    }

    public Class<? extends E> getElementType() {
        return this.elementType;
    }

    @Override
    public boolean matches(MetadataKey<?> other) {
        if (other == null) {
            return false;
        }
        if (!(other instanceof ElementKey)) {
            return false;
        }
        if (!this.matchIdAndDatatype(other)) {
            return false;
        }
        return this.elementType.isAssignableFrom(((ElementKey)other).elementType);
    }

    @Override
    public int compareTo(MetadataKey<?> other) {
        if (other == this) {
            return 0;
        }
        if (!(other instanceof ElementKey)) {
            return 1;
        }
        int compare = ElementKey.compareQName(this.id, other.id);
        if (compare != 0) {
            return compare;
        }
        compare = ElementKey.compareClass(this.elementType, ((ElementKey)other).elementType);
        if (compare != 0) {
            return compare;
        }
        return ElementKey.compareClass(this.datatype, other.datatype);
    }

    public int hashCode() {
        int hashCode = this.datatype.hashCode();
        hashCode *= 17;
        if (this.id != null) {
            hashCode += this.id.hashCode();
        }
        return (hashCode *= 17) + this.elementType.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != ElementKey.class) {
            return false;
        }
        ElementKey o = (ElementKey)obj;
        if (this.id == null ? o.id != null : !this.id.equals(o.id)) {
            return false;
        }
        return this.elementType == o.elementType && this.datatype == o.datatype;
    }

    @Override
    public String toString() {
        return "{ElementKey " + this.id + ", D:" + this.datatype + ", E:" + this.elementType + "}";
    }
}

