/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.ldap.configform;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.LineBorder;
import net.java.sip.communicator.plugin.desktoputil.SIPCommCheckBox;
import net.java.sip.communicator.plugin.desktoputil.SIPCommDialog;
import net.java.sip.communicator.plugin.desktoputil.SIPCommRadioButton;
import net.java.sip.communicator.plugin.desktoputil.SIPCommTextField;
import net.java.sip.communicator.plugin.desktoputil.TransparentPanel;
import net.java.sip.communicator.plugin.ldap.LdapActivator;
import net.java.sip.communicator.plugin.ldap.configform.Resources;
import net.java.sip.communicator.service.ldap.LdapConstants;
import net.java.sip.communicator.service.ldap.LdapDirectory;
import net.java.sip.communicator.service.ldap.LdapDirectorySettings;

public class DirectorySettingsForm
extends SIPCommDialog
implements ActionListener {
    private static final long serialVersionUID = 0L;
    private LdapDirectorySettings settings;
    private JTextField mailField = new JTextField();
    private JTextField mailSuffixField = new JTextField();
    private JTextField workPhoneField = new JTextField();
    private JTextField mobilePhoneField = new JTextField();
    private JTextField homePhoneField = new JTextField();
    private JRadioButton rdoDefaultQuery = new SIPCommRadioButton(Resources.getString("impl.ldap.QUERY_DEFAULT"));
    private JRadioButton rdoCustomQuery = new SIPCommRadioButton(Resources.getString("impl.ldap.QUERY_CUSTOM"));
    private JTextArea txtCustomQuery = new JTextArea("", 15, 40);
    private JCheckBox chkMangleQuery = new SIPCommCheckBox(Resources.getString("impl.ldap.QUERY_CUSTOM_AUTO_WILDCARD"));
    private JCheckBox chkPhotoInline = new SIPCommCheckBox(Resources.getString("impl.ldap.QUERY_PHOTO_INLINE"));
    private JTextField nameField;
    private JTextField hostnameField;
    private JCheckBox encryptionBox = new SIPCommCheckBox(Resources.getString("impl.ldap.USE_SSL"));
    private JSpinner portSpinner;
    private SpinnerNumberModel portModel;
    private JTextField bindDNField;
    private JPasswordField passwordField;
    private JTextField baseDNField = new JTextField();
    private final String[] authStrings = new String[]{Resources.getString("impl.ldap.AUTH_NONE"), Resources.getString("impl.ldap.AUTH_SIMPLE")};
    private JComboBox authList = new JComboBox<String>(this.authStrings);
    private final String[] scopeStrings = new String[]{Resources.getString("impl.ldap.SCOPE_SUB_TREE"), Resources.getString("impl.ldap.SCOPE_ONE")};
    private JComboBox scopeList = new JComboBox<String>(this.scopeStrings);
    private final JLabel prefixLabel = new JLabel(Resources.getString("impl.ldap.PHONE_PREFIX"));
    private final SIPCommTextField prefixField = new SIPCommTextField(Resources.getString("impl.ldap.PHONE_PREFIX_EXAMPLE"));
    private JButton saveBtn = new JButton(Resources.getString("impl.ldap.SAVE"));
    private JButton cancelBtn = new JButton(Resources.getString("impl.ldap.CANCEL"));
    private int retCode = 0;

    public DirectorySettingsForm() {
        this.settings = LdapActivator.getLdapService().getFactory().createServerSettings();
        JTabbedPane pane = new JTabbedPane();
        TransparentPanel panel = new TransparentPanel((LayoutManager)new BorderLayout());
        TransparentPanel btnPanel = new TransparentPanel((LayoutManager)new FlowLayout(2));
        this.setTitle(Resources.getString("impl.ldap.CONFIG_FORM_TITLE"));
        this.setMinimumSize(new Dimension(400, 400));
        this.setSize(new Dimension(400, 400));
        this.setPreferredSize(new Dimension(400, 400));
        pane.addTab(Resources.getString("impl.ldap.GENERAL"), this.getContentPanel());
        pane.addTab(Resources.getString("impl.ldap.FIELDS"), this.getFieldsPanel());
        pane.addTab(Resources.getString("impl.ldap.QUERY"), this.getCustomQueryPanel());
        btnPanel.add(this.saveBtn);
        btnPanel.add(this.cancelBtn);
        panel.add((Component)pane, "Center");
        panel.add((Component)btnPanel, "South");
        this.getContentPane().add((Component)panel);
        this.pack();
    }

    public JPanel getFieldsPanel() {
        TransparentPanel contentPanel = new TransparentPanel((LayoutManager)new BorderLayout());
        TransparentPanel basePanel = new TransparentPanel((LayoutManager)new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        JLabel mailLabel = new JLabel(Resources.getString("impl.ldap.MAIL_FIELD_NAME"));
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridwidth = 1;
        c.insets = new Insets(2, 50, 0, 5);
        c.fill = 2;
        c.anchor = 21;
        basePanel.add((Component)mailLabel, c);
        c.gridx = 1;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridwidth = 0;
        c.insets = new Insets(2, 5, 0, 50);
        c.fill = 2;
        c.anchor = 22;
        basePanel.add((Component)this.mailField, c);
        JLabel mailExampleLabel = new JLabel(Resources.getString("impl.ldap.MAIL_FIELD_EXAMPLE"));
        mailExampleLabel.setForeground(Color.GRAY);
        mailExampleLabel.setFont(mailExampleLabel.getFont().deriveFont(8));
        c.gridx = 1;
        c.gridy = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridwidth = 0;
        c.insets = new Insets(0, 13, 2, 0);
        c.fill = 2;
        c.anchor = 21;
        basePanel.add((Component)mailExampleLabel, c);
        JLabel mailSuffixLabel = new JLabel(Resources.getString("impl.ldap.MAILSUFFIX_FIELD_NAME"));
        c.gridx = 0;
        c.gridy = 2;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridwidth = 1;
        c.insets = new Insets(2, 50, 0, 5);
        c.fill = 2;
        c.anchor = 21;
        basePanel.add((Component)mailSuffixLabel, c);
        c.gridx = 1;
        c.gridy = 2;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridwidth = 0;
        c.insets = new Insets(2, 5, 0, 50);
        c.fill = 2;
        c.anchor = 22;
        basePanel.add((Component)this.mailSuffixField, c);
        JLabel mailSuffixExampleLabel = new JLabel(Resources.getString("impl.ldap.MAILSUFFIX_FIELD_EXAMPLE"));
        mailSuffixExampleLabel.setForeground(Color.GRAY);
        mailSuffixExampleLabel.setFont(mailSuffixExampleLabel.getFont().deriveFont(8));
        c.gridx = 1;
        c.gridy = 3;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridwidth = 0;
        c.insets = new Insets(0, 13, 2, 0);
        c.fill = 2;
        c.anchor = 21;
        basePanel.add((Component)mailSuffixExampleLabel, c);
        JLabel workPhoneLabel = new JLabel(Resources.getString("impl.ldap.WORKPHONE_FIELD_NAME"));
        c.gridx = 0;
        c.gridy = 4;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridwidth = 1;
        c.insets = new Insets(2, 50, 0, 5);
        c.fill = 2;
        c.anchor = 21;
        basePanel.add((Component)workPhoneLabel, c);
        c.gridx = 1;
        c.gridy = 4;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridwidth = 0;
        c.insets = new Insets(2, 5, 0, 50);
        c.fill = 2;
        c.anchor = 22;
        basePanel.add((Component)this.workPhoneField, c);
        JLabel workPhoneExampleLabel = new JLabel(Resources.getString("impl.ldap.WORKPHONE_FIELD_EXAMPLE"));
        workPhoneExampleLabel.setForeground(Color.GRAY);
        workPhoneExampleLabel.setFont(workPhoneExampleLabel.getFont().deriveFont(8));
        c.gridx = 1;
        c.gridy = 5;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridwidth = 0;
        c.insets = new Insets(0, 13, 2, 0);
        c.fill = 2;
        c.anchor = 21;
        basePanel.add((Component)workPhoneExampleLabel, c);
        JLabel mobilePhoneLabel = new JLabel(Resources.getString("impl.ldap.MOBILEPHONE_FIELD_NAME"));
        c.gridx = 0;
        c.gridy = 6;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridwidth = 1;
        c.insets = new Insets(2, 50, 0, 5);
        c.fill = 2;
        c.anchor = 21;
        basePanel.add((Component)mobilePhoneLabel, c);
        c.gridx = 1;
        c.gridy = 6;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridwidth = 0;
        c.insets = new Insets(2, 5, 0, 50);
        c.fill = 2;
        c.anchor = 22;
        basePanel.add((Component)this.mobilePhoneField, c);
        JLabel mobilePhoneExampleLabel = new JLabel(Resources.getString("impl.ldap.MOBILEPHONE_FIELD_EXAMPLE"));
        mobilePhoneExampleLabel.setForeground(Color.GRAY);
        mobilePhoneExampleLabel.setFont(mobilePhoneExampleLabel.getFont().deriveFont(8));
        c.gridx = 1;
        c.gridy = 7;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridwidth = 0;
        c.insets = new Insets(0, 13, 2, 0);
        c.fill = 2;
        c.anchor = 21;
        basePanel.add((Component)mobilePhoneExampleLabel, c);
        JLabel homePhoneLabel = new JLabel(Resources.getString("impl.ldap.HOMEPHONE_FIELD_NAME"));
        c.gridx = 0;
        c.gridy = 8;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridwidth = 1;
        c.insets = new Insets(2, 50, 0, 5);
        c.fill = 2;
        c.anchor = 21;
        basePanel.add((Component)homePhoneLabel, c);
        c.gridx = 1;
        c.gridy = 8;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridwidth = 0;
        c.insets = new Insets(2, 5, 0, 50);
        c.fill = 2;
        c.anchor = 22;
        basePanel.add((Component)this.homePhoneField, c);
        JLabel homePhoneExampleLabel = new JLabel(Resources.getString("impl.ldap.HOMEPHONE_FIELD_EXAMPLE"));
        homePhoneExampleLabel.setForeground(Color.GRAY);
        homePhoneExampleLabel.setFont(homePhoneExampleLabel.getFont().deriveFont(8));
        c.gridx = 1;
        c.gridy = 9;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridwidth = 0;
        c.insets = new Insets(0, 13, 2, 0);
        c.fill = 2;
        c.anchor = 21;
        basePanel.add((Component)homePhoneExampleLabel, c);
        contentPanel.add((Component)basePanel, "Center");
        return contentPanel;
    }

    public JPanel getContentPanel() {
        TransparentPanel contentPanel = new TransparentPanel((LayoutManager)new BorderLayout());
        TransparentPanel mainPanel = new TransparentPanel();
        TransparentPanel basePanel = new TransparentPanel((LayoutManager)new GridBagLayout());
        TransparentPanel authPanel = new TransparentPanel((LayoutManager)new GridBagLayout());
        TransparentPanel searchPanel = new TransparentPanel((LayoutManager)new GridBagLayout());
        TransparentPanel prefixPanel = new TransparentPanel((LayoutManager)new GridBagLayout());
        BoxLayout boxLayout = new BoxLayout((Container)mainPanel, 1);
        GridBagConstraints c = new GridBagConstraints();
        JLabel nameLabel = new JLabel(Resources.getString("impl.ldap.SERVER_NAME"));
        this.nameField = new JTextField();
        nameLabel.setLabelFor(this.nameField);
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridwidth = 1;
        c.insets = new Insets(2, 50, 0, 5);
        c.fill = 2;
        c.anchor = 21;
        basePanel.add((Component)nameLabel, c);
        c.gridx = 1;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridwidth = 0;
        c.insets = new Insets(2, 5, 0, 50);
        c.fill = 2;
        c.anchor = 22;
        basePanel.add((Component)this.nameField, c);
        JLabel nameExampleLabel = new JLabel(Resources.getString("impl.ldap.SERVER_NAME_EXAMPLE"));
        nameExampleLabel.setForeground(Color.GRAY);
        nameExampleLabel.setFont(nameExampleLabel.getFont().deriveFont(8));
        c.gridx = 1;
        c.gridy = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridwidth = 0;
        c.insets = new Insets(0, 13, 2, 0);
        c.fill = 2;
        c.anchor = 21;
        basePanel.add((Component)nameExampleLabel, c);
        JLabel hostnameLabel = new JLabel(Resources.getString("impl.ldap.SERVER_HOSTNAME"));
        this.hostnameField = new JTextField();
        hostnameLabel.setLabelFor(this.hostnameField);
        c.gridx = 0;
        c.gridy = 2;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridwidth = 1;
        c.insets = new Insets(2, 50, 0, 5);
        c.fill = 2;
        c.anchor = 21;
        basePanel.add((Component)hostnameLabel, c);
        c.gridx = 1;
        c.gridy = 2;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridwidth = 0;
        c.insets = new Insets(2, 5, 0, 50);
        c.fill = 2;
        c.anchor = 22;
        basePanel.add((Component)this.hostnameField, c);
        JLabel hostExampleLabel = new JLabel("ldap.example.org");
        hostExampleLabel.setForeground(Color.GRAY);
        hostExampleLabel.setFont(hostExampleLabel.getFont().deriveFont(8));
        c.gridx = 1;
        c.gridy = 3;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridwidth = 0;
        c.insets = new Insets(0, 13, 2, 0);
        c.fill = 2;
        c.anchor = 21;
        basePanel.add((Component)hostExampleLabel, c);
        JLabel portLabel = new JLabel(Resources.getString("impl.ldap.SERVER_PORT"));
        this.portModel = new SpinnerNumberModel(389, 1, 65535, 1);
        this.portSpinner = new JSpinner(this.portModel);
        portLabel.setLabelFor(this.portSpinner);
        c.gridx = 0;
        c.gridy = 4;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridwidth = 0;
        c.insets = new Insets(2, 50, 2, 5);
        c.fill = 0;
        c.anchor = 21;
        basePanel.add((Component)portLabel, c);
        c.gridx = 1;
        c.gridy = 4;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridwidth = 0;
        c.insets = new Insets(2, 5, 2, 5);
        c.fill = 0;
        c.anchor = 21;
        basePanel.add((Component)this.portSpinner, c);
        c.gridx = 1;
        c.gridy = 5;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridwidth = 0;
        c.insets = new Insets(2, 5, 2, 5);
        c.fill = 0;
        c.anchor = 21;
        basePanel.add((Component)this.encryptionBox, c);
        this.authList.setSelectedIndex(0);
        JLabel authLabel = new JLabel(Resources.getString("impl.ldap.AUTHENTICATION"));
        authLabel.setLabelFor(this.authList);
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridwidth = 1;
        c.insets = new Insets(2, 50, 2, 5);
        c.fill = 2;
        c.anchor = 21;
        authPanel.add((Component)authLabel, c);
        c.gridx = 1;
        c.gridy = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridwidth = 1;
        c.insets = new Insets(2, 5, 2, 5);
        c.fill = 0;
        c.anchor = 21;
        authPanel.add((Component)this.authList, c);
        JLabel bindDNLabel = new JLabel(Resources.getString("impl.ldap.USERNAME"));
        this.bindDNField = new JTextField();
        bindDNLabel.setLabelFor(this.bindDNField);
        c.gridx = 0;
        c.gridy = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridwidth = 1;
        c.insets = new Insets(2, 50, 0, 5);
        c.fill = 2;
        c.anchor = 21;
        authPanel.add((Component)bindDNLabel, c);
        c.gridx = 1;
        c.gridy = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridwidth = 0;
        c.insets = new Insets(2, 5, 0, 50);
        c.fill = 2;
        c.anchor = 22;
        authPanel.add((Component)this.bindDNField, c);
        JLabel bindDNExampleLabel = new JLabel("uid=user,o=example");
        bindDNExampleLabel.setForeground(Color.GRAY);
        bindDNExampleLabel.setFont(bindDNExampleLabel.getFont().deriveFont(8));
        c.gridx = 1;
        c.gridy = 2;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridwidth = 0;
        c.insets = new Insets(0, 13, 2, 0);
        c.fill = 2;
        c.anchor = 21;
        authPanel.add((Component)bindDNExampleLabel, c);
        JLabel passwordLabel = new JLabel(Resources.getString("impl.ldap.PASSWORD"));
        this.passwordField = new JPasswordField();
        passwordLabel.setLabelFor(this.passwordField);
        c.gridx = 0;
        c.gridy = 3;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridwidth = 1;
        c.insets = new Insets(2, 50, 2, 5);
        c.fill = 2;
        c.anchor = 21;
        authPanel.add((Component)passwordLabel, c);
        c.gridx = 1;
        c.gridy = 3;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridwidth = 0;
        c.insets = new Insets(2, 5, 20, 50);
        c.fill = 2;
        c.anchor = 22;
        authPanel.add((Component)this.passwordField, c);
        JLabel baseDNLabel = new JLabel(Resources.getString("impl.ldap.SEARCH_BASE"));
        baseDNLabel.setLabelFor(this.baseDNField);
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridwidth = 1;
        c.insets = new Insets(2, 50, 0, 5);
        c.fill = 2;
        c.anchor = 23;
        searchPanel.add((Component)baseDNLabel, c);
        c.gridx = 1;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridwidth = 0;
        c.insets = new Insets(2, 5, 0, 50);
        c.fill = 2;
        c.anchor = 24;
        searchPanel.add((Component)this.baseDNField, c);
        JLabel baseDNExampleLabel = new JLabel("o=example");
        baseDNExampleLabel.setForeground(Color.GRAY);
        baseDNExampleLabel.setFont(baseDNExampleLabel.getFont().deriveFont(8));
        c.gridx = 1;
        c.gridy = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridwidth = 0;
        c.insets = new Insets(0, 13, 2, 0);
        c.fill = 2;
        c.anchor = 21;
        searchPanel.add((Component)baseDNExampleLabel, c);
        this.scopeList.setSelectedIndex(0);
        JLabel scopeLabel = new JLabel(Resources.getString("impl.ldap.SCOPE"));
        scopeLabel.setLabelFor(this.scopeList);
        c.gridx = 0;
        c.gridy = 2;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridwidth = 1;
        c.insets = new Insets(2, 50, 2, 5);
        c.fill = 0;
        c.anchor = 21;
        searchPanel.add((Component)scopeLabel, c);
        c.gridx = 1;
        c.gridy = 2;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridwidth = 1;
        c.insets = new Insets(2, 5, 2, 5);
        c.fill = 0;
        c.anchor = 21;
        searchPanel.add((Component)this.scopeList, c);
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridwidth = 1;
        c.insets = new Insets(2, 50, 0, 5);
        c.fill = 2;
        c.anchor = 21;
        prefixPanel.add((Component)this.prefixLabel, c);
        c.gridx = 1;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridwidth = 0;
        c.insets = new Insets(2, 5, 0, 50);
        c.fill = 2;
        c.anchor = 22;
        prefixPanel.add((Component)this.prefixField, c);
        mainPanel.setLayout(boxLayout);
        mainPanel.add((Component)basePanel);
        mainPanel.add(new JSeparator());
        mainPanel.add((Component)searchPanel);
        mainPanel.add(new JSeparator());
        mainPanel.add((Component)authPanel);
        mainPanel.add(new JSeparator());
        mainPanel.add((Component)prefixPanel);
        this.encryptionBox.addActionListener(this);
        this.nameField.addActionListener(this);
        this.hostnameField.addActionListener(this);
        this.bindDNField.addActionListener(this);
        this.passwordField.addActionListener(this);
        this.saveBtn.addActionListener(this);
        this.cancelBtn.addActionListener(this);
        this.authList.addActionListener(this);
        contentPanel.add((Component)mainPanel, "Center");
        return contentPanel;
    }

    private JPanel getCustomQueryPanel() {
        this.rdoDefaultQuery.addActionListener(this);
        this.rdoCustomQuery.addActionListener(this);
        TransparentPanel p = new TransparentPanel();
        p.setLayout(new BorderLayout());
        TransparentPanel options = new TransparentPanel();
        options.setLayout(new BoxLayout((Container)options, 1));
        options.add(this.rdoDefaultQuery);
        options.add(this.rdoCustomQuery);
        p.add((Component)options, "North");
        p.add((Component)this.txtCustomQuery, "Center");
        this.txtCustomQuery.setBorder(new LineBorder(Color.black));
        this.txtCustomQuery.setLineWrap(true);
        this.txtCustomQuery.setWrapStyleWord(false);
        TransparentPanel hints = new TransparentPanel();
        hints.setLayout(new BoxLayout((Container)hints, 1));
        hints.add(new JLabel(Resources.getString("impl.ldap.QUERY_CUSTOM_HINT", new String[]{"<query>"})));
        hints.add(this.chkMangleQuery);
        hints.add(this.chkPhotoInline);
        p.add((Component)hints, "South");
        return p;
    }

    public void loadData(LdapDirectorySettings settings) {
        this.nameField.setText(settings.getName());
        this.hostnameField.setText(settings.getHostname());
        this.encryptionBox.setSelected(settings.getEncryption() == LdapConstants.Encryption.SSL);
        if (settings.getPort() != 0) {
            this.portModel.setValue(new Integer(settings.getPort()));
        } else {
            this.portModel.setValue(new Integer(settings.getEncryption().defaultPort()));
        }
        this.bindDNField.setText(settings.getBindDN());
        this.passwordField.setText(settings.getPassword());
        this.baseDNField.setText(settings.getBaseDN());
        this.scopeList.setSelectedIndex(settings.getScope().ordinal());
        this.authList.setSelectedIndex(settings.getAuth().ordinal());
        this.bindDNField.setEnabled(settings.getAuth() == LdapConstants.Auth.SIMPLE);
        this.passwordField.setEnabled(settings.getAuth() == LdapConstants.Auth.SIMPLE);
        this.mailField.setText(DirectorySettingsForm.mergeStrings(settings.getMailSearchFields()));
        this.mailSuffixField.setText(settings.getMailSuffix());
        this.workPhoneField.setText(DirectorySettingsForm.mergeStrings(settings.getWorkPhoneSearchFields()));
        this.mobilePhoneField.setText(DirectorySettingsForm.mergeStrings(settings.getMobilePhoneSearchFields()));
        this.homePhoneField.setText(DirectorySettingsForm.mergeStrings(settings.getHomePhoneSearchFields()));
        this.prefixField.setText(settings.getGlobalPhonePrefix());
        this.rdoDefaultQuery.setSelected(!"custom".equals(settings.getQueryMode()));
        this.rdoCustomQuery.setSelected("custom".equals(settings.getQueryMode()));
        this.txtCustomQuery.setText(settings.getCustomQuery());
        this.chkMangleQuery.setSelected(settings.isMangleQuery());
        this.chkPhotoInline.setSelected(settings.isPhotoInline());
        this.txtCustomQuery.setEditable(this.rdoCustomQuery.isSelected());
        this.txtCustomQuery.setEnabled(this.rdoCustomQuery.isSelected());
    }

    public static String mergeStrings(List<String> lst) {
        StringBuilder bld = new StringBuilder();
        for (String s : lst) {
            bld.append(s).append(" ");
        }
        return bld.toString();
    }

    public static List<String> mergeString(String attrs) {
        StringTokenizer token = new StringTokenizer(attrs, " ");
        ArrayList<String> lst = new ArrayList<String>();
        while (token.hasMoreTokens()) {
            lst.add(token.nextToken());
        }
        return lst;
    }

    public void saveData(LdapDirectorySettings settings) {
        settings.setName(this.nameField.getText());
        settings.setHostname(this.hostnameField.getText());
        if (this.encryptionBox.isSelected()) {
            settings.setEncryption(LdapConstants.Encryption.SSL);
        } else {
            settings.setEncryption(LdapConstants.Encryption.CLEAR);
        }
        switch (this.authList.getSelectedIndex()) {
            case 0: {
                settings.setAuth(LdapConstants.Auth.NONE);
                break;
            }
            case 1: {
                settings.setAuth(LdapConstants.Auth.SIMPLE);
            }
        }
        settings.setPort(((Integer)this.portSpinner.getValue()).intValue());
        settings.setBindDN(this.bindDNField.getText());
        settings.setPassword(new String(this.passwordField.getPassword()));
        settings.setBaseDN(this.baseDNField.getText());
        switch (this.scopeList.getSelectedIndex()) {
            case 0: {
                settings.setScope(LdapConstants.Scope.SUB);
                break;
            }
            case 1: {
                settings.setScope(LdapConstants.Scope.ONE);
            }
        }
        settings.setMailSearchFields(DirectorySettingsForm.mergeString(this.mailField.getText()));
        settings.setMailSuffix(this.mailSuffixField.getText());
        settings.setWorkPhoneSearchFields(DirectorySettingsForm.mergeString(this.workPhoneField.getText()));
        settings.setMobilePhoneSearchFields(DirectorySettingsForm.mergeString(this.mobilePhoneField.getText()));
        settings.setHomePhoneSearchFields(DirectorySettingsForm.mergeString(this.homePhoneField.getText()));
        settings.setGlobalPhonePrefix(this.prefixField.getText());
        settings.setQueryMode(this.rdoCustomQuery.isSelected() ? "custom" : null);
        settings.setCustomQuery(this.txtCustomQuery.getText());
        settings.setMangleQuery(this.chkMangleQuery.isSelected());
        settings.setPhotoInline(this.chkPhotoInline.isSelected());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.encryptionBox) {
            int port = (Integer)this.portSpinner.getValue();
            if (this.encryptionBox.isSelected()) {
                if (port == LdapConstants.Encryption.CLEAR.defaultPort()) {
                    this.portSpinner.setValue(new Integer(LdapConstants.Encryption.SSL.defaultPort()));
                }
            } else if (port == LdapConstants.Encryption.SSL.defaultPort()) {
                this.portSpinner.setValue(new Integer(LdapConstants.Encryption.CLEAR.defaultPort()));
            }
        } else if (src == this.saveBtn) {
            if (this.nameField.isEnabled()) {
                for (LdapDirectory s : LdapActivator.getLdapService().getServerSet()) {
                    if (!s.getSettings().getName().equals(this.nameField.getText())) continue;
                    JOptionPane.showMessageDialog((Component)((Object)this), Resources.getString("impl.ldap.SERVER_EXIST"), Resources.getString("impl.ldap.SERVER_EXIST"), 2);
                    return;
                }
            }
            this.saveData(this.settings);
            this.retCode = 1;
            this.dispose();
        } else if (src == this.cancelBtn) {
            this.retCode = 0;
            this.dispose();
        } else if (src == this.authList) {
            this.bindDNField.setEnabled(this.authList.getSelectedIndex() == 1);
            this.passwordField.setEnabled(this.authList.getSelectedIndex() == 1);
        } else if (src == this.rdoDefaultQuery) {
            this.txtCustomQuery.setEnabled(false);
            this.txtCustomQuery.setEditable(false);
            this.rdoCustomQuery.setSelected(false);
        } else if (src == this.rdoCustomQuery) {
            this.txtCustomQuery.setEnabled(true);
            this.txtCustomQuery.setEditable(true);
            this.rdoDefaultQuery.setSelected(false);
        }
    }

    protected void close(boolean escaped) {
        this.cancelBtn.doClick();
    }

    public int showDialog() {
        this.retCode = 0;
        this.setVisible(true);
        this.setVisible(false);
        return this.retCode;
    }

    public LdapDirectorySettings getSettings() {
        return this.settings;
    }

    public void setNameFieldEnabled(boolean enable) {
        this.nameField.setEnabled(enable);
    }

    public void setHostnameFieldEnabled(boolean enable) {
        this.hostnameField.setEnabled(enable);
    }

    public void setBaseDNFieldEnabled(boolean enable) {
        this.scopeList.setEnabled(enable);
        this.baseDNField.setEnabled(enable);
    }

    public void setPortFieldEnabled(boolean enable) {
        this.encryptionBox.setEnabled(enable);
        this.portSpinner.setEnabled(enable);
    }
}

