/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.muc;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import net.java.sip.communicator.impl.muc.ChatRoomContactSourceService;
import net.java.sip.communicator.impl.muc.ChatRoomSourceContact;
import net.java.sip.communicator.impl.muc.MUCActivator;
import net.java.sip.communicator.impl.muc.MUCServiceImpl;
import net.java.sip.communicator.service.contactsource.AsyncContactQuery;
import net.java.sip.communicator.service.contactsource.ContactQueryListener;
import net.java.sip.communicator.service.contactsource.ContactSourceService;
import net.java.sip.communicator.service.contactsource.SourceContact;
import net.java.sip.communicator.service.muc.ChatRoomListChangeEvent;
import net.java.sip.communicator.service.muc.ChatRoomListChangeListener;
import net.java.sip.communicator.service.muc.ChatRoomPresenceStatus;
import net.java.sip.communicator.service.muc.ChatRoomProviderWrapper;
import net.java.sip.communicator.service.muc.ChatRoomProviderWrapperListener;
import net.java.sip.communicator.service.muc.ChatRoomWrapper;
import net.java.sip.communicator.service.protocol.ChatRoom;
import net.java.sip.communicator.service.protocol.OperationSetMultiUserChat;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import net.java.sip.communicator.service.protocol.event.LocalUserChatRoomPresenceChangeEvent;
import net.java.sip.communicator.service.protocol.event.LocalUserChatRoomPresenceListener;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;

public class ChatRoomQuery
extends AsyncContactQuery<ContactSourceService>
implements LocalUserChatRoomPresenceListener,
ChatRoomListChangeListener,
ChatRoomProviderWrapperListener {
    private String queryString;
    private Set<ChatRoomSourceContact> contactResults = new TreeSet<ChatRoomSourceContact>();
    private MUCServiceImpl mucService;
    private int contactQueryListenersCount = 0;
    private ServiceListener protolProviderRegistrationListener = null;

    public ChatRoomQuery(String queryString, ChatRoomContactSourceService contactSource) {
        super((ContactSourceService)contactSource, Pattern.compile(queryString, 18), true);
        this.queryString = queryString;
        this.mucService = MUCActivator.getMUCService();
    }

    private void initListeners() {
        for (ProtocolProviderService pps : MUCActivator.getChatRoomProviders()) {
            this.addQueryToProviderPresenceListeners(pps);
        }
        this.mucService.addChatRoomListChangeListener(this);
        this.mucService.addChatRoomProviderWrapperListener(this);
        this.protolProviderRegistrationListener = new ProtocolProviderRegListener();
        MUCActivator.bundleContext.addServiceListener(this.protolProviderRegistrationListener);
    }

    public void addQueryToProviderPresenceListeners(ProtocolProviderService pps) {
        OperationSetMultiUserChat opSetMUC = (OperationSetMultiUserChat)pps.getOperationSet(OperationSetMultiUserChat.class);
        if (opSetMUC != null) {
            opSetMUC.addPresenceListener((LocalUserChatRoomPresenceListener)this);
        }
    }

    public void removeQueryFromProviderPresenceListeners(ProtocolProviderService pps) {
        OperationSetMultiUserChat opSetMUC = (OperationSetMultiUserChat)pps.getOperationSet(OperationSetMultiUserChat.class);
        if (opSetMUC != null) {
            opSetMUC.removePresenceListener((LocalUserChatRoomPresenceListener)this);
        }
    }

    protected void run() {
        Iterator<ChatRoomProviderWrapper> chatRoomProviders = this.mucService.getChatRoomProviders();
        while (chatRoomProviders.hasNext()) {
            ChatRoomProviderWrapper provider = chatRoomProviders.next();
            this.providerAdded(provider, true);
        }
        if (this.getStatus() != 1) {
            this.setStatus(0);
        }
    }

    private void providerAdded(ChatRoomProviderWrapper provider, boolean addQueryResult) {
        for (int i = 0; i < provider.countChatRooms(); ++i) {
            ChatRoomWrapper chatRoom = provider.getChatRoom(i);
            this.addChatRoom(provider.getProtocolProvider(), chatRoom.getChatRoomName(), chatRoom.getChatRoomID(), addQueryResult, chatRoom.isAutojoin());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void localUserPresenceChanged(LocalUserChatRoomPresenceChangeEvent evt) {
        ChatRoom sourceChatRoom = evt.getChatRoom();
        String eventType = evt.getEventType();
        boolean existingContact = false;
        ChatRoomSourceContact foundContact = null;
        Set<ChatRoomSourceContact> set = this.contactResults;
        synchronized (set) {
            for (ChatRoomSourceContact contact : this.contactResults) {
                if (!this.contactEqualsChatRoom(contact, sourceChatRoom)) continue;
                existingContact = true;
                foundContact = contact;
                this.contactResults.remove((Object)contact);
                break;
            }
        }
        if ("LocalUserJoined".equals(eventType)) {
            if (existingContact) {
                foundContact.setPresenceStatus(ChatRoomPresenceStatus.CHAT_ROOM_ONLINE);
                set = this.contactResults;
                synchronized (set) {
                    this.contactResults.add(foundContact);
                }
                this.fireContactChanged((SourceContact)foundContact);
            } else {
                ChatRoomWrapper chatRoom = MUCActivator.getMUCService().findChatRoomWrapperFromChatRoom(sourceChatRoom);
                if (chatRoom != null) {
                    this.addChatRoom(sourceChatRoom, false, chatRoom.isAutojoin());
                }
            }
        } else if (("LocalUserLeft".equals(eventType) || "LocalUserKicked".equals(eventType) || "LocalUserDropped".equals(eventType)) && existingContact) {
            foundContact.setPresenceStatus(ChatRoomPresenceStatus.CHAT_ROOM_OFFLINE);
            set = this.contactResults;
            synchronized (set) {
                this.contactResults.add(foundContact);
            }
            this.fireContactChanged((SourceContact)foundContact);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addChatRoom(ChatRoom room, boolean addQueryResult, boolean isAutoJoin) {
        if (this.queryString == null || room.getName().contains(this.queryString) || room.getIdentifier().contains(this.queryString)) {
            ChatRoomSourceContact contact = new ChatRoomSourceContact(room, this, isAutoJoin);
            Set<ChatRoomSourceContact> set = this.contactResults;
            synchronized (set) {
                this.contactResults.add(contact);
            }
            if (addQueryResult) {
                this.addQueryResult((SourceContact)contact, false);
            } else {
                this.fireContactReceived((SourceContact)contact, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addChatRoom(ProtocolProviderService pps, String chatRoomName, String chatRoomID, boolean addQueryResult, boolean isAutoJoin) {
        if (this.queryString == null || chatRoomName.contains(this.queryString) || chatRoomID.contains(this.queryString)) {
            ChatRoomSourceContact contact = new ChatRoomSourceContact(chatRoomName, chatRoomID, this, pps, isAutoJoin);
            Set<ChatRoomSourceContact> set = this.contactResults;
            synchronized (set) {
                this.contactResults.add(contact);
            }
            if (addQueryResult) {
                this.addQueryResult((SourceContact)contact, false);
            } else {
                this.fireContactReceived((SourceContact)contact, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void contentChanged(ChatRoomListChangeEvent evt) {
        ChatRoomWrapper chatRoom = evt.getSourceChatRoom();
        switch (evt.getEventID()) {
            case 1: {
                this.addChatRoom(chatRoom.getChatRoom(), false, chatRoom.isAutojoin());
                break;
            }
            case 2: {
                Set<ChatRoomSourceContact> set = this.contactResults;
                synchronized (set) {
                    LinkedList<ChatRoomSourceContact> tmpContactResults = new LinkedList<ChatRoomSourceContact>(this.contactResults);
                    for (ChatRoomSourceContact contact : tmpContactResults) {
                        if (!this.contactEqualsChatRoom(contact, chatRoom)) continue;
                        this.contactResults.remove((Object)contact);
                        this.fireContactRemoved((SourceContact)contact);
                        break;
                    }
                    break;
                }
            }
            case 3: {
                Set<ChatRoomSourceContact> set = this.contactResults;
                synchronized (set) {
                    for (ChatRoomSourceContact contact : this.contactResults) {
                        if (!this.contactEqualsChatRoom(contact, chatRoom.getChatRoom())) continue;
                        if (chatRoom.isAutojoin() == contact.isAutoJoin()) break;
                        contact.setAutoJoin(chatRoom.isAutojoin());
                        this.fireContactChanged((SourceContact)contact);
                        break;
                    }
                    break;
                }
            }
        }
    }

    @Override
    public void chatRoomProviderWrapperAdded(ChatRoomProviderWrapper provider) {
        this.providerAdded(provider, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void chatRoomProviderWrapperRemoved(ChatRoomProviderWrapper provider) {
        Set<ChatRoomSourceContact> set = this.contactResults;
        synchronized (set) {
            LinkedList<ChatRoomSourceContact> tmpContactResults = new LinkedList<ChatRoomSourceContact>(this.contactResults);
            for (ChatRoomSourceContact contact : tmpContactResults) {
                if (!contact.getProvider().equals(provider.getProtocolProvider())) continue;
                this.contactResults.remove((Object)contact);
                this.fireContactRemoved((SourceContact)contact);
            }
        }
    }

    private boolean contactEqualsChatRoom(ChatRoomSourceContact contact, ChatRoom chatRoom) {
        return contact.getProvider() == chatRoom.getParentProvider() && chatRoom.getIdentifier().equals(contact.getContactAddress());
    }

    private boolean contactEqualsChatRoom(ChatRoomSourceContact contact, ChatRoomWrapper chatRoomWrapper) {
        return contact.getProvider() == chatRoomWrapper.getParentProvider().getProtocolProvider() && contact.getContactAddress().equals(chatRoomWrapper.getChatRoomID());
    }

    public synchronized int indexOf(ChatRoomSourceContact contact) {
        Iterator<ChatRoomSourceContact> it = this.contactResults.iterator();
        int i = 0;
        while (it.hasNext()) {
            if (((Object)((Object)contact)).equals((Object)it.next())) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private void clearListeners() {
        this.mucService.removeChatRoomListChangeListener(this);
        this.mucService.removeChatRoomProviderWrapperListener(this);
        if (this.protolProviderRegistrationListener != null) {
            MUCActivator.bundleContext.removeServiceListener(this.protolProviderRegistrationListener);
        }
        this.protolProviderRegistrationListener = null;
        for (ProtocolProviderService pps : MUCActivator.getChatRoomProviders()) {
            this.removeQueryFromProviderPresenceListeners(pps);
        }
    }

    public void cancel() {
        this.clearListeners();
        super.cancel();
    }

    public void setStatus(int status) {
        if (status == 1) {
            this.clearListeners();
        }
        super.setStatus(status);
    }

    public void addContactQueryListener(ContactQueryListener l) {
        super.addContactQueryListener(l);
        ++this.contactQueryListenersCount;
        if (this.contactQueryListenersCount == 1) {
            this.initListeners();
        }
    }

    public void removeContactQueryListener(ContactQueryListener l) {
        super.removeContactQueryListener(l);
        --this.contactQueryListenersCount;
        if (this.contactQueryListenersCount == 0) {
            this.clearListeners();
        }
    }

    private class ProtocolProviderRegListener
    implements ServiceListener {
        private ProtocolProviderRegListener() {
        }

        public void serviceChanged(ServiceEvent event) {
            ServiceReference serviceRef = event.getServiceReference();
            if (serviceRef.getBundle().getState() == 16) {
                return;
            }
            Object service = MUCActivator.bundleContext.getService(serviceRef);
            if (!(service instanceof ProtocolProviderService)) {
                return;
            }
            switch (event.getType()) {
                case 1: {
                    ChatRoomQuery.this.addQueryToProviderPresenceListeners((ProtocolProviderService)service);
                    break;
                }
                case 4: {
                    ChatRoomQuery.this.removeQueryFromProviderPresenceListeners((ProtocolProviderService)service);
                }
            }
        }
    }
}

