/*
 * Decompiled with CFR 0.152.
 */
package com.ircclouds.irc.api.domain;

import com.ircclouds.irc.api.domain.ChannelMode;
import com.ircclouds.irc.api.domain.IRCTopic;
import com.ircclouds.irc.api.domain.IRCUser;
import com.ircclouds.irc.api.domain.IRCUserStatus;
import com.ircclouds.irc.api.domain.WritableIRCTopic;
import com.ircclouds.irc.api.utils.SynchronizedUnmodifiableList;
import com.ircclouds.irc.api.utils.SynchronizedUnmodifiableSet;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class IRCChannel
implements Serializable {
    String name;
    IRCTopic topic;
    Set<ChannelMode> chanModes = new SynchronizedUnmodifiableSet(new HashSet());
    SynchronizedUnmodifiableList<IRCUser> users = new SynchronizedUnmodifiableList(new ArrayList());
    Map<IRCUser, Set<IRCUserStatus>> usersStatuses = new LinkedHashMap<IRCUser, Set<IRCUserStatus>>();

    public IRCChannel(String aName) {
        this(aName, new WritableIRCTopic(""));
    }

    public IRCChannel(String aName, IRCTopic aTopic) {
        this.name = aName;
        this.topic = aTopic;
    }

    public String getName() {
        return this.name;
    }

    public IRCTopic getTopic() {
        return this.topic;
    }

    public Set<ChannelMode> getModes() {
        return this.chanModes;
    }

    public boolean contains(String aNick) {
        return this.contains(new IRCUser(aNick));
    }

    public boolean contains(IRCUser aUser) {
        return this.users.contains(aUser);
    }

    public Set<IRCUserStatus> getStatusesForUser(IRCUser aUser) {
        return this.usersStatuses.get(aUser);
    }

    public List<IRCUser> getUsers() {
        return this.users;
    }

    public boolean equals(Object aObject) {
        if (aObject instanceof IRCChannel) {
            return this.name.equals(((IRCChannel)aObject).getName());
        }
        return false;
    }

    public int hashCode() {
        return this.name.hashCode();
    }
}

