/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.irc;

import com.ircclouds.irc.api.IRCApi;
import com.ircclouds.irc.api.domain.messages.ClientErrorMessage;
import com.ircclouds.irc.api.domain.messages.ErrorMessage;
import com.ircclouds.irc.api.domain.messages.QuitMessage;
import com.ircclouds.irc.api.domain.messages.ServerNumericMessage;
import com.ircclouds.irc.api.listeners.IMessageListener;
import com.ircclouds.irc.api.state.IIRCState;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import net.java.sip.communicator.impl.protocol.irc.AbstractIrcMessageListener;
import net.java.sip.communicator.impl.protocol.irc.IrcStatusEnum;
import net.java.sip.communicator.impl.protocol.irc.OperationSetPersistentPresenceIrcImpl;
import net.java.sip.communicator.impl.protocol.irc.PresenceWatcher;
import net.java.sip.communicator.util.Logger;

class WatchPresenceWatcher
implements PresenceWatcher {
    private static final int WATCH_ADD_CMD_STATIC_OVERHEAD = 6;
    private static final Logger LOGGER = Logger.getLogger(WatchPresenceWatcher.class);
    private final IRCApi irc;
    private final IIRCState connectionState;
    private final Set<String> nickWatchList;

    WatchPresenceWatcher(IRCApi irc, IIRCState connectionState, Set<String> nickWatchList, Set<String> monitored, OperationSetPersistentPresenceIrcImpl operationSet, int maxListSize) {
        if (irc == null) {
            throw new IllegalArgumentException("irc cannot be null");
        }
        this.irc = irc;
        if (connectionState == null) {
            throw new IllegalArgumentException("connectionState cannot be null");
        }
        this.connectionState = connectionState;
        if (nickWatchList == null) {
            throw new IllegalArgumentException("nickWatchList cannot be null");
        }
        this.nickWatchList = nickWatchList;
        this.irc.addListener((IMessageListener)new WatchReplyListener(monitored, operationSet));
        WatchPresenceWatcher.setUpWatch(this.irc, this.nickWatchList, maxListSize);
        LOGGER.debug((Object)"WATCH presence watcher initialized.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setUpWatch(IRCApi irc, Collection<String> nickWatchList, int maxListSize) {
        List<String> current;
        Collection<String> collection = nickWatchList;
        synchronized (collection) {
            current = new LinkedList<String>(nickWatchList);
        }
        if (current.size() > maxListSize) {
            current = current.subList(0, maxListSize);
        }
        int maxLength = 504;
        StringBuilder query = new StringBuilder();
        for (String nick : current) {
            if (query.length() + nick.length() + 2 > 504) {
                irc.rawMessage("WATCH " + query);
                query.delete(0, query.length());
            } else if (query.length() > 0) {
                query.append(" ");
            }
            query.append('+').append(nick);
        }
        if (query.length() > 0) {
            irc.rawMessage("WATCH " + query);
        }
    }

    @Override
    public void add(String nick) {
        LOGGER.trace((Object)("Adding nick '" + nick + "' to WATCH watch list."));
        this.nickWatchList.add(nick);
        this.irc.rawMessage("WATCH +" + nick);
    }

    @Override
    public void remove(String nick) {
        LOGGER.trace((Object)("Removing nick '" + nick + "' from WATCH watch list."));
        this.nickWatchList.remove(nick);
        this.irc.rawMessage("WATCH -" + nick);
    }

    private final class WatchReplyListener
    extends AbstractIrcMessageListener {
        private static final int IRC_RPL_LOGON = 600;
        private static final int IRC_RPL_LOGOFF = 601;
        private static final int IRC_RPL_WATCHOFF = 602;
        private static final int IRC_RPL_NOWON = 604;
        private static final int IRC_RPL_NOWOFF = 605;
        private static final int IRC_ERR_LISTFULL = 512;
        private final OperationSetPersistentPresenceIrcImpl operationSet;
        private final Set<String> monitoredNickList;

        public WatchReplyListener(Set<String> monitored, OperationSetPersistentPresenceIrcImpl operationSet) {
            super(WatchPresenceWatcher.this.irc, WatchPresenceWatcher.this.connectionState);
            if (operationSet == null) {
                throw new IllegalArgumentException("operationSet cannot be null");
            }
            this.operationSet = operationSet;
            if (monitored == null) {
                throw new IllegalArgumentException("monitored cannot be null");
            }
            this.monitoredNickList = monitored;
        }

        public void onServerNumericMessage(ServerNumericMessage msg) {
            switch (msg.getNumericCode()) {
                case 604: {
                    String nick = this.parseWatchResponse(msg.getText());
                    this.monitoredNickList.add(nick);
                    this.update(nick, IrcStatusEnum.ONLINE);
                    break;
                }
                case 600: {
                    String nick = this.parseWatchResponse(msg.getText());
                    this.update(nick, IrcStatusEnum.ONLINE);
                    break;
                }
                case 605: {
                    String nick = this.parseWatchResponse(msg.getText());
                    this.monitoredNickList.add(nick);
                    this.update(nick, IrcStatusEnum.OFFLINE);
                    break;
                }
                case 601: {
                    String nick = this.parseWatchResponse(msg.getText());
                    this.update(nick, IrcStatusEnum.OFFLINE);
                    break;
                }
                case 602: {
                    String nick = this.parseWatchResponse(msg.getText());
                    this.monitoredNickList.remove(nick);
                    break;
                }
                case 512: {
                    LOGGER.debug((Object)("WATCH list is full. Nick was not added. Fall back Basic Poller will be used if it is enabled. (" + msg.getText() + ")"));
                }
            }
        }

        @Override
        public void onUserQuit(QuitMessage msg) {
            super.onUserQuit(msg);
            if (this.localUser(msg.getSource().getNick())) {
                this.updateAll(IrcStatusEnum.OFFLINE);
            }
        }

        @Override
        public void onError(ErrorMessage msg) {
            super.onError(msg);
            this.updateAll(IrcStatusEnum.OFFLINE);
        }

        @Override
        public void onClientError(ClientErrorMessage msg) {
            super.onClientError(msg);
            this.updateAll(IrcStatusEnum.OFFLINE);
        }

        private String parseWatchResponse(String message) {
            String[] parts = message.split(" ");
            return parts[0];
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void updateAll(IrcStatusEnum status) {
            LinkedList<String> nicks;
            Set<String> set = this.monitoredNickList;
            synchronized (set) {
                nicks = new LinkedList<String>(this.monitoredNickList);
            }
            for (String nick : nicks) {
                this.update(nick, status);
            }
        }

        private void update(String nick, IrcStatusEnum status) {
            this.operationSet.updateNickContactPresence(nick, status);
        }
    }
}

