/*
 * Decompiled with CFR 0.152.
 */
package javax.jmdns.test;

import java.util.Map;
import javax.jmdns.ServiceInfo;
import javax.jmdns.impl.ServiceInfoImpl;
import junit.framework.Assert;
import org.junit.Before;
import org.junit.Test;

public class ServiceInfoTest {
    @Before
    public void setup() {
    }

    @Test
    public void testDecodeQualifiedNameMap() {
        String string = "test.com";
        String string2 = "udp";
        String string3 = "ftp";
        String string4 = "My Service";
        String string5 = "printer";
        String string6 = "_" + string3 + "._" + string2 + "." + string + ".";
        Map<ServiceInfo.Fields, String> map = ServiceInfoImpl.decodeQualifiedNameMap(string6, string4, string5);
        Assert.assertEquals((String)"We did not get the right domain:", (String)string, (String)map.get((Object)ServiceInfo.Fields.Domain));
        Assert.assertEquals((String)"We did not get the right protocol:", (String)string2, (String)map.get((Object)ServiceInfo.Fields.Protocol));
        Assert.assertEquals((String)"We did not get the right application:", (String)string3, (String)map.get((Object)ServiceInfo.Fields.Application));
        Assert.assertEquals((String)"We did not get the right name:", (String)string4, (String)map.get((Object)ServiceInfo.Fields.Instance));
        Assert.assertEquals((String)"We did not get the right subtype:", (String)string5, (String)map.get((Object)ServiceInfo.Fields.Subtype));
    }

    @Test
    public void testDecodeQualifiedNameMapDefaults() {
        String string = "local";
        String string2 = "tcp";
        String string3 = "ftp";
        String string4 = "My Service";
        String string5 = "";
        Map<ServiceInfo.Fields, String> map = ServiceInfoImpl.decodeQualifiedNameMap(string3, string4, string5);
        Assert.assertEquals((String)"We did not get the right domain:", (String)string, (String)map.get((Object)ServiceInfo.Fields.Domain));
        Assert.assertEquals((String)"We did not get the right protocol:", (String)string2, (String)map.get((Object)ServiceInfo.Fields.Protocol));
        Assert.assertEquals((String)"We did not get the right application:", (String)string3, (String)map.get((Object)ServiceInfo.Fields.Application));
        Assert.assertEquals((String)"We did not get the right name:", (String)string4, (String)map.get((Object)ServiceInfo.Fields.Instance));
        Assert.assertEquals((String)"We did not get the right subtype:", (String)string5, (String)map.get((Object)ServiceInfo.Fields.Subtype));
    }

    @Test
    public void testDecodeServiceType() {
        String string = "_home-sharing._tcp.local.";
        Map<ServiceInfo.Fields, String> map = ServiceInfoImpl.decodeQualifiedNameMapForType(string);
        Assert.assertEquals((String)"We did not get the right domain:", (String)"local", (String)map.get((Object)ServiceInfo.Fields.Domain));
        Assert.assertEquals((String)"We did not get the right protocol:", (String)"tcp", (String)map.get((Object)ServiceInfo.Fields.Protocol));
        Assert.assertEquals((String)"We did not get the right application:", (String)"home-sharing", (String)map.get((Object)ServiceInfo.Fields.Application));
        Assert.assertEquals((String)"We did not get the right name:", (String)"", (String)map.get((Object)ServiceInfo.Fields.Instance));
        Assert.assertEquals((String)"We did not get the right subtype:", (String)"", (String)map.get((Object)ServiceInfo.Fields.Subtype));
    }

    @Test
    public void testDecodeServiceTCPType() {
        String string = "_afpovertcp._tcp.local.";
        Map<ServiceInfo.Fields, String> map = ServiceInfoImpl.decodeQualifiedNameMapForType(string);
        Assert.assertEquals((String)"We did not get the right domain:", (String)"local", (String)map.get((Object)ServiceInfo.Fields.Domain));
        Assert.assertEquals((String)"We did not get the right protocol:", (String)"tcp", (String)map.get((Object)ServiceInfo.Fields.Protocol));
        Assert.assertEquals((String)"We did not get the right application:", (String)"afpovertcp", (String)map.get((Object)ServiceInfo.Fields.Application));
        Assert.assertEquals((String)"We did not get the right name:", (String)"", (String)map.get((Object)ServiceInfo.Fields.Instance));
        Assert.assertEquals((String)"We did not get the right subtype:", (String)"", (String)map.get((Object)ServiceInfo.Fields.Subtype));
    }

    @Test
    public void testDecodeServiceTypeWithSubType() {
        String string = "_00000000-0b44-f234-48c8-071c565644b3._sub._home-sharing._tcp.local.";
        Map<ServiceInfo.Fields, String> map = ServiceInfoImpl.decodeQualifiedNameMapForType(string);
        Assert.assertEquals((String)"We did not get the right domain:", (String)"local", (String)map.get((Object)ServiceInfo.Fields.Domain));
        Assert.assertEquals((String)"We did not get the right protocol:", (String)"tcp", (String)map.get((Object)ServiceInfo.Fields.Protocol));
        Assert.assertEquals((String)"We did not get the right application:", (String)"home-sharing", (String)map.get((Object)ServiceInfo.Fields.Application));
        Assert.assertEquals((String)"We did not get the right name:", (String)"", (String)map.get((Object)ServiceInfo.Fields.Instance));
        Assert.assertEquals((String)"We did not get the right subtype:", (String)"00000000-0b44-f234-48c8-071c565644b3", (String)map.get((Object)ServiceInfo.Fields.Subtype));
    }

    @Test
    public void testDecodeServiceName() {
        String string = "My New Itunes Service._home-sharing._tcp.local.";
        Map<ServiceInfo.Fields, String> map = ServiceInfoImpl.decodeQualifiedNameMapForType(string);
        Assert.assertEquals((String)"We did not get the right domain:", (String)"local", (String)map.get((Object)ServiceInfo.Fields.Domain));
        Assert.assertEquals((String)"We did not get the right protocol:", (String)"tcp", (String)map.get((Object)ServiceInfo.Fields.Protocol));
        Assert.assertEquals((String)"We did not get the right application:", (String)"home-sharing", (String)map.get((Object)ServiceInfo.Fields.Application));
        Assert.assertEquals((String)"We did not get the right name:", (String)"My New Itunes Service", (String)map.get((Object)ServiceInfo.Fields.Instance));
        Assert.assertEquals((String)"We did not get the right subtype:", (String)"", (String)map.get((Object)ServiceInfo.Fields.Subtype));
    }

    @Test
    public void testDecodeDNSMetaQuery() {
        String string = "_services._dns-sd._udp.local.";
        Map<ServiceInfo.Fields, String> map = ServiceInfoImpl.decodeQualifiedNameMapForType(string);
        Assert.assertEquals((String)"We did not get the right domain:", (String)"local", (String)map.get((Object)ServiceInfo.Fields.Domain));
        Assert.assertEquals((String)"We did not get the right protocol:", (String)"udp", (String)map.get((Object)ServiceInfo.Fields.Protocol));
        Assert.assertEquals((String)"We did not get the right application:", (String)"dns-sd", (String)map.get((Object)ServiceInfo.Fields.Application));
        Assert.assertEquals((String)"We did not get the right name:", (String)"_services", (String)map.get((Object)ServiceInfo.Fields.Instance));
        Assert.assertEquals((String)"We did not get the right subtype:", (String)"", (String)map.get((Object)ServiceInfo.Fields.Subtype));
    }

    @Test
    public void testReverseDNSQuery() {
        String string = "100.50.168.192.in-addr.arpa.";
        Map<ServiceInfo.Fields, String> map = ServiceInfoImpl.decodeQualifiedNameMapForType(string);
        Assert.assertEquals((String)"We did not get the right domain:", (String)"in-addr.arpa", (String)map.get((Object)ServiceInfo.Fields.Domain));
        Assert.assertEquals((String)"We did not get the right protocol:", (String)"", (String)map.get((Object)ServiceInfo.Fields.Protocol));
        Assert.assertEquals((String)"We did not get the right application:", (String)"", (String)map.get((Object)ServiceInfo.Fields.Application));
        Assert.assertEquals((String)"We did not get the right name:", (String)"100.50.168.192", (String)map.get((Object)ServiceInfo.Fields.Instance));
        Assert.assertEquals((String)"We did not get the right subtype:", (String)"", (String)map.get((Object)ServiceInfo.Fields.Subtype));
    }

    @Test
    public void testAddress() {
        String string = "panoramix.local.";
        Map<ServiceInfo.Fields, String> map = ServiceInfoImpl.decodeQualifiedNameMapForType(string);
        Assert.assertEquals((String)"We did not get the right domain:", (String)"local", (String)map.get((Object)ServiceInfo.Fields.Domain));
        Assert.assertEquals((String)"We did not get the right protocol:", (String)"", (String)map.get((Object)ServiceInfo.Fields.Protocol));
        Assert.assertEquals((String)"We did not get the right application:", (String)"", (String)map.get((Object)ServiceInfo.Fields.Application));
        Assert.assertEquals((String)"We did not get the right name:", (String)"panoramix", (String)map.get((Object)ServiceInfo.Fields.Instance));
        Assert.assertEquals((String)"We did not get the right subtype:", (String)"", (String)map.get((Object)ServiceInfo.Fields.Subtype));
    }
}

