/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.propertieseditor;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.TextUI;
import javax.swing.table.DefaultTableModel;
import net.java.sip.communicator.plugin.desktoputil.LowPriorityEventQueue;
import net.java.sip.communicator.plugin.desktoputil.SIPCommTextField;
import net.java.sip.communicator.plugin.desktoputil.plaf.SearchFieldUI;
import net.java.sip.communicator.plugin.propertieseditor.PropertiesEditorActivator;
import net.java.sip.communicator.util.skin.Skinnable;
import org.apache.commons.lang3.StringUtils;
import org.jitsi.service.configuration.ConfigurationService;

public class SearchField
extends SIPCommTextField
implements Skinnable {
    private static final long serialVersionUID = 1L;
    private static final long FILTER_THREAD_TIMEOUT = 300000L;
    private static final String uiClassID = SearchField.class.getName() + "FieldUI";
    private final ConfigurationService confService = PropertiesEditorActivator.getConfigurationService();
    private String filter;
    private final Object filterSyncRoot = new Object();
    private Thread filterThread;
    private final JTable table;

    public SearchField(String text, JTable table) {
        super(text);
        this.table = table;
        TextUI ui = this.getUI();
        if (ui instanceof SearchFieldUI) {
            SearchFieldUI searchFieldUI = (SearchFieldUI)ui;
            searchFieldUI.setCallButtonEnabled(false);
            searchFieldUI.setDeleteButtonEnabled(true);
        }
        this.setBorder(null);
        this.setDragEnabled(true);
        this.setOpaque(false);
        this.setPreferredSize(new Dimension(100, 25));
        InputMap imap = this.getInputMap(1);
        imap.put(KeyStroke.getKeyStroke(27, 0), "escape");
        ActionMap amap = this.getActionMap();
        AbstractAction escapeAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchField.this.setText("");
            }
        };
        amap.put("escape", escapeAction);
        this.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                SearchField.this.filter(SearchField.this.getText());
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                SearchField.this.filter(SearchField.this.getText());
            }
        });
        this.loadSkin();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void filter(String filter) {
        Object object = this.filterSyncRoot;
        synchronized (object) {
            this.filter = filter;
            if (this.filterThread == null) {
                this.filterThread = new Thread(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            SearchField.this.runInFilterThread();
                        }
                        finally {
                            Object object = SearchField.this.filterSyncRoot;
                            synchronized (object) {
                                if (Thread.currentThread().equals(SearchField.this.filterThread)) {
                                    SearchField.this.filterThread = null;
                                }
                            }
                        }
                    }
                };
                this.filterThread.setDaemon(true);
                this.filterThread.setName(SearchField.class.getName() + ".filterThread");
                this.filterThread.start();
            } else {
                this.filterSyncRoot.notify();
            }
        }
    }

    public String getUIClassID() {
        return uiClassID;
    }

    public void loadSkin() {
        TextUI ui = this.getUI();
        if (ui instanceof SearchFieldUI) {
            ((SearchFieldUI)ui).loadSkin();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runInFilterThread() {
        String prevFilter = null;
        long prevFilterTime = 0L;
        while (true) {
            String filter;
            Object object = this.filterSyncRoot;
            synchronized (object) {
                filter = this.filter;
                if (prevFilterTime != 0L && StringUtils.equalsIgnoreCase((CharSequence)filter, prevFilter)) {
                    long timeout = 300000L - (System.currentTimeMillis() - prevFilterTime);
                    if (timeout > 0L) {
                        try {
                            this.filterSyncRoot.wait(timeout);
                            continue;
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    if (Thread.currentThread().equals(this.filterThread)) {
                        this.filterThread = null;
                    }
                    break;
                }
            }
            List properties = this.confService.getAllPropertyNames();
            final ArrayList<Object[]> rows = new ArrayList<Object[]>(properties.size());
            for (String property : properties) {
                String value = (String)this.confService.getProperty(property);
                if (filter != null && !StringUtils.containsIgnoreCase((CharSequence)property, (CharSequence)filter) && !StringUtils.containsIgnoreCase((CharSequence)value, (CharSequence)filter)) continue;
                rows.add(new Object[]{property, this.confService.getProperty(property)});
            }
            if (StringUtils.equalsIgnoreCase((CharSequence)filter, (CharSequence)this.filter)) {
                LowPriorityEventQueue.invokeLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        DefaultTableModel model = (DefaultTableModel)SearchField.this.table.getModel();
                        model.setRowCount(0);
                        for (Object[] row : rows) {
                            model.addRow(row);
                            if (filter == SearchField.this.filter) continue;
                            return;
                        }
                    }
                });
            }
            prevFilter = filter;
            prevFilterTime = System.currentTimeMillis();
        }
    }

    static {
        UIManager.getDefaults().put(uiClassID, SearchFieldUI.class.getName());
    }
}

