/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd.conn;

import java.io.IOException;
import java.io.OutputStream;
import net.kano.joscar.BinaryTools;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.Writable;

public class SnacFamilyInfo
implements Writable {
    private final int family;
    private final int version;
    private final int toolID;
    private final int toolVersion;

    protected static SnacFamilyInfo readSnacFamilyInfo(ByteBlock block) {
        DefensiveTools.checkNull(block, "block");
        int family = BinaryTools.getUShort(block, 0);
        int version = BinaryTools.getUShort(block, 2);
        int toolid = BinaryTools.getUShort(block, 4);
        int toolver = BinaryTools.getUShort(block, 6);
        return new SnacFamilyInfo(family, version, toolid, toolver);
    }

    public SnacFamilyInfo(int family, int version) {
        this(family, version, -1, -1);
    }

    public SnacFamilyInfo(int family, int version, int toolID, int toolVersion) {
        DefensiveTools.checkRange(family, "family", 0);
        DefensiveTools.checkRange(version, "version", 0);
        DefensiveTools.checkRange(toolID, "toolID", -1);
        DefensiveTools.checkRange(toolVersion, "toolVersion", -1);
        this.family = family;
        this.version = version;
        this.toolID = toolID;
        this.toolVersion = toolVersion;
    }

    public final int getFamily() {
        return this.family;
    }

    public final int getVersion() {
        return this.version;
    }

    public final int getToolID() {
        return this.toolID;
    }

    public final int getToolVersion() {
        return this.toolVersion;
    }

    public long getWritableLength() {
        return 8L;
    }

    public void write(OutputStream out) throws IOException {
        BinaryTools.writeUShort(out, this.family);
        BinaryTools.writeUShort(out, this.version);
        if (this.toolID != -1 && this.toolVersion != -1) {
            BinaryTools.writeUShort(out, this.toolID);
            BinaryTools.writeUShort(out, this.toolVersion);
        }
    }

    public String toString() {
        return "SnacFamilyInfo: family=0x" + Integer.toHexString(this.family) + ", version=0x" + Integer.toHexString(this.version) + ", toolID=0x" + Integer.toHexString(this.toolID) + ", toolVersion=0x" + Integer.toHexString(this.toolVersion);
    }
}

