/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joustsim.oscar.oscar.service.icbm.ft.controllers;

import java.util.logging.Level;
import java.util.logging.Logger;
import net.kano.joscar.CopyOnWriteArrayList;
import net.kano.joscar.MiscTools;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.controllers.ControllerListener;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.controllers.ExceptionStateInfo;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.controllers.StateController;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.events.RvConnectionEvent;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.state.FailedStateInfo;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.state.FailureEventInfo;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.state.StateInfo;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.state.SuccessfulStateInfo;

public abstract class AbstractStateController
implements StateController {
    private static final Logger LOGGER = Logger.getLogger(AbstractStateController.class.getName());
    private CopyOnWriteArrayList<ControllerListener> listeners = new CopyOnWriteArrayList();
    private StateInfo endState = null;

    public void addControllerListener(ControllerListener listener) {
        this.listeners.addIfAbsent(listener);
    }

    public void removeControllerListener(ControllerListener listener) {
        this.listeners.remove(listener);
    }

    protected void fireSucceeded(StateInfo stateInfo) {
        assert (!Thread.holdsLock(this));
        this.fireEvent(stateInfo);
    }

    protected void fireFailed(Exception e) {
        assert (!Thread.holdsLock(this));
        LOGGER.log(Level.SEVERE, "Error in " + this + ":", e);
        this.fireEvent(new ExceptionStateInfo(e));
    }

    protected void fireFailed(RvConnectionEvent e) {
        this.fireEvent(new FailureEventInfo(e));
    }

    protected void fireFailed(FailedStateInfo info) {
        this.fireEvent(info);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireEvent(StateInfo e) {
        assert (!Thread.holdsLock(this));
        boolean succeeded = e instanceof SuccessfulStateInfo;
        boolean failed = e instanceof FailedStateInfo;
        if (!succeeded && !failed) {
            throw new IllegalArgumentException("invalid state " + e + ": it must be either SuccessfulStateInfo or " + "FailedStateInfo");
        }
        AbstractStateController abstractStateController = this;
        synchronized (abstractStateController) {
            if (this.endState != null) {
                LOGGER.info("State controller " + this + " tried to set new end state " + e + " but it was " + "already " + this.endState);
                return;
            }
            this.endState = e;
        }
        LOGGER.log(Level.FINE, "New state for " + this.getClass().getName() + ": " + e);
        if (succeeded) {
            SuccessfulStateInfo successfulStateInfo = (SuccessfulStateInfo)e;
            for (ControllerListener listener : this.listeners) {
                listener.handleControllerSucceeded(this, successfulStateInfo);
            }
        } else {
            FailedStateInfo failedStateInfo = (FailedStateInfo)e;
            for (ControllerListener listener : this.listeners) {
                listener.handleControllerFailed(this, failedStateInfo);
            }
        }
    }

    public synchronized StateInfo getEndStateInfo() {
        return this.endState;
    }

    public String toString() {
        return MiscTools.getClassName(this);
    }
}

