/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.gui.main.chat.conference;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import net.java.sip.communicator.impl.gui.GuiActivator;
import net.java.sip.communicator.impl.gui.main.call.CallManager;
import net.java.sip.communicator.impl.gui.main.chat.ChatPanel;
import net.java.sip.communicator.impl.gui.main.chat.conference.ChatRoomConferenceCallsListPanel;
import net.java.sip.communicator.plugin.desktoputil.SIPCommDialog;
import net.java.sip.communicator.plugin.desktoputil.TransparentPanel;
import net.java.sip.communicator.service.muc.ChatRoomWrapper;
import net.java.sip.communicator.service.protocol.ChatRoom;
import net.java.sip.communicator.service.protocol.ConferenceDescription;
import net.java.sip.communicator.service.protocol.OperationSetTelephonyConferencing;
import net.java.sip.communicator.util.skin.Skinnable;

public class ChatConferenceCallDialog
extends SIPCommDialog
implements ActionListener,
Skinnable {
    private final JRadioButton createConferenceButton = new JRadioButton(GuiActivator.getResources().getI18NString("service.gui.CREATE_VIDEO_CONFERENCE"));
    private final JRadioButton joinConferenceButton = new JRadioButton(GuiActivator.getResources().getI18NString("service.gui.JOIN_EXISTING_VIDEO_CONFERENCE"));
    private final JPanel mainPanel = new TransparentPanel((LayoutManager)new BorderLayout(10, 10));
    private final JPanel joinPanel = new TransparentPanel((LayoutManager)new BorderLayout(5, 5));
    private final JPanel createPanel = new TransparentPanel((LayoutManager)new BorderLayout());
    private final JTextField name = new JTextField();
    private ChatRoomConferenceCallsListPanel chatConferenceListPanel;
    private JButton okButton = new JButton(GuiActivator.getResources().getI18NString("service.gui.OK"));
    private JButton cancelButton = new JButton(GuiActivator.getResources().getI18NString("service.gui.CANCEL"));
    private JButton endConference = new JButton(GuiActivator.getResources().getI18NString("service.gui.END_CONFERENCE"));
    private ChatPanel chatPanel = null;
    private ChatRoom chatRoom = null;

    public ChatConferenceCallDialog(ChatPanel chatPanel) {
        super((Frame)((Object)GuiActivator.getUIService().getMainFrame()));
        this.setTitle(GuiActivator.getResources().getI18NString("service.gui.CREATE_JOIN_VIDEO_CONFERENCE"));
        this.chatConferenceListPanel = new ChatRoomConferenceCallsListPanel(chatPanel);
        this.chatPanel = chatPanel;
        Object o = chatPanel.getChatSession().getDescriptor();
        if (o instanceof ChatRoomWrapper) {
            this.chatRoom = ((ChatRoomWrapper)o).getChatRoom();
        }
        this.initButtons();
        this.initPanels();
        this.add(this.mainPanel, "North");
    }

    private void initPanels() {
        TransparentPanel conferenceNamePanel = new TransparentPanel((LayoutManager)new BorderLayout(10, 10));
        JLabel nameLabel = new JLabel(GuiActivator.getResources().getI18NString("service.gui.NAME"));
        conferenceNamePanel.add((Component)nameLabel, "West");
        conferenceNamePanel.add((Component)this.name, "Center");
        this.name.setEditable(true);
        this.name.setColumns(30);
        if (this.chatRoom != null) {
            this.name.setText(GuiActivator.getResources().getI18NString("service.gui.CHAT_CONFERENCE_ITEM_LABEL", new String[]{this.chatRoom.getUserNickname()}));
        }
        this.createPanel.add((Component)conferenceNamePanel, "Center");
        this.createPanel.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 10));
        JLabel selectConferenceLabel = new JLabel(GuiActivator.getResources().getI18NString("service.gui.SELECT_VIDEO_CONFERENCE"));
        this.joinPanel.add((Component)selectConferenceLabel, "North");
        this.joinPanel.add((Component)this.chatConferenceListPanel, "Center");
        this.joinPanel.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 10));
    }

    private void initButtons() {
        TransparentPanel createOrJoinChoicePanel = new TransparentPanel((LayoutManager)new BorderLayout(10, 10));
        this.createConferenceButton.addActionListener(this);
        this.joinConferenceButton.addActionListener(this);
        this.createConferenceButton.setOpaque(false);
        this.joinConferenceButton.setOpaque(false);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.createConferenceButton);
        buttonGroup.add(this.joinConferenceButton);
        createOrJoinChoicePanel.add((Component)this.createConferenceButton, "North");
        createOrJoinChoicePanel.add((Component)this.joinConferenceButton, "Center");
        createOrJoinChoicePanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 0, 10));
        this.mainPanel.add((Component)createOrJoinChoicePanel, "North");
        TransparentPanel buttonPanel = new TransparentPanel((LayoutManager)new FlowLayout(2));
        this.endConference.setEnabled(false);
        this.endConference.addActionListener(this);
        this.okButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        buttonPanel.add(this.endConference);
        buttonPanel.add(this.okButton);
        buttonPanel.add(this.cancelButton);
        this.mainPanel.add((Component)buttonPanel, "South");
    }

    public void setVisible(boolean isVisible) {
        if (isVisible) {
            this.setSelectedRadioButton(this.chatConferenceListPanel.getListSize() == 0 && this.createConferenceButton.isEnabled());
        }
        super.setVisible(isVisible);
    }

    public void setSelectedRadioButton(boolean isCreateSelected) {
        if (isCreateSelected) {
            this.createConferenceButton.setSelected(true);
        } else {
            this.joinConferenceButton.setSelected(true);
        }
        this.updateView();
    }

    public void setCreatePanelEnabled(boolean enabled) {
        if (!enabled) {
            this.setSelectedRadioButton(false);
            this.createConferenceButton.setEnabled(false);
        } else {
            this.createConferenceButton.setEnabled(true);
        }
    }

    public void setEndConferenceButtonEnabled(boolean enabled) {
        this.endConference.setEnabled(enabled);
    }

    public void initConferences() {
        this.chatConferenceListPanel.initConferences();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source instanceof JButton) {
            if (source.equals(this.okButton)) {
                if (this.createConferenceButton.isSelected()) {
                    this.createConference();
                } else {
                    this.joinConference();
                }
            } else if (source.equals(this.endConference)) {
                this.chatRoom.publishConference(null, null);
            }
            this.setVisible(false);
        } else if (source instanceof JRadioButton && (source.equals(this.createConferenceButton) || source.equals(this.joinConferenceButton))) {
            this.updateView();
        }
    }

    private void updateView() {
        this.mainPanel.remove(this.createConferenceButton.isSelected() ? this.joinPanel : this.createPanel);
        this.mainPanel.add((Component)(this.createConferenceButton.isSelected() ? this.createPanel : this.joinPanel), "Center");
        if (this.joinConferenceButton.isSelected()) {
            this.chatConferenceListPanel.setSelectedIndex(0);
        }
        this.pack();
    }

    private void createConference() {
        if (this.chatRoom == null) {
            return;
        }
        String conferenceName = this.name.getText();
        OperationSetTelephonyConferencing telephonyConferencing = (OperationSetTelephonyConferencing)this.chatRoom.getParentProvider().getOperationSet(OperationSetTelephonyConferencing.class);
        ConferenceDescription cd = null;
        if (telephonyConferencing != null) {
            cd = telephonyConferencing.setupConference(this.chatRoom);
        }
        if (cd != null) {
            this.chatRoom.publishConference(cd, conferenceName);
        }
    }

    private void joinConference() {
        ConferenceDescription chatConference = this.chatConferenceListPanel.getSelectedValue();
        if (chatConference != null) {
            CallManager.call(this.chatPanel.getChatSession().getCurrentChatTransport().getProtocolProvider(), chatConference, this.chatRoom);
        }
    }

    public void loadSkin() {
        this.chatConferenceListPanel.loadSkin();
    }

    public void addConference(ConferenceDescription conferenceDescription) {
        this.chatConferenceListPanel.addConference(conferenceDescription);
    }

    public void removeConference(ConferenceDescription conferenceDescription) {
        this.chatConferenceListPanel.removeConference(conferenceDescription);
    }
}

