/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.globaldisplaydetails;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import net.java.sip.communicator.impl.globaldisplaydetails.GlobalDisplayDetailsActivator;
import net.java.sip.communicator.service.gui.UIService;
import net.java.sip.communicator.service.protocol.OperationFailedException;
import net.java.sip.communicator.service.protocol.OperationSetPresence;
import net.java.sip.communicator.service.protocol.PresenceStatus;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import net.java.sip.communicator.service.protocol.RegistrationState;
import net.java.sip.communicator.service.protocol.event.RegistrationStateChangeEvent;
import net.java.sip.communicator.service.protocol.event.RegistrationStateChangeListener;
import net.java.sip.communicator.service.protocol.globalstatus.GlobalStatusEnum;
import net.java.sip.communicator.service.protocol.globalstatus.GlobalStatusService;
import net.java.sip.communicator.util.Logger;
import net.java.sip.communicator.util.account.AccountStatusUtils;
import net.java.sip.communicator.util.account.AccountUtils;
import net.java.sip.communicator.util.account.LoginManager;
import org.jitsi.service.configuration.ConfigurationService;

public class GlobalStatusServiceImpl
implements GlobalStatusService,
RegistrationStateChangeListener {
    private final Logger logger = Logger.getLogger(GlobalStatusServiceImpl.class);

    void handleProviderAdded(ProtocolProviderService pps) {
        pps.addRegistrationStateChangeListener((RegistrationStateChangeListener)this);
        if (pps.isRegistered()) {
            this.handleProviderRegistered(pps, false);
        }
    }

    void handleProviderRemoved(ProtocolProviderService pps) {
        pps.removeRegistrationStateChangeListener((RegistrationStateChangeListener)this);
    }

    public PresenceStatus getGlobalPresenceStatus() {
        int status = 0;
        Collection pProviders = AccountUtils.getRegisteredProviders();
        if (pProviders == null || pProviders.size() <= 0) {
            return this.getPresenceStatus(status);
        }
        Iterator providersIter = pProviders.iterator();
        boolean hasAvailableProvider = false;
        while (providersIter.hasNext()) {
            ProtocolProviderService protocolProvider = (ProtocolProviderService)providersIter.next();
            if (protocolProvider.getAccountID().isHidden() || !protocolProvider.isRegistered()) continue;
            OperationSetPresence presence = (OperationSetPresence)protocolProvider.getOperationSet(OperationSetPresence.class);
            if (presence == null) {
                hasAvailableProvider = true;
                continue;
            }
            int presenceStatus = presence == null ? 50 : presence.getPresenceStatus().getStatus();
            if (status >= presenceStatus) continue;
            status = presenceStatus;
        }
        if (status == 0 && hasAvailableProvider) {
            status = 50;
        }
        return this.getPresenceStatus(status);
    }

    private PresenceStatus getPresenceStatus(int status) {
        if (status < 20) {
            return GlobalStatusEnum.OFFLINE;
        }
        if (status < 31) {
            return GlobalStatusEnum.DO_NOT_DISTURB;
        }
        if (status < 36) {
            return GlobalStatusEnum.EXTENDED_AWAY;
        }
        if (status < 50) {
            return GlobalStatusEnum.AWAY;
        }
        if (status < 80) {
            return GlobalStatusEnum.ONLINE;
        }
        if (status < 100) {
            return GlobalStatusEnum.FREE_FOR_CHAT;
        }
        return GlobalStatusEnum.OFFLINE;
    }

    public PresenceStatus getLastPresenceStatus(ProtocolProviderService protocolProvider) {
        String lastStatus = this.getLastStatusString(protocolProvider);
        PresenceStatus status = null;
        if (lastStatus != null) {
            OperationSetPresence presence = (OperationSetPresence)protocolProvider.getOperationSet(OperationSetPresence.class);
            if (presence == null) {
                return null;
            }
            Iterator i = presence.getSupportedStatusSet();
            while (i.hasNext()) {
                PresenceStatus nextStatus = (PresenceStatus)i.next();
                if (!nextStatus.getStatusName().equals(lastStatus)) continue;
                status = nextStatus;
            }
            if (status == null) {
                if (lastStatus.equals("Online")) {
                    status = this.getPresenceStatus(protocolProvider, 50, 80);
                } else if (lastStatus.equals("Away")) {
                    status = this.getPresenceStatus(protocolProvider, 36, 50);
                } else if (lastStatus.equals("Extended Away")) {
                    status = this.getPresenceStatus(protocolProvider, 31, 36);
                } else if (lastStatus.equals("Do Not Disturb")) {
                    status = this.getPresenceStatus(protocolProvider, 20, 31);
                } else if (lastStatus.equals("Free For Chat")) {
                    status = this.getPresenceStatus(protocolProvider, 50, 100);
                } else if (lastStatus.equals("Offline")) {
                    status = this.getPresenceStatus(protocolProvider, 0, 20);
                }
            }
        }
        return status;
    }

    public String getLastStatusString(ProtocolProviderService protocolProvider) {
        String accountRootPropName;
        String accountUID;
        String lastStatus = null;
        ConfigurationService configService = GlobalDisplayDetailsActivator.getConfigurationService();
        String prefix = "net.java.sip.communicator.impl.gui.accounts";
        List accounts = configService.getPropertyNamesByPrefix(prefix, true);
        String protocolProviderAccountUID = protocolProvider.getAccountID().getAccountUniqueID();
        Iterator iterator = accounts.iterator();
        while (iterator.hasNext() && (!(accountUID = configService.getString(accountRootPropName = (String)iterator.next())).equals(protocolProviderAccountUID) || (lastStatus = configService.getString(accountRootPropName + ".lastAccountStatus")) == null)) {
        }
        return lastStatus;
    }

    public void publishStatus(ProtocolProviderService protocolProvider, PresenceStatus status) {
        this.publishStatusInternal(protocolProvider, status, false);
    }

    private void publishStatusInternal(ProtocolProviderService protocolProvider, PresenceStatus status, boolean dueToRegistrationStateChanged) {
        RegistrationState registrationState;
        OperationSetPresence presence = (OperationSetPresence)protocolProvider.getOperationSet(OperationSetPresence.class);
        LoginManager loginManager = null;
        UIService uiService = GlobalDisplayDetailsActivator.getUIService();
        if (uiService != null) {
            loginManager = uiService.getLoginManager();
        }
        if ((registrationState = protocolProvider.getRegistrationState()) == RegistrationState.REGISTERED && presence != null && !presence.getPresenceStatus().equals((Object)status)) {
            if (status.isOnline()) {
                new PublishPresenceStatusThread(protocolProvider, presence, status).start();
            } else {
                if (loginManager != null) {
                    loginManager.setManuallyDisconnected(true);
                }
                LoginManager.logoff((ProtocolProviderService)protocolProvider);
            }
        } else if (registrationState != RegistrationState.REGISTERED && registrationState != RegistrationState.REGISTERING && registrationState != RegistrationState.AUTHENTICATING && status.isOnline()) {
            if (dueToRegistrationStateChanged) {
                this.logger.warn((Object)("Called publish status for provider in wrong state  provider: " + protocolProvider + " registrationState: " + registrationState + " status: " + status));
                return;
            }
            GlobalDisplayDetailsActivator.getUIService().getLoginManager().login(protocolProvider);
        } else if (!status.isOnline() && registrationState != RegistrationState.UNREGISTERING) {
            if (loginManager != null) {
                loginManager.setManuallyDisconnected(true);
            }
            LoginManager.logoff((ProtocolProviderService)protocolProvider);
        }
        this.saveStatusInformation(protocolProvider, status.getStatusName());
    }

    public void publishStatus(GlobalStatusEnum globalStatus) {
        String itemName = globalStatus.getStatusName();
        block2: for (ProtocolProviderService protocolProvider : AccountUtils.getRegisteredProviders()) {
            PresenceStatus status;
            Iterator statusSet;
            OperationSetPresence presence;
            if (itemName.equals("Online")) {
                if (!protocolProvider.isRegistered()) {
                    this.saveStatusInformation(protocolProvider, itemName);
                    GlobalDisplayDetailsActivator.getUIService().getLoginManager().login(protocolProvider);
                    continue;
                }
                presence = (OperationSetPresence)protocolProvider.getOperationSet(OperationSetPresence.class);
                if (presence == null) {
                    this.saveStatusInformation(protocolProvider, itemName);
                    continue;
                }
                statusSet = presence.getSupportedStatusSet();
                while (statusSet.hasNext()) {
                    status = (PresenceStatus)statusSet.next();
                    if (status.getStatus() >= 80 || status.getStatus() < 50) continue;
                    new PublishPresenceStatusThread(protocolProvider, presence, status).start();
                    this.saveStatusInformation(protocolProvider, status.getStatusName());
                    continue block2;
                }
                continue;
            }
            if (itemName.equals("Offline")) {
                if (protocolProvider.getRegistrationState().equals((Object)RegistrationState.UNREGISTERED) || protocolProvider.getRegistrationState().equals((Object)RegistrationState.UNREGISTERING)) continue;
                presence = (OperationSetPresence)protocolProvider.getOperationSet(OperationSetPresence.class);
                if (presence == null) {
                    this.saveStatusInformation(protocolProvider, itemName);
                    LoginManager.logoff((ProtocolProviderService)protocolProvider);
                    continue;
                }
                statusSet = presence.getSupportedStatusSet();
                while (statusSet.hasNext()) {
                    status = (PresenceStatus)statusSet.next();
                    if (status.getStatus() >= 20) continue;
                    this.saveStatusInformation(protocolProvider, status.getStatusName());
                    break;
                }
                try {
                    protocolProvider.unregister(true);
                }
                catch (OperationFailedException e1) {
                    this.logger.error((Object)("Unable to unregister the protocol provider: " + protocolProvider + " due to the following exception: " + (Object)((Object)e1)));
                }
                continue;
            }
            if (itemName.equals("Free For Chat")) {
                if (!protocolProvider.isRegistered()) {
                    this.saveStatusInformation(protocolProvider, itemName);
                    GlobalDisplayDetailsActivator.getUIService().getLoginManager().login(protocolProvider);
                    continue;
                }
                this.publishStatus(protocolProvider, 50, 100);
                continue;
            }
            if (itemName.equals("Do Not Disturb")) {
                if (!protocolProvider.isRegistered()) {
                    this.saveStatusInformation(protocolProvider, itemName);
                    GlobalDisplayDetailsActivator.getUIService().getLoginManager().login(protocolProvider);
                    continue;
                }
                this.publishStatus(protocolProvider, 20, 31);
                continue;
            }
            if (itemName.equals("Away")) {
                if (!protocolProvider.isRegistered()) {
                    this.saveStatusInformation(protocolProvider, itemName);
                    GlobalDisplayDetailsActivator.getUIService().getLoginManager().login(protocolProvider);
                    continue;
                }
                this.publishStatus(protocolProvider, 36, 50);
                continue;
            }
            if (!itemName.equals("Extended Away")) continue;
            if (!protocolProvider.isRegistered()) {
                this.saveStatusInformation(protocolProvider, itemName);
                GlobalDisplayDetailsActivator.getUIService().getLoginManager().login(protocolProvider);
                continue;
            }
            this.publishStatus(protocolProvider, 31, 36);
        }
    }

    private void publishStatus(ProtocolProviderService protocolProvider, int floorStatusValue, int ceilStatusValue) {
        if (!protocolProvider.isRegistered()) {
            return;
        }
        PresenceStatus status = this.getPresenceStatus(protocolProvider, floorStatusValue, ceilStatusValue);
        if (status != null) {
            OperationSetPresence presence = (OperationSetPresence)protocolProvider.getOperationSet(OperationSetPresence.class);
            new PublishPresenceStatusThread(protocolProvider, presence, status).start();
            this.saveStatusInformation(protocolProvider, status.getStatusName());
        }
    }

    private PresenceStatus getPresenceStatus(ProtocolProviderService protocolProvider, int floorStatusValue, int ceilStatusValue) {
        OperationSetPresence presence = (OperationSetPresence)protocolProvider.getOperationSet(OperationSetPresence.class);
        if (presence == null) {
            return null;
        }
        Iterator statusSet = presence.getSupportedStatusSet();
        PresenceStatus status = null;
        while (statusSet.hasNext()) {
            PresenceStatus currentStatus = (PresenceStatus)statusSet.next();
            if (status == null && currentStatus.getStatus() < ceilStatusValue && currentStatus.getStatus() >= floorStatusValue) {
                status = currentStatus;
            }
            if (status == null || currentStatus.getStatus() >= ceilStatusValue || currentStatus.getStatus() < floorStatusValue || currentStatus.getStatus() <= status.getStatus()) continue;
            status = currentStatus;
        }
        return status;
    }

    private void saveStatusInformation(ProtocolProviderService protocolProvider, String statusName) {
        ConfigurationService configService = GlobalDisplayDetailsActivator.getConfigurationService();
        String prefix = "net.java.sip.communicator.impl.gui.accounts";
        List accounts = configService.getPropertyNamesByPrefix(prefix, true);
        boolean savedAccount = false;
        for (String accountRootPropName : accounts) {
            String accountUID = configService.getString(accountRootPropName);
            if (!accountUID.equals(protocolProvider.getAccountID().getAccountUniqueID())) continue;
            configService.setProperty(accountRootPropName + ".lastAccountStatus", (Object)statusName);
            savedAccount = true;
        }
        if (!savedAccount) {
            String accNodeName = "acc" + Long.toString(System.currentTimeMillis());
            String accountPackage = "net.java.sip.communicator.impl.gui.accounts." + accNodeName;
            configService.setProperty(accountPackage, (Object)protocolProvider.getAccountID().getAccountUniqueID());
            configService.setProperty(accountPackage + ".lastAccountStatus", (Object)statusName);
        }
    }

    public void registrationStateChanged(RegistrationStateChangeEvent evt) {
        if (!evt.getNewState().equals((Object)RegistrationState.REGISTERED)) {
            return;
        }
        this.handleProviderRegistered(evt.getProvider(), true);
    }

    private void handleProviderRegistered(ProtocolProviderService pps, boolean dueToRegistrationStateChanged) {
        PresenceStatus status = this.getLastPresenceStatus(pps);
        if (status == null) {
            status = AccountStatusUtils.getOnlineStatus((ProtocolProviderService)pps);
        }
        if (status != null && status.getStatus() >= 20) {
            this.publishStatusInternal(pps, status, dueToRegistrationStateChanged);
        }
    }

    private class PublishPresenceStatusThread
    extends Thread {
        private ProtocolProviderService protocolProvider;
        private PresenceStatus status;
        private OperationSetPresence presence;

        public PublishPresenceStatusThread(ProtocolProviderService protocolProvider, OperationSetPresence presence, PresenceStatus status) {
            this.protocolProvider = protocolProvider;
            this.presence = presence;
            this.status = status;
        }

        @Override
        public void run() {
            try {
                this.presence.publishPresenceStatus(this.status, "");
            }
            catch (IllegalArgumentException e1) {
                GlobalStatusServiceImpl.this.logger.error((Object)"Error - changing status", (Throwable)e1);
            }
            catch (IllegalStateException e1) {
                GlobalStatusServiceImpl.this.logger.error((Object)"Error - changing status", (Throwable)e1);
            }
            catch (OperationFailedException e1) {
                if (e1.getErrorCode() == 1) {
                    String msgText = GlobalDisplayDetailsActivator.getResources().getI18NString("service.gui.STATUS_CHANGE_GENERAL_ERROR", new String[]{this.protocolProvider.getAccountID().getUserID(), this.protocolProvider.getAccountID().getService()});
                    GlobalDisplayDetailsActivator.getAlertUIService().showAlertDialog(GlobalDisplayDetailsActivator.getResources().getI18NString("service.gui.GENERAL_ERROR"), msgText, (Throwable)e1);
                } else if (e1.getErrorCode() == 2) {
                    String msgText = GlobalDisplayDetailsActivator.getResources().getI18NString("service.gui.STATUS_CHANGE_NETWORK_FAILURE", new String[]{this.protocolProvider.getAccountID().getUserID(), this.protocolProvider.getAccountID().getService()});
                    GlobalDisplayDetailsActivator.getAlertUIService().showAlertDialog(msgText, GlobalDisplayDetailsActivator.getResources().getI18NString("service.gui.NETWORK_FAILURE"), (Throwable)e1);
                } else if (e1.getErrorCode() == 3) {
                    String msgText = GlobalDisplayDetailsActivator.getResources().getI18NString("service.gui.STATUS_CHANGE_NETWORK_FAILURE", new String[]{this.protocolProvider.getAccountID().getUserID(), this.protocolProvider.getAccountID().getService()});
                    GlobalDisplayDetailsActivator.getAlertUIService().showAlertDialog(GlobalDisplayDetailsActivator.getResources().getI18NString("service.gui.NETWORK_FAILURE"), msgText, (Throwable)e1);
                }
                GlobalStatusServiceImpl.this.logger.error((Object)"Error - changing status", (Throwable)e1);
            }
        }
    }
}

