/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.utility;

import java.io.IOException;
import java.io.OutputStream;

public class ByteBufferOutputStream
extends OutputStream {
    private final int beginIndex;
    private final byte[] buf;
    private final int endIndex;
    private int index;

    public ByteBufferOutputStream(byte[] buf) {
        this(buf, 0, buf.length);
    }

    public ByteBufferOutputStream(byte[] buf, int off, int len) {
        if (buf == null) {
            throw new NullPointerException("buf");
        }
        if (off < 0) {
            throw new IndexOutOfBoundsException("off");
        }
        if (len > buf.length) {
            throw new IndexOutOfBoundsException("len");
        }
        this.buf = buf;
        this.beginIndex = off;
        this.index = off;
        this.endIndex = off + len;
    }

    public int size() {
        return this.index - this.beginIndex;
    }

    @Override
    public void write(int b) throws IOException {
        if (this.index >= this.endIndex) {
            throw new IOException("This " + ByteBufferOutputStream.class.getName() + " is fully written.");
        }
        this.buf[this.index++] = (byte)b;
    }
}

